(herald (back_end risclocgen)
  (env t (orbit_top defs) (back_end bookkeep)))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

;;; Copyright (c) 1985 David Kranz
                             
(define (generate-set-location node)    ;; cont type-primop value . args
  ((xselect (length (call-args node))
     ((4) generate-set-fixed-accessor)
     ((5) generate-set-vector-elt))
   node))

;;; We assume these offsets are less than the maximum, 16 bits or whatever

(define (generate-set-fixed-accessor node)
  (destructure (((#f type value loc) (call-args node)))
    (let* ((prim (leaf-value type))
	   (loc (leaf-value loc))
           (do-it 
            (lambda (access)
              (cond ((and (eq? prim primop/cell-value)
                          (eq? (variable-definition loc) 'one))
                     (let ((lc (lookup-value node loc)))
		       (if (register? lc)
			   (generate-move access lc)
			   (emit risc/store 'l access lc))
                       (cond ((and (register? lc) (temp-loc loc))
                              => (lambda (lc)
                                   (set (temp-node lc) nil)
                                   (set (temp-loc loc) nil))))))
                    (else
                     (let ((reg (->register node loc)))
                       (emit risc/store 'l
			access
			(reg-offset reg (primop.location-specs prim)))))))))
             (let ((reg (cond ((lambda-node? value)
			       (access/make-closure node value))
			      (else
			       (->register node (leaf-value value))))))
               (lock reg)
               (do-it reg)
               (unlock reg)))))

                    
(define (generate-set-vector-type-length node)
  (destructure (((#f vec val) (call-args node)))
    (let ((breg (->register node (leaf-value vec)))
          (var (leaf-value val)))
      (lock breg)
      (generate-move (lookup-value node var) scratch)
      (emit risc/sll (machine-num 6) scratch scratch)
      (emit risc/or (machine-num header/slice) scratch scratch)
      (emit risc/store 'l scratch (reg-offset breg -2))
      (unlock breg))))
               
                                                     
                    
(define (generate-set-vector-elt node)
  (destructure (((#f type value loc idex) (call-args node)))
    (let* ((primop (leaf-value type))
	   (rep (primop.rep-wants primop))
	   (location (leaf-value loc))
	   (idex (leaf-value idex))
	   (reg (->register node location)))
      (lock reg)
      (let* ((access (if (lambda-node? value)
			 (access/make-closure node value)
			 (->register node (leaf-value value)))))
	(lock access)
	(case rep
	  ((rep/pointer)
	   (cond ((and (fixnum? idex) (fx<= (fx* idex 4) *max-extend-displ*))
		  (emit risc/store 'l access
			(reg-offset reg (fx+ (fx* idex 4) 2))))
		 (else
		  (emit risc/add reg (->register node idex) VECTOR)
		  (emit risc/store 'l access (reg-offset VECTOR 2)))))
	  ((rep/string)
	   (emit risc/load 'l (reg-offset reg 6) VECTOR)
	   (emit risc/sra (machine-num 2) (->register node idex) scratch)
	   (emit risc/add scratch VECTOR VECTOR)
	   (emit risc/load 'l (reg-offset reg 2) extra)
	   (emit risc/sra (machine-num 8) access scratch)
	   (emit risc/add extra VECTOR VECTOR)
	   (emit risc/store 'b scratch (reg-offset VECTOR 2)))
	  (else
	   (cond ((and (fixnum? idex) (fx<= idex *max-extend-displ*))
		  (if (eq? rep 'rep/char)
		      (emit risc/sra (machine-num 8) access scratch)
		      (emit risc/sra (machine-num 2) access scratch))
		  (emit risc/store (store-size rep) scratch
			(reg-offset reg (fx+ idex 2))))
		 (else
		  (let ((i-reg (->register node idex)))
		    (if (eq? rep 'rep/char)
			(emit risc/sra (machine-num 8) access scratch)
			(emit risc/sra (machine-num 2) access scratch))
		    (emit risc/sra (machine-num 2) i-reg VECTOR)
		    (emit risc/add reg VECTOR VECTOR)
		    (emit risc/store (store-size rep)
			  scratch (reg-offset VECTOR 2)))))))
	(unlock reg)
	(unlock access)))))

(define (store-size rep)
  (xcase rep
    ((rep/integer) 'l)
    ((rep/integer-16-u rep/integer-16-s) 'w)
    ((rep/integer-8-u rep/integer-8-s rep/char) 'b)))
                        
(define (generate-contents-location node)
  ((xselect (length (call-args node))
     ((3) generate-fixed-accessor)
     ((4) generate-vector-elt))
   node))


(define (generate-fixed-accessor node)
  (destructure (((cont type loc) (call-args node)))
   (if (or (leaf-node? cont) (used? (car (lambda-variables cont))))   
         (let* ((type (leaf-value type))
                (base (leaf-value loc)))
           (cond ((and (eq? type primop/cell-value)
                       (eq? (variable-definition base) 'one))
		  (let ((access (lookup-value node base)))
		    (protect-access access)
		    (let ((target (get-target-register node cont nil nil)))
		      (release-access access)
		      (generate-move access target)
		      (mark-continuation node target))))
                 (else
                  (let* ((reg (->register node base))
			 (target (get-target-register node cont reg nil)))
                    (emit risc/load 'l (reg-offset reg (primop.location-specs type))
                                   target)
		    (mark-continuation node target))))))))

 

                                               
(define (generate-vector-type-length node)
  (destructure (((cont vec) (call-args node)))
      (let* ((base (leaf-value vec))
             (reg (->register node base))
	     (target (get-target-register node cont reg nil)))
        (emit risc/load 'l (reg-offset reg -2) scratch)
	(emit risc/srl (machine-num 8) scratch scratch)
	(emit risc/sll (machine-num 2) scratch target)
        (mark-continuation node target))))

                                               

(define (generate-vector-elt node)
  (destructure (((cont type loc idex) (call-args node)))
      (let* ((base (leaf-value loc))
	     (idex (leaf-value idex))
	     (rep (primop.rep-wants (leaf-value type)))
	     (reg (->register node base)))
	(lock reg)
	(let ((I-reg (cond ((variable? idex)
			    (->register node idex))
			   ((and (eq? rep 'rep/pointer)
				 (fx<= (fx* idex 4) *max-extend-displ*))
			    nil)
			   ((fx<= idex *max-extend-displ*) nil)
			   (else (->register node idex)))))
	  (unlock reg)
	  (let ((t-reg (get-target-register node cont reg i-reg)))
	    (case rep
	      ((rep/pointer)
	       (cond ((null? i-reg)
		      (emit risc/load 'l (reg-offset reg (fx+ (fx* idex 4) 2))
			    t-reg))
		     (else
		      (emit risc/add reg i-reg VECTOR)
		      (emit risc/load 'l (reg-offset VECTOR 2) t-reg))))
	      ((rep/string)
	       (emit risc/load 'l (reg-offset reg 6) VECTOR)
	       (cond ((null? i-reg)
		      (emit risc/add (machine-num idex) vector vector))
		     (else
		      (emit risc/sra (machine-num 2) i-reg scratch)
		      (emit risc/add scratch VECTOR VECTOR)))
	       (emit risc/load 'l (reg-offset reg 2) extra)
	       (emit risc/add extra VECTOR VECTOR)
	       (emit risc/load 'ub (reg-offset VECTOR 2) scratch)
	       (emit risc/sll (machine-num 8) scratch t-reg)
	       (emit risc/or (machine-num header/char) t-reg t-reg))
	      (else
	       (let ((inst  (xcase rep
				   ((rep/integer) 'l)
				   ((rep/integer-16-s) 'sw)
				   ((rep/integer-16-u) 'uw)
				   ((rep/integer-8-s) 'sb)
				   ((rep/integer-8-u rep/char) 'ub))))
		 (cond ((null? i-reg)
			(emit risc/load inst (reg-offset reg (fx+ idex 2)) scratch))
		       (else
			(emit risc/sra (machine-num 2) i-reg VECTOR)
			(emit risc/add reg VECTOR VECTOR)
			(emit risc/load inst (reg-offset VECTOR 2) scratch)))
		 (cond ((neq? rep 'rep/char)
			(emit risc/sll (machine-num 2) scratch t-reg))
		       (else
			(emit risc/sll (machine-num 8) scratch t-reg)
			(emit risc/or (machine-num header/char)
			      t-reg t-reg))))))
	    (mark-continuation node t-reg))))))

(define (generate-make-pointer node)
  (destructure (((cont loc idex) (call-args node)))
      (let* ((base (leaf-value loc))
	     (index (leaf-value idex))
	     (reg (->register node base)))
	(lock reg)
	(let ((I-reg (if (and (fixnum? index)
			      (fx<= (fx* index 4) (fx- *max-extend-displ* 4)))
			 (machine-num (fx+ (fx* index 4) 4))
			 (->register node index))))
	  (unlock reg)
	  (let ((t-reg (get-target-register node cont reg i-reg)))
	    (emit risc/add i-reg reg t-reg)
	    (if (register? i-reg)
		(emit risc/add (machine-num 4) t-reg t-reg))
	    (mark-continuation node t-reg))))))


                    
(define (generate-%chdr node)
  (destructure (((#f vec val) (call-args node)))
    (let ((reg (->register node (leaf-value vec)))
          (val (leaf-value val)))
      (lock reg)                                              
      (cond ((and (fixnum? val) (fx<= (fixnum-ashl val 8) *max-displ*))
	     (emit risc/load 'l (reg-offset reg -2) extra)
	     (emit risc/sub (machine-num (fixnum-ashl val 8)) extra extra)
	     (emit risc/store 'l extra (reg-offset reg -2))
	     (emit risc/load 'l (reg-offset reg 6) scratch)
	     (emit risc/add (machine-num val) scratch scratch)
             (emit risc/store 'l scratch (reg-offset reg 6)))
            (else
             (let* ((val (->register node val)))
	       (emit risc/load 'l (reg-offset reg -2) extra)
	       (emit risc/sll (machine-num 6) val scratch)
	       (emit risc/sub scratch extra extra)
	       (emit risc/store 'l extra (reg-offset reg -2))
	       (emit risc/load 'l (reg-offset reg 6) scratch)
	       (emit risc/srl (machine-num 2) val VECTOR)
	       (emit risc/add VECTOR scratch scratch)
	       (emit risc/store 'l scratch (reg-offset reg 6)))))
      (unlock reg))))