(herald (back_end sparithgen)
  (env t (orbit_top defs)))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

(define (machine-op inst)
  (xcase inst
    ((add) risc/add)
    ((sub) risc/sub)
    ((or) risc/or)
    ((xor) risc/xor)
    ((and) risc/and)))

(define (fixnum-comparator node inst)       
  (comparator node inst))

(define (character-comparator node inst)
  (comparator node inst))

(define (eq?-comparator node)
  (comparator node jump-op/jn=))


(define (comparator node jump-op)
  (destructure (((then else () ref1 ref2) (call-args node)))
    (let* ((val1 (leaf-value ref1))
           (val2 (leaf-value ref2)))
        (let ((acc2 (arith->addressable node val2 'cmp)))
          (protect-access acc2)
	  (let ((acc1 (arith->addressable node val1 'cmp)))
	    (cond ((register? acc1)
		   (emit-compare jump-op
				 acc1 acc2 else then))
		  ((register? acc2)
		   (emit-compare (reverse-jump-ops jump-op) acc2 acc1 else then))
		  (t
		   (generate-move acc1 extra)
		   (emit-compare jump-op extra acc2 else then))))
          (release-access acc2)))))

(define (generate-numeric-op node inst)
  (destructure (((cont right left) (call-args node)))
      (let* ((lvar (leaf-value left))
             (rvar (leaf-value right))
             (l-acc (arith->addressable node lvar inst)))
        (protect-access l-acc)
        (let ((r-acc (arith->addressable node rvar inst)))
          (release-access l-acc)
	  (let ((t-reg (get-target-register node cont l-acc r-acc)))
	    (receive (r-acc l-acc)
	      (cond ((register? r-acc) (return r-acc l-acc))
		    ((and (register? l-acc)
			  (memq? inst '(add and or xor)))
		     (return l-acc r-acc))
		    ((fx= rvar 0) (return zero l-acc))
		    (else
		     (generate-move r-acc extra)
		     (return extra l-acc)))
	      (case inst
		((ashl)
		 (cond ((fixnum? lvar)
			(emit risc/sll (machine-num lvar) r-acc t-reg))
		       (else
			(emit risc/sra (machine-num 2) l-acc scratch)
			(emit risc/sll scratch r-acc t-reg))))
		((ashr)
		 (cond ((fixnum? lvar)
			(emit risc/sra (machine-num (fx+ lvar 2)) r-acc scratch))
		       (else
			(emit risc/sra (machine-num 2) l-acc scratch)
			(emit risc/add (machine-num 2) scratch scratch)
			(emit risc/sra scratch r-acc scratch)))
		 (emit risc/sll (machine-num 2) scratch t-reg))
		((mul)
		 (generate-multiply lvar l-acc r-acc t-reg))
		((div)
		 (generate-divide lvar l-acc r-acc t-reg))
		((rem)
		 (generate-remainder lvar l-acc r-acc t-reg))
		(else
		 (emit (machine-op inst) l-acc r-acc t-reg)))
	      (mark-continuation node t-reg)))))))

(define (generate-char->ascii node)
  (destructure (((cont arg) (call-args node)))
      (let* ((var (leaf-value arg))
             (acc (->register node var))
	     (t-reg (get-target-register node cont acc nil)))
	(emit risc/srl (machine-num 6) acc t-reg)
	(mark-continuation node t-reg))))

(define (generate-ascii->char node)
  (destructure (((cont arg) (call-args node)))
      (let* ((var (leaf-value arg))
             (acc (->register node var))
	     (t-reg (get-target-register node cont acc nil)))
	(emit risc/sll (machine-num 6) acc t-reg)
	(emit risc/or (machine-num header/char) t-reg t-reg)
	(mark-continuation node t-reg))))
