(herald spbookkeep); (env t (orbit_top defs)))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

(define *argument-registers* 8)
(define *stack-registers* 0)
(define *real-registers*
  (+ *argument-registers* *stack-registers* 3)) ;an,p,an+1
(define *first-stack-register* (+ *argument-registers* 3))
(define AN (fx+ *argument-registers* 1)) 
(define AN-1 (fx- AN 1))
(define AN+1 (fx+ AN 1))		
(define *virtual-registers* 64)

(define P 0)				
(define A1 1)				
(define A2 2)
(define A3 3)
(define A4 4)
(define A5 5)
(define A6 6)
(define A7 7)				
(define A8 8)				
;(define A9 9)				
;(define A10 10)
;(define A11 11)				

(define zero -1)			
(define extra-args -2)			
(define EXTRA -3)			
(define scratch -4)			
(define nil-reg -5)			
(define parassign-extra -6)		
(define VECTOR -7)			
(define t-reg -8)			
(define FP -9)				
(define link-reg -10)			
(define get-frame -11)
(define lft -12)
(define psb -13)
(define tpc -14)
(define tnpc -15)
(define th0 -16)
(define th1 -17)
(define hp -18)
(define hl -19)
(define pdb -20)

(define link link-reg)
(define rzero zero)
(define treg t-reg)
(define nilreg nil-reg)
(define nargs scratch)

(define *frame-slots* 16)
(define *frame-size* (* CELL (+ *frame-slots* 6)))
(define *slots*  (+ *frame-slots* *real-registers*))

(define frame/free (* 16 CELL))
(define frame/cont (* 17 CELL))
(define frame/link (* 18 CELL))
(define frame/lf-prev (* 19 CELL))
(define frame/lf-next (* 20 CELL))
(define frame/lf-link (* 21 CELL))
(define ($ x) (error "used $"))

(define-integrable (reg-offset x y) (cons x y))

(define (machine-true-value) t-reg)

(define (representable-fixnum? x op)                 
  (and (fixnum? x)
       (fx>= x #x-400)
       (fx< x #x400)))			;13 bits signed -2

(define *max-displ* #x7fff)

(define *max-extend-displ* (- #x7fff 2))

(define (addressable? value)
  (or (target-fixnum? value)
      (char? value)
      (eq? value '#t)
      (eq? value '#F)))

(define-constant target-fixnum? fixnum?)

(define-integrable (machine-num x)
  (if (fx= x 0) zero (cons 'lit x)))
(define-integrable (unsigned-num x) (cons 'unsigned x))

(define (reference-addressable node x)
  (xcond ((representable-fixnum? x 'move)
	  (machine-num (* x 4)))
         ((or (fixnum? x) (char? x))
	  (let ((reg (get-register node)))
	    (generate-move-addressable x reg)
	    (mark x reg)
	    reg))
	 ((not x) nil-reg)
	 ((eq? x '#t) (machine-true-value))))


(define-integrable (register? x)
  (and (fixnum? x) (fx< x *real-registers*)))


(define (allowed-mode? x)
  (or (register? x)
      (and (pair? x)
	   (eq? (car x) 'lit))))


(define (arith->addressable node var op)
  (cond ((representable-fixnum? var op)
	 (machine-num (fx* var 4)))
	(else
	 (->register node var))))

