(herald as)

;;; $4 -> (lit . 4)
;;; 3(r4) -> (4 . 3)
;;; label -> label
;;; (r4,r5) -> ((4 . 5))

(define-constant jump-op/jabs 0)
(define-constant jump-op/jn=  1) (define-constant jump-op/j=   -1)
(define-constant jump-op/j>   2) (define-constant jump-op/j<=  -2)
(define-constant jump-op/j>=  3) (define-constant jump-op/j<   -3)
(define-constant jump-op/uj>  4) (define-constant jump-op/uj<= -4) 
(define-constant jump-op/uj>= 5) (define-constant jump-op/uj<  -5)
(define-constant jump-op/not_negative 6) (define-constant jump-op/negative -6)
(define-constant jump-op/no_overflow  7) (define-constant jump-op/overflow -7) 
(define-constant jump-op/jl 8)                                                                   

(define (reverse-jump-ops j)
  (select j
    ((jump-op/j<) jump-op/j>)
    ((jump-op/j>) jump-op/j<)
    ((jump-op/j<=) jump-op/j>=)
    ((jump-op/j>=) jump-op/j<=)
    ((jump-op/uj<) jump-op/uj>)
    ((jump-op/uj>) jump-op/uj<)
    ((jump-op/uj<=) jump-op/uj>=)
    ((jump-op/uj>=) jump-op/uj<=)
    (else j)))

(define-operation (read-registers . args) (ignore args) (return zero zero))
(define-operation (write-register . args) (ignore args) zero)

(define-structure-type ib
  address
  node
  instructions
  1next
  0next
  cc
  avoid-jump?
  previous
(((pretty-print self port)
  (pretty-print (ib-instructions self) port))))

(let ((m (stype-master ib-stype)))
  (set (ib-instructions m) nil)
  (set (ib-1next m) nil)
  (set (ib-0next m) nil)
  (set (ib-avoid-jump? m) nil)
  (set (ib-previous m) nil)
  (set (ib-cc m) nil)
  (set (ib-address m) nil))

(lset *current-ib* nil)
(lset *cal* nil)
(lset *bits* nil)
(lset *is* nil)
(lset *template-ibs* nil)
(lset *useless-ibs* nil)
(lset *current-comment* nil)
(lset *assembly-comments?* nil)
(lset *assembler-retains-pointers?* nil)
(lset *template-descriptors* nil)

(define (assemble-init c)
  (cond (*assembler-retains-pointers?*
	 (set *current-ib* (make-ib))
	 (set *cal* (make-table 'assembly-labels))
	 (set *bits* nil)
	 (set *is* nil)
	 (set *template-ibs* nil)
	 (set *useless-ibs* nil)
	 (set *current-comment* nil)
	 (set (ib-node *current-ib*) nil)
	 (set *template-descriptors* (make-table '*template-descriptors*))
	 (c))
	(else
	 (bind ((*current-ib* (make-ib))
		(*cal* (make-table 'assembly-labels))
		(*bits* nil)
		(*is* nil)
		(*template-ibs* nil)
		(*useless-ibs* nil)
		(*template-descriptors* (make-table '*template-descriptors*))
		(*current-comment* nil))
           (set (ib-node *current-ib*) nil)
	   (c)))))

(define (as-debug)
  (set *assembly-comments?* t)
  (set *assembler-retains-pointers?* t))

(define (as-undebug)
  (set *assembly-comments?* nil)
  (set *is* nil)
  (set *bits* nil)
  (set *assembler-retains-pointers?* nil))

(define (code-vector-offset thing)
  (fx+ (ib-address (table-entry *cal* thing)) *offset-from-template*))

(define (assemble)
  (modify (ib-instructions *current-ib*) reverse!)
  (push *template-ibs* *current-ib*)
  (remove-useless-blocks)
  (iterate loop ((ibs (reverse! *template-ibs*)) (i 0) (is '()))
    (cond ((null? ibs)
	   (let* ((code (assemble-bits i (reverse! is)))
		  (debugex (->debugex *template-descriptors*)))
	     (return code debugex)))
	  (else
	   (add-to-front (car ibs))
	   (receive (i is) (linearize-code-blocks i is)
	     (loop (cdr ibs) i is))))))

(define (->debugex thing)
  (let ((a-list '()))
    (walk-table (lambda (key value)
		  (ignore key)
		  (push a-list value))
		thing)
    a-list))

	 
(define-operation (instruction-as-string . args) "")


(define (listing) (assembly-list *is* *bits*))

(define quicklist listing)

(define (cons-an-ib thing)
  (let ((ib (make-ib)))
    (set (table-entry *cal* thing) ib)
    (set (ib-node ib) thing)
    ib))

(define (maybe-cons-an-ib thing)
  (or (table-entry *cal* thing)
      (cons-an-ib thing)))


(define (emit-comment string . args)
  (set *current-comment* (cons string args)))

(define (emit-template l h)
  (if (and (node? l) 
	   (environment? (lambda-env l))
	   (fx= (environment-cic-offset (lambda-env l)) 0))
      (emit-template-descriptor l 
				(compute-environment (environment-closure (lambda-env l)))
				(get-source-code-heap l)))
  (emit-tag l)
  (cond ((neq? l h)
	 (let ((h (maybe-cons-an-ib h)))
	   (push *template-ibs* h)
	   (push (ib-instructions *current-ib*) `(,template1 () ,l ,h))))
	(else
	 (push (ib-instructions *current-ib*) `(,template1 () ,l ,nil))))
  (push (ib-instructions *current-ib*) `(,template2 () ,l))
  (push (ib-instructions *current-ib*) `(,template3 ,*current-comment* ,l))
  (set *current-comment* nil))

(define (compute-environment closure)
  (let ((members (closure-members closure)))
    (iterate loop ((pairs (closure-env closure)) (a-list '()) (next nil))
      (cond ((null? pairs) (if next (cons next a-list) a-list))
	    (else
	     (let ((var (caar pairs))
		   (offset (fixnum-ashr (fx- (cdar pairs) 4) 2)))
	       (cond ((memq? (caar pairs) members)
		      (loop (cdr pairs) a-list next))
		     ((fxn= (variable-number var) 0)
		      (if (neq? (variable-name var) 'v)
			  (loop (cdr pairs) 
				(cons (cons (variable-name var) offset)
				      a-list)
				next)
			  (loop (cdr pairs) a-list next)))
		     ((assq (variable-binder var) (closure-env *unit*))
		      (loop (cdr pairs) a-list next))
		     (next
		      (loop (cdr pairs) a-list next))
		     (else
		      (loop (cdr pairs)
			    a-list
			    (cons '#t offset))))))))))


(define (emit-bogus-stack-template)
  (really-emit-stack-template nil))

(define (emit-stack-template l saved)
  (let ((a-list 
	 (iterate loop ((pairs saved) (a-list '()) (next nil))
	   (cond ((null? pairs) 
		  (if next (cons next a-list) a-list))
		 (else
		  (let ((var (caar pairs))
			(offset (fx- (cdar pairs) *first-stack-register*)))
		    (cond ((fxn= (variable-number var) 0)
			   (if (neq? (variable-name var) 'v)
			       (loop (cdr pairs)
				     (cons (cons (variable-name var) offset)
					   a-list)
				     next)
			       (loop (cdr pairs) a-list next)))
			  ((assq (variable-binder var) (closure-env *unit*))
			   (loop (cdr pairs) a-list next))
			  (next
			   (loop (cdr pairs) a-list next))
			  (else
			   (loop (cdr pairs)
				 a-list
				 (cons '#t offset))))))))))
    (emit-template-descriptor l a-list (get-source-code-stack l)))
  (really-emit-stack-template l))


(define (really-emit-stack-template l)
  (push (ib-instructions *current-ib*) `(,stemplate1 () ,l))
  (push (ib-instructions *current-ib*) `(,template2 () ,l))
  (push (ib-instructions *current-ib*)
	`(,stemplate3 ,*current-comment* ,l ,*lambda*))
  (set *current-comment* nil))

(define (emit-template-descriptor l env source)
  (set (table-entry *template-descriptors* l) 
       (cons nil (cons env source))))

(define (get-source-code-stack l)
  (iterate loop ((call (node-parent l)))
    (cond ((not call) '())
	  ((call-source call) => dumpable-source)
	  (else
	   (loop (node-parent (node-parent call)))))))

(define (dumpable-source exp)
  (cond ((pair? exp)
	 (cons (dumpable-source (car exp)) (dumpable-source (cdr exp))))
	((syntax-descriptor? exp) (identification exp))
	((primop? exp) (any-primop-id exp))
	((node? exp) '??)
	(else exp)))


(define (get-source-code-heap l) '())


(define (emit-tag l)
  (if (and (null? (ib-instructions *current-ib*))
	   (let ((node (ib-node *current-ib*)))
	     (or (not (node? node))
		 (not (lambda-node? node))
		 (neq? (lambda-strategy node) strategy/open)))
	   (not (ib-0next *current-ib*)))
      (push *useless-ibs* *current-ib*)
      (push *template-ibs* *current-ib*))
  (modify (ib-instructions *current-ib*) reverse!)
  (set *current-ib* (maybe-cons-an-ib l)))

(define (address-of x)
  (xcond ((ib? x) (ib-address x))
         ((symbol? x) (table-entry *cal* x))))

(define (label l) (cons (if (eq? (lambda-strategy l) strategy/heap)
			    'template
			    'label)
			(maybe-cons-an-ib l)))

(define (asemit op args)
  (push (ib-instructions *current-ib*) (cons op (cons *current-comment* args)))
  (set *current-comment* nil))

(define (tp-offset thing)
  `(tp-offset . ,(maybe-cons-an-ib thing)))

(define (label-offset thing)
  `(label-offset . ,(maybe-cons-an-ib thing)))

(define (handler-diff method obj)
  `(handler-diff . (,(maybe-cons-an-ib method) . ,(maybe-cons-an-ib obj))))

(define (remove-useless-blocks)
  (walk remove-useless-block *useless-ibs*))
  

(define (remove-useless-block ib)
  (let ((next (ib-1next ib)))
    (walk (lambda (p)
	    (push (ib-previous next) p)
	    (if (eq? (ib-1next p) ib)
		(set (ib-1next p) next)
		(set (ib-0next p) next)))
	  (ib-previous ib))))
	  
(lset *blocks-pending* '())





(define (lapemit op . args)
  (asemit op args))

(define (lap-transduce is)
  (walk (lambda (inst)
	  (cond ((atom? inst)
		 (or (ib-cc *current-ib*) (emit-jump inst))
		 (emit-tag inst))
		((table-entry lap-pseudo-ops (car inst))
		 => (lambda (proc) (apply proc (cdr inst))))
		((table-entry lap-instructions (car inst))
		 => (lambda (proc)
		      (apply emit proc (map! lap-eval (cdr inst)))))
		(else (error "Bad lap ~s" inst))))
	is))

(define (lap-eval x)
  (cond ((atom? x)
	 (*value orbit-env x))
	(else
	 (case (car x)
	   (($)
	    (cons 'lit (eval (cadr x) orbit-env)))
	   ((d@r)
	    (list 'reg-offset (lap-eval (cadr x))
		  (let ((x (caddr x)))
		    (cond ((and (pair? x) (eq? (car x) 'static))
			   (static (cadr x)))
			  (else (eval x orbit-env))))))
	   ((d@nil) (list 'reg-offset nil-reg (eval (cadr x) orbit-env)))
	   (else (error "Bad lap operand ~s" x))))))

(define lap-table (make-table 'lap-table))
(define (define-lap x y)
  (set (table-entry lap-table x) y))
