_Chapter(Characters and strings)

_T has a special data type for representing _Fit(characters).
Characters are objects which may be stored in strings and communicated
between the _T system and external media such as files and
terminals.  Most characters represent printed graphics
such as letters, digits, and punctuation.

_label(character syntax)
The external syntax _char(_Fit(x)) is used for characters.
_Fit(x) may either be a single character or the _qu(name) of a character.
Valid character names include _tc(SPACE), _tc(TAB), _tc(FORM),
and _tc(NEWLINE).  For example:

_DComment(dorab: fix for info)
_IfLatex(`\begin{center}
\begin{tabular}{ll}')
_char(b)         _colsep()The alphabetic character lower-case _Fit(b) _LNL
_char(7)         _colsep()The digit 7 _LNL
_char(;)         _colsep()The special character _Fit(semicolon) _LNL
_char(tab)       _colsep()The tab character _LNL
_char(NEWLINE)   _colsep()The new-line character _LNL
_IfLatex(`\end{tabular}
\end{center}')

Some graphic characters are also readable by name:
_begin_ExampleTabular
_char(LEFT-PAREN)      _colsep()_equiv()_colsep   _char(``('') _LNL
_char(RIGHT-PAREN)     _colsep()_equiv()_colsep   _char(``)'') _LNL
_char(LEFT-BRACKET)    _colsep()_equiv()_colsep   _char(`[') _LNL
_char(RIGHT-BRACKET)   _colsep()_equiv()_colsep   _char(`]') _LNL
_char(LEFT-BRACE)      _colsep()_equiv()_colsep   _char(_cBo) _LNL
_char(RIGHT-BRACE)     _colsep()_equiv()_colsep   _char(_cBc) _LNL
_char(BACKSLASH)       _colsep()_equiv()_colsep   _char(_cSL) _LNL
_char(QUOTE)           _colsep()_equiv()_colsep   _char()_cQc _LNL
_char(QUASIQUOTE)      _colsep()_equiv()_colsep   _char()_cQo _LNL
_char(DOUBLEQUOTE)     _colsep()_equiv()_colsep   _char(_cQ) _LNL
_char(COMMA)           _colsep()_equiv()_colsep   _char(), _LNL
_char(SEMICOLON)       _colsep()_equiv()_colsep   _char(;)
_end_ExampleTabular

The syntax _tc(_cH()[Ascii _Fit(n)]) may also be used for characters,
where _Fit(n) is the ASCII code for the character (see section
_Ref(char-to-ascii)).  This is not preferred, however, since it is
less readable and less abstract than the _char() syntax.
_Tv(2) used _tc(_cH()[Char _Fit(n)]) instead of _tc(_cH()[Ascii _Fit(n)]).

_begin_Example
_cH()[Ascii 65]  _equiv()  _char(A)
_end_Example

Unlike numbers, characters _Fit(are) uniquely instantiated.
There is only one object which represents a given graphic or other character.
_begin_Example
(EQ? _char(x) _char(x))  _yl()  _Fsem(true)
_end_Example

Characters and strings are self-evaluating.  There is no need to quote them
to use them as constants in programs.

Strings are sequences of characters.  _DComment( Elaborate? )
Strings actually consist of two
distinct components, a _Fit(header) and a _Fit(text), which may be
manipulated independently of each other.  If one doesn't use the
routines in section _Ref(section:stringHeader)_DComment( ???), one need not
even be aware of this fact, and can treat strings as if they are similar
to lists of characters.

Strings are notated simply by enclosing the actual sequence of characters
within double quote characters.  For example,
_begin_Example
_exqu(Horse)
_end_Example
notates a five-character string consisting of the characters
_char(H), _char(o), _char(r), _char(s), and _char(e).
The escape character (also known as backslash: _cSL) may be used
to include a double-quote or a backslash within a string:
_begin_Example
_exqu(The _a(_cSL,_cQ,second,_cSL,_cQ) word in this string is enclosed in double-quotes.) _LNL
_exqu(_a(_cSL,_cSL) This string begins with one backslash.)
_end_Example
There is no standard way to notate a string which contains non-graphic
characters (e.g. control characters).

Strings are not uniquely instantiated; e.g.
_begin_Example
(EQ? _exqu(Eland) _exqu(Eland))
_end_Example
may or may not yield true, depending on the implementation.

_Section(Predicates)

_Comdef(`CHAR?',`Type predicate',
`(CHAR? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is a character.
_begin_Example
(CHAR? _char(X))  _evalto()  _Fsem(true)
_end_Example
_end_Desc 


_Comdef(`STRING?',`Type predicate',
`(STRING? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is a string.
_begin_Example
(STRING? _exqu(Tapir.))  _evalto()  _Fsem(true)
_end_Example
_end_Desc 
 
_Comdef(`GRAPHIC?',` ',
`(GRAPHIC? _Fit(character)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(character) is either the space character (_char(SPACE)) or
it corresponds to a printed graphic such as a letter, digit, or punctuation
mark.
_begin_ExampleTabular
(GRAPHIC? _char(X))        _colsep()_evalto()_colsep  _Fsem(true) _LNL
(GRAPHIC? _char(NEWLINE))  _colsep()_evalto()_colsep  _Fsem(false)
_end_ExampleTabular
_end_Desc 
 
_Comdef(`WHITESPACE?',` ',
`(WHITESPACE? _Fit(character)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(character) is a whitespace character (blank, tab,
newline, carriage return, line feed, or form feed).
_index(whitespace)
_begin_ExampleTabular
(WHITESPACE? _char(X))        _colsep()_evalto()_colsep  _Fsem(false) _LNL
(WHITESPACE? _char(NEWLINE))  _colsep()_evalto()_colsep  _Fsem(true)
_end_ExampleTabular
_end_Desc 
 
_Comdef(`ALPHABETIC?',` ',
`(ALPHABETIC? _Fit(character)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(character) is an alphabetic (upper or lower case)
character.
_begin_ExampleTabular
(ALPHABETIC? _char(y))  _colsep()_evalto()_colsep  _Fsem(true) _LNL
(ALPHABETIC? _char(7))  _colsep()_evalto()_colsep  _Fsem(false)
_end_ExampleTabular
_end_Desc 
 
_Comdef(`UPPERCASE?',` ',
`(UPPERCASE? _Fit(character)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(character) is an upper-case letter.
_begin_ExampleTabular
(UPPERCASE? _char(y))      _colsep()_evalto()_colsep  _Fsem(false) _LNL
(UPPERCASE? _char(Y))      _colsep()_evalto()_colsep  _Fsem(true) _LNL
(UPPERCASE? _char(COMMA))  _colsep()_evalto()_colsep  _Fsem(false)
_end_ExampleTabular
_end_Desc 
 
_Comdef(`LOWERCASE?',` ',
`(LOWERCASE? _Fit(character)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(character) is a lower-case letter.
_begin_ExampleTabular
(LOWERCASE? _char(y))      _colsep()_evalto()_colsep  _Fsem(true) _LNL
(LOWERCASE? _char(Y))      _colsep()_evalto()_colsep  _Fsem(false) _LNL
(LOWERCASE? _char(COMMA))  _colsep()_evalto()_colsep  _Fsem(false)
_end_ExampleTabular
_end_Desc 
 
_Comdef(`DIGIT?',` ',
`(DIGIT? _Fit(character radix)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(character) is a digit with respect to the given
_Fit(radix).
_begin_ExampleTabular
(DIGIT? _char(5) 10)  _colsep()_evalto()_colsep  _Fsem(true) _LNL
(DIGIT? _char(a) 10)  _colsep()_evalto()_colsep  _Fsem(false) _LNL
(DIGIT? _char(a) 16)  _colsep()_evalto()_colsep  _Fsem(true)
_end_ExampleTabular
_end_Desc 

_Section(Comparison)

_Comdef(`CHAR=',` ',
`(CHAR= _Fit(char1 char2)) _yl() _Fit(boolean)')
_Comdef2(`char-less-than',`_a(CHAR,_cLT)',` ',
`(_a(CHAR,_cLT) _Fit(char1 char2)) _yl() _Fit(boolean)')
_Comdef2(`char-greater-than',`_a(CHAR,_cGT)',` ',
`(_a(CHAR,_cGT) _Fit(char1 char2)) _yl() _Fit(boolean)')
_Comdef(`CHARN=',` ',
`(CHARN= _Fit(char1 char2)) _yl() _Fit(boolean)')
_Comdef2(`char-greater-than-or-equal-to',`_a(CHAR,_cGT,=)',` ',
`(_a(CHAR,_cGT,=) _Fit(char1 char2)) _yl() _Fit(boolean)')
_Comdef2(`char-less-than-or-equal-to',`_a(CHAR,_cLT,=)',` ',
`(_a(CHAR,_cLT,=) _Fit(char1 char2)) _yl() _Fit(boolean)')
_begin_Desc 
_DComment( Horrible explanation. )
Six comparison predicates are defined for characters.
_tc(CHAR=) and _tc(CHARN=) are defined for all characters.
The others are defined only when the arguments are both
upper-case letters, or both lower-case letters, or both digits.
_end_Desc
 
_Comdef(`STRING-EQUAL?',` ',
`(STRING-EQUAL? _Fit(string1 string2)) _yl() _Fit(boolean)')
_label(STRING-EQUAL?)
_begin_Desc
Returns true if the two strings have the same length and characters.
_end_Desc 

_Comdef(`MAKE-STRING',` ',
`(MAKE-STRING _Fit(length)) _yl() _Fit(string)')
_begin_Desc
Makes a string of null characters whose length is _Fit(length).
_end_Desc 
 
_Comdef(`STRING-APPEND',` ',
`(STRING-APPEND . _Fit(strings)) _yl() _Fit(string)')
_begin_Desc
Returns a new string which is the concatenation of _Fit(strings).
_begin_Example
(STRING-APPEND _exqu(llama) _exqu( and ) _exqu(alpaca))  _evalto()  _exqu(llama and alpaca)
_end_Example
_end_Desc 
 
_Comdef(`COPY-STRING',` ',
`(COPY-STRING _Fit(string)) _yl() _Fit(string)')
_begin_Desc
Returns a new string, with new text,
whose characters and length are the same
as those of _Fit(string).
_end_Desc 
 
_Comdef2(`char-to-string',`_a(CHAR-,_cGT,STRING)',` ',
`(_a(CHAR-,_cGT,STRING) _Fit(character)) _yl() _Fit(string)')
_begin_Desc
Creates a string of length one whose single element is _Fit(character).
_begin_Example
(_a(CHAR-,_cGT,STRING) _char(B))  _evalto()  _exqu(B)
_end_Example
_end_Desc 
 
_Comdef2(`list-to-string',`_a(LIST-,_cGT,STRING)',` ',
`(_a(LIST-,_cGT,STRING) _Fit(list)) _yl() _Fit(string)')
_begin_Desc
Converts a list of characters to a string.
_begin_Example
(_a(LIST-,_cGT,STRING) _cQc()(_char(Z) _char(e) _char(b) _char(u)))  _evalto()  _exqu(Zebu)
_end_Example
_end_Desc 
 
_Comdef2(`string-to-list',`_a(STRING-,_cGT,LIST)',` ',
`(_a(STRING-,_cGT,LIST) _Fit(string)) _yl() _Fit(list)')
_begin_Desc
Converts a string to a list of characters.
_begin_Example
(_a(STRING-,_cGT,LIST) _exqu(Zebu))  _evalto()  (_char(Z) _char(e) _char(b) _char(u))
_end_Example
_end_Desc 

_Section(String access)

_Comdef(`STRING-LENGTH',`Settable',
`(STRING-LENGTH _Fit(string)) _yl() _Fit(integer)')
_begin_Desc
Returns _Fit(string)'s length.
A string's length may be _tc(SET), but the new length must be less
than or equal to the original length.
_end_Desc 

_Comdef(`STRING-EMPTY?',` ',
`(STRING-EMPTY? _Fit(string)) _yl() _Fit(boolean)')
_begin_Desc 
Returns true if _Fit(string) is an empty string.
_begin_ExampleTabular
(STRING-EMPTY? _exqu())        _colsep()_evalto()_colsep  _Fsem(true) _LNL
(STRING-EMPTY? _exqu(Bharal))  _colsep()_evalto()_colsep  _Fsem(false) _LNL
(STRING-EMPTY? _Fit(string))  _colsep()_equiv()_colsep  (=0? (STRING-LENGTH _Fit(string)))
_end_ExampleTabular
_end_Desc

_Comdef(`STRING-ELT',`Settable',
`(STRING-ELT _Fit(string n)) _yl() _Fit(character)')
_Comdef(`NTHCHAR',`Settable',
`(NTHCHAR _Fit(string n)) _yl() _Fit(character)')
_begin_Desc 
Returns the _Fit(nth) character in _Fit(string) (zero-based).
_begin_Example
(NTHCHAR _exqu(SAIGA) 2)  _evalto()  _char(I)
_end_Example
_end_Desc

_Comdef(`STRING-HEAD',`Settable',
`(STRING-HEAD _Fit(string)) _yl() _Fit(character)')
_Comdef(`CHAR',`Settable',
`(CHAR _Fit(string)) _yl() _Fit(character)')
_begin_Desc 
Returns first character in _Fit(string).
_end_Desc

_Comdef(`STRING-TAIL',` ',
`(STRING-TAIL _Fit(string)) _yl() _Fit(string)')
_Comdef(`CHDR',` ',
`(CHDR _Fit(string)) _yl() _Fit(string)')
_begin_Desc 
Returns the _qu(tail) of _Fit(string).
_begin_Example
(STRING-TAIL _exqu(Ibex.))  _evalto()  _exqu(bex.)
_end_Example
_end_Desc

_Comdef(`STRING-NTHTAIL',` ',
`(STRING-NTHTAIL _Fit(string n)) _yl() _Fit(string)')
_Comdef(`NTHCHDR',` ',
`(NTHCHDR _Fit(string n)) _yl() _Fit(string)')
_begin_Desc 
Returns the _Fit(nth) tail of _Fit(string).
_begin_Example
(NTHCHDR _exqu(SAIGA) 2)  _evalto()  _exqu(IGA)
_end_Example
_end_Desc

_Comdef(`SUBSTRING',` ',
`(SUBSTRING _Fit(string start count)) _yl() _Fit(string)')
_begin_Desc 

Returns a substring of _Fit(string), beginning with the _Fit(_sup(start,th)) character,
for a length of _Fit(count) characters.
_begin_Example
(SUBSTRING _exqu(A small oryx) 2 5)  _evalto()  _exqu(small)
_end_Example
_end_Desc

_Comdef(`STRING-SLICE',` ',
`(STRING-SLICE _Fit(string start count)) _yl() _Fit(string)')
_begin_Desc
Returns a substring (slice) of _Fit(string), beginning with the _Fit(_sup(start,th))
character, for a length of _Fit(count) characters.
_begin_Example
(STRING-SLICE _exqu(A small oryx) 2 5)  _evalto()  _exqu(small)
_end_Example
Unlike _tc(SUBSTRING), the characters returned by
_tc(STRING-SLICE) are shared with the original string;
that is, any changes to characters
in the original string which have been selected in the substring
are reflected in the substring, and vice versa.
_end_Desc 

_Section(String manipulation)
 
_Comdef(`STRING-POSQ',` ',
`(STRING-POSQ _Fit(character string)) _yl() _Fit(integer) _rm(or) _Fit(false)')
_begin_Desc
Returns the index of the first occurrence of
_Fit(character) in _Fit(string), if it is there;
otherwise returns false.
_begin_ExampleTabular
(STRING-POSQ _char(i) _exqu(oribi))  _colsep()_evalto()_colsep  2 _LNL
(STRING-POSQ _char(s) _exqu(oribi))  _colsep()_evalto()_colsep  _Fsem(false)
_end_ExampleTabular
_end_Desc 
 
_Comdef(`STRING-REPLACE',` ',
`(STRING-REPLACE _Fit(destination source count)) _yl() _Fit(string)')
_begin_Desc
Copies _Fit(count) characters from the _Fit(source) string to the
_Fit(destination) string, destructively, and return the modified
_Fit(destination).
_begin_Example
(DEFINE S (COPY-STRING _exqu(The bison))) _LNL
(STRING-REPLACE S _exqu(Any how) 3)  _evalto()  _exqu(Any bison)
_end_Example
_DComment(This may be renamed to be _tc(STRING-REPLACE!).)
_end_Desc 
 
_Comdef(`MAP-STRING',` ',
`(MAP-STRING _Fit(procedure string)) _yl() _Fit(string)')
_begin_Desc
Calls _Fit(procedure) on each character in _Fit(string), collecting
the successive return values which should be characters
in a new string.
_begin_Example
(MAP-STRING CHAR-UPCASE _exqu(A grisbok))  _evalto()  _exqu(A GRISBOK)
_end_Example
_end_Desc 
 
_Comdef(`MAP-STRING!',` ',
`(MAP-STRING! _Fit(procedure string)) _yl() _Fit(string)')
_begin_Desc
Calls _Fit(procedure) on each character in _Fit(string), storing the results
which should be characters back into _Fit(string).
_end_Desc 
 
_Comdef(`WALK-STRING',` ',
`(WALK-STRING _Fit(procedure string)) _yl() _Fit(undefined)')
_begin_Desc
Calls _Fit(procedure) on each character in _Fit(string).
_end_Desc 

_Section(String header manipulation)
_label(section:stringHeader)

A _iix(string header) is a structure of fixed size which contains a
pointer into a _iix(string text), and a length.  A string text is a
vector of characters themselves.  The string text is not itself a directly
accessible object, but can only be manipulated
via a string header.  Several string headers may point into the same text.
The term _Fit(string) is used to refer to a header and text considered
as a whole.

_Comdef(`CHOPY',` ',
`(CHOPY _Fit(string)) _yl() _Fit(string)')
_begin_Desc
Makes a new string header pointing to the same string text,
and with the same length, as the header for _Fit(string).
_end_Desc 

_Comdef(`CHOPY!',` ',
`(CHOPY! _Fit(destination source)) _yl() _Fit(string)')
_begin_Desc
Copies the header for the _Fit(source) string into the header
for the _Fit(destination) string, which is returned.
_end_Desc 

_Comdef(`STRING-TAIL!',` ',
`(STRING-TAIL! _Fit(string)) _yl() _Fit(string)')
_Comdef(`CHDR!',` ',
`(CHDR! _Fit(string)) _yl() _Fit(string)')
_begin_Desc 
Destructively modifies _Fit(string)'s header to point to the next
character in its text, and decrements its length.
_begin_ExampleTabbing
(LET _settab()((S (COPY-STRING _exqu(String.)))) _incrtab()_LNL
  (CHDR! S) _LNL
  S) _LNL
        _evalto() _LNL
_exqu(tring.)
_end_ExampleTabbing
_end_Desc

_Comdef(`STRING-NTHTAIL!',` ',
`(STRING-NTHTAIL! _Fit(string n)) _yl() _Fit(string)')
_Comdef(`NTHCHDR!',` ',`
(NTHCHDR! _Fit(string) n) _yl() _Fit(string)') 
_begin_Desc 
Destructive version of _tc(STRING-NTHTAIL).
_end_Desc

_Section(Case conversion)
 
_Comdef(`CHAR-UPCASE',` ',
`(CHAR-UPCASE _Fit(character)) _yl() _Fit(character)')
_begin_Desc
If _Fit(character) is a lower-case character, returns the corresponding
upper-case character.  Otherwise _Fit(character), which must be a character,
is returned.
_end_Desc 
 
_Comdef(`CHAR-DOWNCASE',` ',
`(CHAR-DOWNCASE _Fit(character)) _yl() _Fit(character)')
_begin_Desc
If _Fit(character) is an upper-case character, returns the corresponding
lower-case character.  Otherwise _Fit(character), which must be a character,
is returned.
_end_Desc 
 
_Comdef(`STRING-UPCASE',` ',
`(STRING-UPCASE _Fit(string)) _yl() _Fit(string)')
_begin_Desc
Returns a copy of _Fit(string) with all lower-case characters converted to
upper case.
_begin_Example
(STRING-UPCASE _Fit(string))  _equiv()  (MAP-STRING CHAR-UPCASE _Fit(string))
_end_Example
_end_Desc 
 
_Comdef(`STRING-DOWNCASE',` ',
`(STRING-DOWNCASE _Fit(string)) _yl() _Fit(string)')
_begin_Desc
Returns a copy of _Fit(string) with all upper-case characters converted to
lower case.
_begin_Example
(STRING-DOWNCASE _Fit(string))  _equiv()  (MAP-STRING CHAR-DOWNCASE _Fit(string))
_end_Example
_end_Desc 
 
_Comdef(`STRING-UPCASE!',` ',
`(STRING-UPCASE! _Fit(string)) _yl() _Fit(string)')
_begin_Desc
Destructive version of _tc(STRING-UPCASE).
_begin_Example
(STRING-UPCASE! _Fit(string))  _equiv()  (MAP-STRING! CHAR-UPCASE _Fit(string))
_end_Example
_end_Desc 
 
_Comdef(`STRING-DOWNCASE!',` ',
`(STRING-DOWNCASE! _Fit(string)) _yl() _Fit(string)')
_begin_Desc
Destructive version of _tc(STRING-DOWNCASE).
_begin_Example
(STRING-DOWNCASE! _Fit(string))  _equiv()  (MAP-STRING! CHAR-DOWNCASE _Fit(string))
_end_Example
_end_Desc 

_Section(Digit conversion)
 
_Comdef2(`char-to-digit',`_a(CHAR-,_cGT,DIGIT)',` ',
`(_a(CHAR-,_cGT,DIGIT) _Fit(character radix)) _yl() _Fit(integer)')
_begin_Desc
Returns the _iix(weight) of the character when treated as a digit.
_Fit(Character) must be a digit in the given _Fit(radix).
_begin_Example
(_a(CHAR-,_cGT,DIGIT) _char(A) 16)  _evalto()  10
_end_Example
_end_Desc 
 
_Comdef2(`digit-to-char',`_a(DIGIT-,_cGT,CHAR)',` ',
`(_a(DIGIT-,_cGT,CHAR) _Fit(integer radix)) _yl() _Fit(character)')
_begin_Desc
Given a non-negative _Fit(integer) less than _Fit(radix),
returns a character (a digit) whose weight is the _Fit(integer).
_begin_Example
(_a(DIGIT-,_cGT,CHAR) 10 16)  _evalto()  _char(A)
_end_Example
_end_Desc 
 
_Comdef(`DIGIT',` ',
`(DIGIT _Fit(character radix)) _yl() _Fit(integer) _rm(or) _Fit(false)')
_begin_Desc
If _Fit(character) is a digit, returns its weight;
otherwise returns false.
_begin_Example
(DIGIT _char(5) 10)  _evalto()  5
_end_Example
_end_Desc 

_Section(ASCII conversion)

_DComment(Talk about coercion to and from integers, and the arbitrariness of the ASCII
character set.  Refer to Appendix _Ref(appendix:ascii).)

_Comdef2(`char-to-ascii',`_a(CHAR-,_cGT,ASCII)',` ',
`(_a(CHAR-,_cGT,ASCII) _Fit(character)) _yl() _Fit(integer)')
_label(char-to-ascii)
_begin_Desc
Given a character, returns its ASCII representation as an integer.
_end_Desc 

_Comdef2(`ascii-to-char',`_a(ASCII-,_cGT,CHAR)',` ',
`(_a(ASCII-,_cGT,CHAR) _Fit(integer)) _yl() _Fit(character)')
_begin_Desc
Given an integer which is the ASCII code for some character,
returns the character.
_end_Desc 
 
_Comdef(`NUMBER-OF-CHAR-CODES',` ',
`NUMBER-OF-CHAR-CODES _yl() _Fit(integer)')
_begin_Desc
In _Tv(2), called _tc(*NUMBER-OF-CHAR-CODES*).
The value of _wt(NUMBER-OF-CHAR-CODES) is a number that is 1 larger than
the largest value that will ever be returned by _wt(CHAR->ASCII).
This may be used to make tables which are to be indexed by ASCII codes.
_begin_ExampleTabular
(DEFINE *TABLE* (MAKE-VECTOR NUMBER-OF-CHAR-CODES))  _colsep()_evalto()_colsep  _Fit(vector) _LNL
(VSET *TABLE* (_a(CHAR-,_cGT,ASCII) _char(F)) 'COW) _colsep()_evalto()_colsep  COW _LNL
(VREF *TABLE* (_a(CHAR-,_cGT,ASCII) _char(F)))  _colsep()_evalto()_colsep  COW
_end_ExampleTabular
_end_Desc

_Section(Symbols)

Symbols are similar to strings, but are instantiated uniquely; only one
symbol with a given print name exists.  Symbols are used to identify
variables, among other things.  The fact that they have a convenient
external representation makes them useful for many purposes.

Symbols may be coerced to strings and vice versa.
If two strings are equal to each other (e.g. according
to _tc(STRING-EQUAL?)), then they will both convert to the same symbol.
_begin_Example
(EQ? (_a(STRING-,_cGT,SYMBOL) _Fit(string1)) (_a(STRING-,_cGT,SYMBOL) _Fit(string2)))
_end_Example
if and only if
_begin_Example
(STRING-EQUAL? _Fit(string1) _Fit(string2))
_end_Example

See also sections _Ref(SYMBOL?) and _Ref(section:reader).
 
_Comdef2(`string-to-symbol',`_a(STRING-,_cGT,SYMBOL)',` ',
`(_a(STRING-,_cGT,SYMBOL) _Fit(string)) _yl() _Fit(symbol)')
_label(string-to-symbol)
_begin_Desc
Returns the symbol whose print name is equal to _Fit(string).
_begin_ExampleTabular
(_a(STRING-,_cGT,SYMBOL) _exqu(COW))    _colsep()_evalto()_colsep  COW _LNL
(_a(STRING-,_cGT,SYMBOL) _exqu(123))    _colsep()_evalto()_colsep  _a(_cSL,123) _LNL
(_a(STRING-,_cGT,SYMBOL) _exqu(bison))  _colsep()_evalto()_colsep  _a(_cSL,b,_a(_cSL,i,_cSL,s,_cSL,o,_cSL,n)) _LNL
(_a(STRING-,_cGT,SYMBOL) _exqu())       _colsep()_evalto()_colsep  _cH()[Symbol _exqu()]
_end_ExampleTabular
Note that it is _tc(READ-OBJECT) (page _Pageref(READ-OBJECT)), not
_tc(_a(STRING-,_cGT,SYMBOL)), which coerces alphabetic characters to upper case.
_end_Desc 
 
_Comdef2(`symbol-to-string',`_a(SYMBOL-,_cGT,STRING)',` ',
`(_a(SYMBOL-,_cGT,STRING) _Fit(symbol)) _yl() _Fit(string)')
_begin_Desc
Returns a string for which _tc(_a(SYMBOL-,_cGT,STRING)) will return _Fit(symbol).
_begin_Example
(_a(SYMBOL-,_cGT,STRING) 'COW)  _evalto()  _exqu(COW)
_end_Example
_end_Desc 
