_Chapter(Program structure)
_label(chapter:program)

This chapter provides information about organizing, loading, and
compiling programs.

_Section(Environment structure)

Lexical environments in _T are hierarchically arranged.  Variable
bindings are inherited from outer (superior) contours to inner
(inferior) ones.  At the top of the hierarchy is a
root environment, which has no bindings in it.  Inferior to that is a
standard environment which has bindings for all standard system
variables, for example, _tc(CAR) and _tc(+).  (See
section _Ref(section:standardEnvironment).)
Inferior to the standard environment are environments into which programs
have been or are to be loaded.  In the standard environment, the variable
_tc(STANDARD-ENV) is bound to the standard environment itself.

When a _T system starts up, it sets up an initial environment
configuration which has one environment inferior to the standard
environment, called the _iix(user environment).  The variable
_tc(USER-ENV) is bound in the standard
environment to the user environment.  The user environment has
no variable bindings in it at first; however, the initial
read-eval-print loop (section _Ref(section:repl)) is started in this
environment, so that if no other provision is made, user global variable
(i.e. definitions) will be made in the user environment.

In _T 3.1, there is another environment called the
_iix(implementation environment) (page _Pageref(T-IMPLEMENTATION-ENV)).
This is the value of _tc(T-IMPLEMENTATION-ENV) in the standard
environment.  The implementation environment is not inferior to the
standard environment, but instead is inferior to the root.

In _Fbf(_T 3.0), the initial locales look like:

_begin_Display
_IfLatex(`\begin{verbatim}')

                                 <root>
                                /  |  \
                              /    |    \
                            /      |      \
                          /        |        \
                        /          |          \
       t-implementation-env   standard-env   scheme-env
                               /   |   \
                             /     |     \
                           /       |       \
                     user-env  orbit-env  scheme-internal-env

_IfLatex(`\end{verbatim}')
_end_Display

_begin_Table

_Item(_Ftt(<root>))  The _Ftt(<root>) locale is the conceptual root of the
        locale tree.  It does not actually exist.
        The _Ftt(<root>) locale is empty, it contains no variable bindings.

_Item(_Ftt(t-implementation-env)) The _wt(t-implementation-env) is the
        environment which contains the system internals.

_Item(_Ftt(standard-env))  The _wt(standard-env) is the environment
        defined by the T manual.

_Item(_Ftt(user-env))  The _wt(user-env) is the default environment for
        the _wt(read-eval-print-loop) on system startup.

_Item(_Ftt(orbit-env))  The _wt(orbit-env) is the environment which
        contains the internals of the _orbit compiler.

_Item(_Ftt(scheme-internal-env))  The _wt(scheme-internal-env) contains
        the system internals for the Scheme environment.

_Item(_Ftt(scheme-env))  The _wt(scheme-env) is the environment defined
        by _r3rs.

_end_Table


Empty environments may be created using _tc(MAKE-EMPTY-LOCALE) (page
_Pageref(MAKE-EMPTY-LOCALE)).  For example:
_begin_Example
(DEFINE *ALMOST-USELESS-ENV* (MAKE-EMPTY-LOCALE '*ALMOST-USELESS-ENV*)) _LNL
(*DEFINE *ALMOST-USELESS-ENV* '+ +) _LNL
(*DEFINE *ALMOST-USELESS-ENV* '- -) _LNL
(EVAL '(+ 5 (- 21 13)) *ALMOST-USELESS-ENV*)  _evalto()  13
_end_Example

_Comdef(`STANDARD-ENV',` ',
`STANDARD-ENV _yl() _Fit(locale)')
_label(STANDARD-ENV)
_index(standard environment)
_begin_Desc
In _Tv(2) called _tix(*STANDARD-ENV*).
The value of _tc(STANDARD-ENV) is an environment (a locale)
in which all system variables have appropriate values,
as described in this manual.  That is, it is a _Fit(standard environment)
in the sense of section _Ref(section:standardEnvironment).
_end_Desc 

_label(user-env)
_Comdef(`USER-ENV',` ',
`USER-ENV _yl() _Fit(locale)')
_label(USER-ENV)
_begin_Desc
In _Tv(2) called _tix(*SCRATCH-ENV*).
The value of _tc(USER-ENV) is an environment (a locale)
inferior to _tc(STANDARD-ENV).
It is provided by a _T implementation as an environment in which a user
may evaluate expressions and write programs.
Other evaluation environments may be created inferior
to _tc(STANDARD-ENV), however, with _tc(MAKE-LOCALE) (page
_Pageref(MAKE-LOCALE)).
_end_Desc

_Section(Source files)

_T programs are usually represented by collections of one or more text
files resident in a file system.  Text files containing _T programs
are called _iix(source files).

A source file consists of a sequence of (external representations of)
_T expressions.  Source files may be _Fit(loaded) into a _T environment.
When a file is loaded, the expressions in the file are evaluated.
Typically, this means that useful side-effects, such as procedure
definitions, occur which then make the program available in that _T
environment.
_index(loading)

A compilation (semantic analysis) step must occur either as a file
is being loaded, or prior to loading the file.  In the former case,
compilation is typically performed by a compiler such as the
_qu(standard compiler) (page _Pageref(STANDARD-COMPILER)) which itself runs
relatively quickly and produces intermediate code which must then
be interpreted.  In the latter case, an auxiliary file known as an
_Fit(object file) is involved; the compilation step need only be performed
once, even if the file is to be loaded many times.  (The term _Fit(object
file) is completely unrelated to the term _Fit(object.))

A _Fit(file compiler) (such as _orbit(); see section _Ref(section:orbit)) takes
a source file as input and produces an object file as output.  The
object file may then be loaded in lieu of the source file, with
the same effect.

_begin_Inset(Note:)
In the current implementation, the standard compiler cannot be used
as a file compiler, and _orbit cannot be used as an _qu(on-the-fly)
compiler.  In principle, the two dimensions of compiler and compilation
mode are orthogonal:  it should be possible to use either compiler
in either manner.  In practice, this is not the case, but it turns out
not to be too much of a problem.
_end_Inset

_Section(File syntax)

The first form in a source file must be a list whose car is the
symbol _tc(HERALD).  This form is not an expression, but
rather is part of the syntax of the file.
It provides information relevant to programs which operate on the
source file (such as readers, compilers, and loaders).
The syntax of a _tc(HERALD)-form is as follows:
_begin_Example
(HERALD _Fit(identification) . _Fit(items))
_end_Example
_Fit(Identification) should be either _tc(()) or a symbol identifying
the file (usually the same as the root of the name of the file).
It is for documentary purposes only.

_Fit(Items) is a sequence of lists.  Each _Fit(item) should be
a list beginning with a valid keyword symbol, as described below.

Example:
_begin_ExampleTabbing
(HERALD _settab()FACT _incrtab()_LNL
        (READ-TABLE *MATH-READ-TABLE*) _LNL
        (ENV T (MATH MATHMACROS)))
_end_ExampleTabbing

_Comdef(`READ-TABLE',`Herald item',
`(READ-TABLE _Fit(expression))')
_begin_Desc
_Fit(Expression) should evaluate to a read table, which is used
in reading the expressions which follow the _tc(HERALD)-form from
the source file.  The environment in which _Fit(expression) is evaluated
depends on the program processing the file (but might be, e.g., the
scratch environment).

If this item is absent, then expressions are read using the
standard read table.
_end_Desc 

_Comdef(`SYNTAX-TABLE',`Herald item',
`(SYNTAX-TABLE _Fit(expression))')
_begin_Desc
_Fit(Expression) should evaluate to a syntax table, which is used
in compiling (evaluating) the expressions in the source file.
The environment in which _Fit(expression) is evaluated
depends on the program processing the file (but might be, e.g., the
scratch environment).

If this item is absent, then expressions are compiled according
to an appropriate syntax table: the syntax table associated with the
locale into which the file is being loaded, if the file is being loaded,
or the current value of _tc((TC-SYNTAX-TABLE)) (see below), if the
file is being compiled using _orbit .
_end_Desc 

_DComment(

_Comdef(`SUPPORT',`Herald item',
`(SUPPORT _Fit(expression))')
_begin_Desc
_Fit(Expression) should evaluate to a support environment, which is
used to compile the file.
_end_Desc 
)

_Comdef(`ENV',`Herald item',
`(ENV _Fit(support-env-name) . _Fit(filespecs))')
_label(ENV)
_begin_Desc
Specifies a support (early binding) environment for compiling the file.
The support environment consists of the support environment named
by _Fit(support-env-name), augmented by information obtained from
support files named by _Fit(filespecs).

If this item is absent, then the standard support environment,
whose name is _tc(T), is used.  The ability to create and name other
support environments is not yet documented.
_end_Desc 

_Section(Loading files)

_DComment(

    REQUIRE
    INCLUDE
    FILE-LOADED?

)

_Comdef(`LOAD',` ',
`(LOAD _Fit(filespec) _Fit(environment)) _yl() _Fit(undefined)')
_begin_Desc
Loads the file named by _Fit(filespec).  If the file is a source file,
then each expression in the file is compiled (with the standard
compiler) and run in _Fit(environment).  If the file is an object file,
as produced by TC, then the compiled object code is simply run in
_Fit(environment).

If no explicit file type is given in the _Fit(filespec), then _tc(LOAD)
will load either an object file (file type _tc(BIN)), if one exists,
or a source file (file type _tc(T)) otherwise.
_end_Desc 

_Comdef(`LOAD-OUT-OF-DATE-ACTION',`',
`(LOAD-OUT-OF-DATE-ACTION) _yl() _Fsem(symbol)')
_begin_Desc
_wt(LOAD-OUT-OF-DATE-ACTION) is a switch that controls what the loader does
with a filespec without an extension.  The options are:

_begin_Table
_Item(binary) load the object file.
_Item(source) load the source file.
_Item(newer)  load the most recent of object and source files.
_Item(recompile) recompile the file if the source is newer than the object file.
_Item(warn) give a warning if the source is newer than the object file.
_Item(query) offer to recompile if the source is newer than the object
file.
_end_Table

The default is _wt(WARN).
_end_Desc

_DComment(
_Comdef(`*REQUIRE',` ',
`(*REQUIRE _Fit(file-id) _Fit(filespec) _Fit(environment)) _yl() _Fit(undefined)')
_begin_Desc
Ensures that the file specified by _Fit(filespec) has been
loaded into _Fit(environment).  More precisely, it loads the specified file
unless a file whose file identifier (as given in its _tc(HERALD) form)
is _Fit(file-id) has already been loaded into _Fit(environment).
_end_Desc 

_Comdef(`REQUIRE',`Special form',
`(REQUIRE _Fit(file-id) _Fit(filespec)) _yl() _Fit(undefined)')
_begin_Desc
Like _tc(*REQUIRE), but operates with the current lexical environment.
E.g. if the current lexical environment is _tc(*MATH-ENV*),
then
_begin_Example
(REQUIRE FACT (MATH FACT))  _equiv()  (*REQUIRE 'FACT '(MATH FACT) *MATH-ENV*)
_end_Example
_end_Desc 
)

_DComment(
_Comdef(`OBJECT-FILE?',` ',
`(OBJECT-FILE? _Fit(filespec)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if the specified file is an object file.
_index(object files)
(Object files are the result of assembling the output of
TC; see page _Pageref(COMPILE-FILE).)
_end_Desc 

_Comdef(`OBJECT-FILE-STREAM?',` ',
`(OBJECT-FILE-STREAM? _Fit(input-port)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(port) is a port open on an object file.
This is only defined to work if no input has yet been read from _Fit(port).
_end_Desc 
)

_Section(File compilation)
_label(section:orbit)

In addition to the standard compiler invoked when _tc(EVAL) or
_tc(LOAD) is called,
_T provides an optimizing compiler.  This compiler,
known as _orbit, trades compilation
speed for execution speed: _tc(STANDARD-COMPILER) tries to compile quickly,
while _orbit tries to generate executable code which will run
fast.
_index(compilers)
_index(early bindings)

To help produce more efficient code, _orbit makes assumptions about the
values that some variables will have at run-time.  These assumptions
are called _iix(early bindings.)  For example, it will ordinarily assume
that the variable _tc(PAIR?) will have the standard _tc(PAIR?) predicate
as its top-level value.  This means that if an object file produced
under this assumption is loaded into a lexical environment where this
is not the case, then calls to _tc(PAIR?) will not execute the same as
they would if the source file had been loaded.

Early bindings are obtained from _iix(support environments).
The support environment to be used in compiling a file may be
specified by an _tc(ENV) clause in the file's
header.  (See page _Pageref(ENV).)
A support environment may contain user-defined integrable procedure
and constant definitions.

Besides early binding, another source of improved efficiency is a
difference in the handling of undefined effects (that is, run-time
program errors).
_index(undefined effects)
When code compiled using the standard compiler incurs an error, an
error is signalled, and the error system is entered, giving the user
an opportunity to debug the problem at the point where it occurs.
Code compiled using _orbit has less error-checking, so the effect of an
error may go unnoticed until long after the error occurred, or a
secondary error of an obscure or unexpected kind will occur.

_orbit can be invoked from within _T by using the following
functions.

_Comdef(`COMPILE-FILE',` ',
`(COMPILE-FILE _Fit(filespec)) _yl() _Fit(undefined)')
_label(COMPILE-FILE)
_begin_Desc
In _Tv(2) called _tix(COMFILE).
To compile a source file, say, _tc(fact.t), use
_wt((COMPILE-FILE _exqu(fact))).  _orbit writes three output files, all having the
same file name as the
_T source, and distinguished by extension:

_begin_Itemize
_Item()The _iix(noise file) is a transcript of what _orbit wrote to the terminal
in the course of the compilation.  _orbit also writes some additional
statistics and cross-referencing information to noise files.

_Item()The _iix(support file) contains early binding information useful
for compiling other files with _orbit().  See the _tc(ENV) file header
clause, page _Pageref(ENV)

_Item()The _iix(object file) contains the native code for the target
machine that can be loaded into _T.
_end_Itemize

The file extensions for the output files depend on the target architecture.
For MC68000, VAX, and Encore, the extensions are as follows:
_DComment(dorab: fix this for info)
_IfLatex(`\begin{center}
\begin{tabular}{llll}')
Architecture _colsep()Support     _colsep()Noise       _colsep()Object _LNL
68000        _colsep()_tc(.mi)    _colsep()_tc(.mn)    _colsep()_tc(.mo) _LNL
VAX11        _colsep()_tc(.vi)    _colsep()_tc(.vn)    _colsep()_tc(.vo) _LNL
Encore       _colsep()_tc(.ni)    _colsep()_tc(.nn)    _colsep()_tc(.no) _LNL
_IfLatex(`\end{tabular}
\end{center}')
_end_Desc

_Comdef(`ORBIT',`',
`(ORBIT _Fsem(expression . locale)) _yl() _Fsem(undefined)')
_begin_Desc
_wt(ORBIT) does expression at a time compilation, e.g.
_example((ORBIT '(DEFINE (F X) (+ X 1))))
will cause the expression to be compiled and loaded into the
(REPL-ENV).
_end_Desc

_Comdef(`CL',`',
`(CL _Fsem(expression)) _yl _Fsem(undefined)')
_wt((CL _Fit(expression))) prints out assembly code for _Fit(expression).

_DComment(dorab:todo)
_Comdef(`TC-SYNTAX-TABLE',`Settable',
`(TC-SYNTAX-TABLE) _yl() _Fit(syntax-table)')
_begin_Desc
This is the basic syntax table from which _orbit
obtains macro definitions.  _orbit obtains additional macro
definitions from the support environment set up by an _tc((ENV _dots()))
_tc(HERALD) clause.  Its default value is the syntax table of the
user environment.
_begin_Inset(Warning:)
This may change in the future.
_end_Inset
_end_Desc 

_Comdef(`ENV-FOR-SYNTAX-DEFINITION',`Settable',
`(ENV-FOR-SYNTAX-DEFINITION _Fit(syntax-table)) _yl() _Fit(environment)')
_label(ENV-FOR-SYNTAX-DEFINITION)
_begin_Desc
The environment in which macro                             
definition bodies themselves are evaluated, either as a result of
encountering a _tc(DEFINE-LOCAL-SYNTAX) or _tc(LET-SYNTAX)
expression, or by loading macro definitions from a
support file.
_orbit evaluates syntax-descriptors in the
_wt(ENV-FOR-SYNTAX-DEFINITION) associated with the syntax
table from which the descriptor was obtained, e.g.
for _wt((tc-syntax-table)), the default environment is _tc(USER-ENV).
_end_Desc 

_DComment( Should talk about what the compiler does; model of compiler as file
transducer, procedure integration and optimization, and all the rest.
Implementation of closures; when things are consed, how big they are.
_tc(HERALD), environments, and support files.  Problems with readmacros
and routines used by macro definitions.  Future work. )

_DComment( Need to talk about debugging compiled code - nonvalues and all that.
`Reference to non-existent memory.' )
