_Chapter(Lists)

_DComment( Say what a list is and why, what an atom is, what a pair is, etc.)

_DComment( Talk about various uses of lists:
as sets, as tables, as code trees. )

_DComment( Talk about external syntax for lists.  Whitespace, dots, etc. )

This section describes routines available for creating, examining,
and otherwise manipulating list structure.


_Section(Predicates)


_Comdef(`NULL?',`Type predicate',
`(NULL? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is the empty list (null).  Since the empty
list is also used for the logical false value, and non-false objects are
considered to be true, it turns out that _tc(NULL?) is the same as _tc(NOT).
_end_Desc 

_Comdef(`PAIR?',`Type predicate',
`(PAIR? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is a pair.
_begin_ExampleTabular
(PAIR? '(A B C))   _colsep()_evalto()_colsep  _Fsem(true) _LNL
(PAIR? '(A . 15))  _colsep()_evalto()_colsep  _Fsem(true) _LNL
(PAIR? '())        _colsep()_evalto()_colsep  _Fsem(false) _LNL
(PAIR? 'FOO)       _colsep()_evalto()_colsep  _Fsem(false)
_end_ExampleTabular
_end_Desc 


_Comdef(`ATOM?',`Type predicate',
`(ATOM? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is an atom.
An atom is any object that isn't a pair.
_begin_Example
(ATOM? _Fit(object))  _equiv()  (NOT (PAIR? _Fit(object)))
_end_Example
_end_Desc 


_Comdef(`LIST?',`Type predicate',
`(LIST? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is either a pair or the empty list.
_begin_ExampleTabular
(LIST? '(A B C))   _colsep()_evalto()_colsep  _Fsem(true) _LNL
(LIST? '(A . 15))  _colsep()_evalto()_colsep  _Fsem(true) _LNL
(LIST? '())        _colsep()_evalto()_colsep  _Fsem(true) _LNL
(LIST? 'FOO)       _colsep()_evalto()_colsep  _Fsem(false)
_end_ExampleTabular
_end_Desc 


_Comdef(`PROPER-LIST?',`Type predicate',
`(PROPER-LIST? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(list) is a properly formed list, i.e., if its last
pair's cdr is null.
_begin_ExampleTabular
(PROPER-LIST? '(A B C))    _colsep()_evalto()_colsep  _Fsem(true) _LNL
(PROPER-LIST? '(A B . C))  _colsep()_evalto()_colsep  _Fsem(false) _LNL
(PROPER-LIST? '())         _colsep()_evalto()_colsep  _Fsem(true)
_end_ExampleTabular
_end_Desc 

_Comdef(`NULL-LIST?',` ',
`(NULL-LIST? _Fit(list)) _yl() _Fit(boolean)')
_begin_Desc
Like _tc(NULL?), but has an undefined effect (and may, for example,
signal an error) if its argument is not either a pair or null.
_wt((NULL-LIST? _Fit(x))) is roughly the same as
_wt((NULL? (ENFORCE LIST? _Fit(x)))).
_end_Desc 

_Section(Constructors)

_Comdef(`CONS',` ',
`(CONS _Fit(object1 object2)) _yl() _Fit(pair)')
_begin_Desc
Returns a new pair whose car is _Fit(object1) and whose cdr is _Fit(object2).
_begin_ExampleTabular
(CONS 'A '())            _colsep()_evalto()_colsep  (A) _LNL
(CONS 'A 'B)             _colsep()_evalto()_colsep  (A . B) _LNL
(CONS 'A '(B))           _colsep()_evalto()_colsep  (A B) _LNL
(CONS 'A (CONS 'B '()))  _colsep()_evalto()_colsep  (A B) _LNL
(CONS 'A (LIST 'B 'C))   _colsep()_evalto()_colsep  (A B C)
_end_ExampleTabular
_end_Desc 

_Comdef(`LIST',` ',
`(LIST . _Fit(objects)) _yl() _Fit(list)')
_begin_Desc
Returns a new list of its arguments.
_begin_ExampleTabular
(LIST)                  _colsep()_evalto()_colsep  () _LNL
(LIST 'A)               _colsep()_evalto()_colsep  (A) _LNL
(LIST 'A 'B)            _colsep()_evalto()_colsep  (A B) _LNL
(LIST 'A (LIST 'B 'C))  _colsep()_evalto()_colsep  (A (B C)) _LNL
LIST  _colsep()_equiv()_colsep  (LAMBDA THINGS THINGS)
_end_ExampleTabular
_end_Desc 


_Comdef(`CONS*',` ',
`(CONS* . _Fit(objects)) _yl() _Fit(pair)')
_begin_Desc
_tc(CONS*) is a generalized _tc(CONS).
It returns a new, possibly improper, list,
by consing the initial _Fit(objects) onto the last _Fit(object).
_begin_ExampleTabular
(CONS* 1 2 3)          _colsep()_evalto()_colsep  (1 2 . 3) _LNL
(CONS* 'A 'B '(C D))  _colsep()_evalto()_colsep  (A B C D) _LNL
(CONS* _Fit(object))   _colsep()_equiv()_colsep  _Fit(object) _LNL
(CONS* _Fit(object1 object2)) _colsep()_equiv()_colsep  (CONS _Fit(object1 object2))
_end_ExampleTabular
_end_Desc 

_Comdef(`COPY-LIST',` ',
`(COPY-LIST _Fit(list)) _yl() _Fit(list)')
_begin_Desc
Makes a _qu(top-level) copy of a list; that is, returns a new
list whose elements are the same as the original.
_begin_ExampleTabbing
(COPY-LIST _settab()_Fit(list))  _equiv() _incrtab()_LNL
  (COND _settab()((NULL-LIST? _Fit(list)) '()) _LNL
        _gotab()(ELSE (CONS (CAR _Fit(list)) (COPY-LIST (CDR _Fit(list)))))) _decrtab()_LNL

(COPY-LIST _Fit(list))  _equiv()  (MAP IDENTITY _Fit(list)) _LNL
_end_ExampleTabbing
_end_Desc 

_Section(List access)

_Comdef(`CAR',`Settable',
`(CAR _Fit(pair)) _yl() _Fit(object)')
_begin_Desc
Returns the car of the _Fit(pair).
_wt((CAR '()) _yl() _Fsem(error)),
though, for compatibility, in _Tv(3.1) it will evaluate to _wt(()).
_end_Desc 

_Comdef(`CDR',`Settable',
`(CDR _Fit(pair)) _yl() _Fit(object)')
_begin_Desc
Returns the cdr of the _Fit(pair).
_wt((CDR '()) _yl() _Fsem(error)),
though, for compatibility, in _Tv(3.1) it will evaluate to _wt(()).
_end_Desc 

_Comdef(`C...R',`Settable',
`(C...R _Fit(pair)) _yl() _Fit(object)')
_begin_Desc
Compositions of _tc(CAR) and _tc(CDR), up to four deep, are defined.
_begin_ExampleTabular
(CADAR _Fit(x))   _colsep()_equiv()_colsep  (CAR (CDR (CAR _Fit(x)))) _LNL
(CADDDR _Fit(x))  _colsep()_equiv()_colsep  (CAR (CDR (CDR (CDR _Fit(x)))))
_end_ExampleTabular
_end_Desc 


_Comdef(`NTH',`Settable',
`(NTH _Fit(list n)) _yl() _Fit(object)')
_begin_Desc
Returns the _Fit(nth) element of _Fit(list).  The first element (the car) is
_wt((NTH _Fit(list) 0)), the second element is _wt((NTH _Fit(list) 1)),
and so on.  In general, _Fit(list) must have at least _Fit(n)+1 elements.
_DComment( not the nth! ... )
_begin_ExampleTabular
(NTH '(A B) 0)  _colsep()_evalto()_colsep  A _LNL
(NTH '(A B) 1)  _colsep()_evalto()_colsep  B _LNL
(NTH '(A B) 2)   _colsep()_colsep()_rm(has an undefined effect) _LNL
(NTH '() _Fit(n)) _colsep()_colsep()_rm(has an undefined effect for any _Fit(n))
_end_ExampleTabular
_end_Desc 


_Comdef(`NTHCDR',`Settable',
`(NTHCDR _Fit(list n)) _yl() _Fit(list)')
_begin_Desc
Returns the _Fit(nth) tail of _Fit(list).  In general, _Fit(list)
must have at least _Fit(n) tails.
_begin_ExampleTabular
(NTHCDR '(A B) 0)  _colsep()_evalto()_colsep  (A B) _LNL
(NTHCDR '(A B) 1)  _colsep()_evalto()_colsep  (B) _LNL
(NTHCDR '(A B) 2)  _colsep()_evalto()_colsep  () _LNL
(NTHCDR '(A B) 3)   _colsep()_colsep()_rm(has an undefined effect) _LNL
(NTHCDR '() _Fit(n)) _colsep()_colsep()_rm(has an undefined effect for any nonzero _Fit(n))
_end_ExampleTabular
    _begin_Inset(Bug:)
    _tc(NTHCDR) doesn't handle _tc(SETTER) (i.e. is not settable) in
    _T 3.1.
    _end_Inset
_end_Desc 


_Comdef(`LAST',`Settable',
`(LAST _Fit(list)) _yl() _Fit(object)')
_begin_Desc
Returns the last element of _Fit(list).
_begin_ExampleTabular
(LAST '(A B C))  _colsep()_evalto()_colsep  C _LNL
(LAST _Fit(list))  _colsep()_equiv()_colsep  (CAR (LASTCDR _Fit(list)))
_end_ExampleTabular
_end_Desc 

_Comdef(`LASTCDR',`Settable',
`(LASTCDR _Fit(list)) _yl() _Fit(pair)')
_begin_Desc
Returns the last pair in _Fit(list).
_begin_ExampleTabular
(LASTCDR '(A B C))    _colsep()_evalto()_colsep  (C) _LNL
(LASTCDR '(A B . C))  _colsep()_evalto()_colsep  (B . C)
_end_ExampleTabular
    _begin_Inset(Bug:)
    _tc(LASTCDR) doesn't handle _tc(SETTER) (i.e. is not settable) in
    _T 3.1.
    _end_Inset
_end_Desc 

_Section(Lists as sequences)

_Comdef(`LENGTH',` ',
`(LENGTH _Fit(list)) _yl() _Fit(integer)')
_begin_Desc
Return the length of _Fit(list).
_begin_ExampleTabular
(LENGTH '())       _colsep()_evalto()_colsep  0 _LNL
(LENGTH '(A B C))  _colsep()_evalto()_colsep  3
_end_ExampleTabular
_end_Desc 

_Comdef(`APPEND',` ',
`(APPEND . _Fit(lists)) _yl() _Fit(list)')
_begin_Desc
Constructs a list which is the concatenation of _Fit(lists).
A new list is constructed, except that the result has
the last non-null argument as a tail.
_begin_Example
(APPEND '(A B C) '(D E) '(F G))  _evalto()  (A B C D E F G)
_end_Example
_end_Desc 


_Comdef(`APPEND!',` ',
`(APPEND! . _Fit(lists)) _yl() _Fit(list)')
_begin_Desc
Destructive version of _tc(APPEND).  Splices the lists together,
setting the cdr of the last pair in the first list to
the second list, and so on.  Returns its first non-null argument.
_begin_ExampleTabular
(DEFINE L1 (LIST 'A 'B 'C)) _LNL
(DEFINE L2 (LIST 'D 'E)) _LNL
L1                _colsep()_evalto()_colsep  (A B C) _LNL
(APPEND! L1 L2)   _colsep()_evalto()_colsep  (A B C D E) _LNL
L1                _colsep()_evalto()_colsep  (A B C D E) _LNL
(APPEND! '() L2)  _colsep()_evalto()_colsep  (D E)
_end_ExampleTabular
_end_Desc 

_Comdef(`REVERSE',` ',
`(REVERSE _Fit(list)) _yl() _Fit(list)')
_begin_Desc
Returns a new list whose elements are those of _Fit(list), in reverse order.
_begin_Example
(REVERSE '(A B C))  _evalto()  (C B A)
_end_Example
_end_Desc 


_Comdef(`REVERSE!',` ',
`(REVERSE! _Fit(list)) _yl() _Fit(list)')
_begin_Desc
This is a _qu(destructive) version of _tc(REVERSE);
it allocates no storage for the result, but rather recycles
the pairs in the source _Fit(list)'s to form the result list.
_index(destructive)
_end_Desc 

_Comdef(`SUBLIST',` ',
`(SUBLIST _Fit(list) _Fit(start) _Fit(count)) _yl() _Fit(list)')
_begin_Desc
Returns a list of _Fit(count) elements of _Fit(list),
beginning with element _Fit(start).
_begin_Example
(SUBLIST '(A B C D E F) 2 3)  _evalto()  (C D E)
_end_Example
_end_Desc 

_Section(Lists as sets)

_Comdef(`MEMQ?',` ',
`(MEMQ? _Fit(object list)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is an element of _Fit(list).
_begin_ExampleTabular
(MEMQ? 'B '(A B C))           _colsep()_evalto()_colsep  _Fsem(true) _LNL
(MEMQ? 'B '(A (B C) D))       _colsep()_evalto()_colsep  _Fsem(false) _LNL
(MEMQ? 'B '(B))               _colsep()_evalto()_colsep  _Fsem(true) _LNL
(MEMQ? 'B '())                _colsep()_evalto()_colsep  _Fsem(false) _LNL
(MEMQ? 17 '(10 17))           _colsep()_evalto()_colsep  _rm(undefined) _LNL
(MEMQ? `foo' '(`foo' `bar'))  _colsep()_evalto()_colsep  _rm(undefined) _LNL
(LET ((X `foo')) _LNL
  (MEMQ? X (LIST 'B X)))      _colsep()_evalto()_colsep  _Fsem(true)
_end_ExampleTabular
_end_Desc 

_Comdef(`MEM?',` ',
`(MEM? _Fit(predicate object list)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(list) contains an object which
is equal to _Fit(object) according to _Fit(predicate),
which should be an equality predicate.
_begin_ExampleTabular
(MEM? = 17 '(10 17))                       _colsep()_evalto()_colsep  _Fsem(true) _LNL
(MEM? STRING-EQUAL? `foo' '(`foo' `bar'))  _colsep()_evalto()_colsep  _Fsem(true)
_end_ExampleTabular
_end_Desc 

_Comdef(`ANY?',` ',
`(ANY? _Fit(predicate) . _Fit(lists)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if any element of _Fit(list) answers true to _Fit(predicate).
_begin_Example
(ANY? NUMBER? '(FOO 15 BAR))  _evalto()  _Fsem(true)
_end_Example
_end_Desc 

_Comdef(`EVERY?',` ',
`(EVERY? _Fit(predicate) . _Fit(lists)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if every element of _Fit(list) answers true to _Fit(predicate).
_begin_Example
(EVERY? SYMBOL? '(A B C))  _evalto()  _Fsem(true)
_end_Example
_end_Desc 

_Comdef(`DELQ',` ',
`(DELQ _Fit(object list)) _yl() _Fit(list)')
_begin_Desc
Returns a list which is the same as the argument _Fit(list)
with all occurrences of _Fit(object) removed.
_end_Desc 

_Comdef(`DEL',` ',
`(DEL _Fit(predicate object list)) _yl() _Fit(list)')
_begin_Desc
Returns a list which is the same as _Fit(list) except that all
elements which, according to _Fit(predicate),
are equal to _Fit(object), have been removed.
_Fit(Predicate) should be an equality predicate.
_begin_Example
(DELQ _Fit(object list))  _equiv()  (DEL EQ? _Fit(object list))
_end_Example
_end_Desc 

_Comdef(`DELQ!',` ',
`(DELQ! _Fit(object list)) _yl() _Fit(list)')
_begin_Desc
Destructive version of _tc(DELQ).
Removes all occurrences of _Fit(object) from _Fit(list),
possibly altering it, and returns the new and/or modified list.
_end_Desc 

_Comdef(`DEL!',` ',
`(DEL! _Fit(predicate object list)) _yl() _Fit(list)')
_begin_Desc
Destructive version of _tc(DEL).
_begin_Example
(DELQ! _Fit(object list))  _equiv()  (DEL! EQ? _Fit(object list))
_end_Example
_end_Desc 

_Section(Mapping Procedures)

_Comdef(`MAP',` ',
`(MAP _Fit(proc) . _Fit(lists)) _yl() _Fit(list)')
_label(MAP)
_begin_Desc
Returns a list of the results of applying _Fit(proc) to successive elements
of the _Fit(lists); the _Fit(nth) element of the result list is the result
of calling _Fit(proc) on the _Fit(nth) elements of the _Fit(lists).
The length of the result list is the same as the length of the shortest
of the _Fit(lists).
_begin_ExampleTabular
(MAP (LAMBDA (X) (LIST 'A X)) '(CAT DOG))  _colsep()_evalto()_colsep  ((A CAT) (A DOG)) _LNL
(MAP + '(10 20) '(5 6))                    _colsep()_evalto()_colsep  (15 26) _LNL
(MAP LIST '(A B) '(C D E) '(F))            _colsep()_evalto()_colsep  ((A C F))
_end_ExampleTabular
_end_Desc 

_Comdef(`MAPCDR',` ',
`(MAPCDR _Fit(proc) . _Fit(lists)) _yl() _Fit(list)')
_begin_Desc
_tc(MAPCDR) is similar to _tc(MAP), except that _Fit(proc) is applied to
successive _Fit(tails) of the _Fit(lists).
_end_Desc 

_Comdef(`MAP!',` ',
`(MAP! _Fit(proc) _Fit(list)) _yl() _Fit(list)')
_begin_Desc
For each pair in _Fit(list), applies _Fit(proc) to the car of the pair,
and then modifies the pair so that its car is the value of the
application.
_begin_ExampleTabular
(DEFINE L (LIST 'CAT 'DOG))  _colsep()_evalto()_colsep  (CAT DOG) _LNL
(MAP! (LAMBDA (X) (LIST 'A X)) L) _LNL
L  _colsep()_evalto()_colsep  ((A CAT) (A DOG))
_end_ExampleTabular
_end_Desc 

_Comdef(`WALK',` ',
`(WALK _Fit(proc) . _Fit(lists)) _yl() _Fit(undefined)')
_label(WALK)
_begin_Desc
This is similar to _tc(MAP) but the result is 
a value of no particular interest.
Thus _tc(WALK) is useful only for the side-effects that _Fit(proc) performs.
_end_Desc 

_Comdef(`WALKCDR',` ',
`(WALKCDR _Fit(proc) . _Fit(lists)) _yl() _Fit(undefined)')
_begin_Desc
This is similar to _tc(MAPCDR) but the result is a value of no particular
interest.
_end_Desc 

_Section(Lists as associations)

_Comdef(`ASSQ',` ',
`(ASSQ _Fit(object list)) _yl() _Fit(pair) _rm(or) _Fit(false)')
_begin_Desc
_begin_Example
(ASSQ _Fit(object list))  _equiv()  (ASS EQ? _Fit(object list))
_end_Example
_end_Desc 

_Comdef(`ASS',` ',
`(ASS _Fit(predicate object list)) _yl() _Fit(pair) _rm(or) _Fit(false)')
_begin_Desc
An _iix(association list)
is a list of pairs that represents
a _qu(lookup table) where the car of each pair matches a lookup key.  _tc(ASS)
and its related procedures search association lists by comparing
(applying _Fit(predicate)) the key (_Fit(object)) against the car of each
element of _Fit(list) (i.e., the caar of each tail).  If it finds a match,
it returns that element (the car of the tail).  If it finds no match,
it returns false.
_begin_ExampleTabular
(ASS EQ? 'B '((A 10 20) (B 30 40) (C 50 60)))  _colsep()_evalto()_colsep  (B 30 40) _LNL
(ASS = 9 '((1 Y) (4 Y) (9 Z) (12 P)))          _colsep()_evalto()_colsep  (9 Z) _LNL
(ASS = 10 '((1 Y) (4 Y) (9 Z) (12 P)))         _colsep()_evalto()_colsep  _Fsem(false)
_end_ExampleTabular
_end_Desc 

_Section(Lists as stacks)

_tc(PUSH) and _tc(POP) permit a convenient syntax for the use of lists
in implementing simple stacks.  They are assignment forms, like _tc(SET)
and _tc(INCREMENT).  See section _Ref(section:assignment) for a general
discussion of assignment forms.

_Comdef(`PUSH',`Special form',
`(PUSH _Fit(location object)) _yl() _Fit(undefined)')
_begin_Desc
_DComment( Bogus description - fix. )
Cons a pair whose car is _Fit(object) and whose cdr is
the value in _Fit(location) (usually a list), and
store the extended list back into _Fit(location).
_begin_ExampleTabular
(LSET L '(34 55))  _colsep()_evalto()_colsep  (34 55) _LNL
(PUSH L 21) _LNL
L                  _colsep()_evalto()_colsep  (21 34 55) _LNL
(PUSH L '(A B C)) _LNL
(PUSH (CAR L) 'D) _LNL
L                  _colsep()_evalto()_colsep  ((D A B C) 21 34 55)
_end_ExampleTabular

In general,
_begin_ExampleTabbing
(PUSH _settab()_Fit(location object)) _incrtab()_LNL
  _equiv()  (SET _Fit(location) (CONS _Fit(object location))) _LNL
  _equiv()  (MODIFY _Fit(location) (LAMBDA (L) (CONS _Fit(object) L))) _LNL
_end_ExampleTabbing
_end_Desc 

_Comdef(`POP',`Special form',
`(POP _Fit(location)) _yl() _Fit(object)')
_begin_Desc
The car of the value in _Fit(location)
(this value should be a pair) is returned.  As a side-effect,
the cdr of the list is stored back in the location.
_begin_ExampleTabular
L        _colsep()_evalto()_colsep  (21 34 55) _LNL
(POP L)  _colsep()_evalto()_colsep  21 _LNL
L        _colsep()_evalto()_colsep  (34 55)
_end_ExampleTabular
In general,
_begin_ExampleTabbing
(POP _settab()_Fit(location))  _equiv()   _incrtab()_LNL
  (BLOCK0 (CAR _Fit(location)) _settab()(SET _Fit(location) (CDR _Fit(location)))) _LNL
                    _gotab()_equiv()   _LNL
  (BLOCK0 (CAR _Fit(location)) (MODIFY _Fit(location) CDR))
_end_ExampleTabbing
_end_Desc 
