@part[File, root "TMAN.MSS"]        @Comment{-*-System:TMAN-*-}
@chap[Files]


An executing @Tau[] system interacts with the world outside by
communicating with various external entities, including:

@itemize[
    @i[people], via keyboards and displays;

    @iix[file systems], via operating system calls, possibly over
    a communications network;

    and @i[processes], running on the same machine or on different machines.
    ]

The language provides simple standardized interfaces to the first
two of these.  Particular implementations may provide more complete
interfaces.

Standard access to a terminal is provided by the streams @tc[TERMINAL-INPUT]
and @tc[TERMINAL-OUTPUT] (page @pageref[TERMINAL-INPUT]).
Access to file systems is provided by the facilities described in this
chapter.

    @BeginInset[Disclaimer:]
    The file naming facilities described in this chapter
    are quite preliminary and are subject to change and elaboration.
    This documentation corresponds to what is available in @Timp[] 2.7.
    @EndInset[]


@section[File systems]

A @iixs[file system] is a collection of named permanent objects called
@iix[files], and a mechanism for manipulating this collection.
A @iixs[file system object] is a @Tau[] object which names
or represents an actual file system.  Where the distinction is
unimportant, a file system object is referred to simply as a file
system.

A given @Tau[] implementation may provide access to multiple file
systems; such a facility is not described in this manual.  However,
one may assume that at least one file system, known as the
@iix[local file system], is accessible.

@desc[(LOCAL-FS) @yl[] @i[file-system]]
Returns the local file system object.
@enddesc[LOCAL-FS]

The following type predicates are defined to query the type of a file
system.

@info[notes="Type predicate"]
@desc[(AEGIS-FS? @i[file-system]) @yl[] @i[boolean]]
Returns true if @i[file-system] represents an Aegis file system.
@enddesc[AEGIS-FS?]

@info[notes="Type predicate"]
@desc[(UNIX-FS? @i[file-system]) @yl[] @i[boolean]]
Returns true if @i[file-system] represents a Unix file system.
@enddesc[UNIX-FS?]

@info[notes="Type predicate"]
@desc[(VMS-FS? @i[file-system]) @yl[] @i[boolean]]
Returns true if @i[file-system] represents a VMS file system.
@enddesc[VMS-FS?]


@section[Filenames]

A @iixs[filename] is an object which names a file.
Filenames are immutable record structures with the following
components:

@begin[itemize]
@i[File system:] the file system object via which the named file is
accessible.

@i[Directory:] a collection of files within the file system
to which the named file belongs.

@i[Name:] the name of the file within the directory, or of a family
of files, as further specified by the file type and generation components
of the filename.

@i[Type:] the type of the file (also known as @qu[extension]).

@i[Generation:] a positive integer specifying a particular version
or incarnation of the file.  Larger generation numbers indicate newer
versions.
@end[itemize]

In general, the directory, name, and type components of a file
are usually symbols, the file system component is a file system
object, and the generation component is an integer.
The file system component may be a symbol which names a file system
in an implementation-dependent manner.

Filenames may be incompletely specified; missing components
are represented by having null (false) as their value.  An omitted
file system is usually interpreted to be the same as the local file system,
an omitted directory component means the current working directory.
The name component may not be omitted.

The external representation of a filename has the form
  @begin[ProgramExample]
#[Filename @i<file-system dir name type gen>]
  @end[ProgramExample]
where @i[gen] and @i[type] may be omitted, if null.


@descN[
F1 = "(MAKE-FILENAME @i[file-system dir name type gen]) @yl[] @i[filename]",
F2 = "(MAKE-FILENAME @i[file-system dir name type]) @yl[] @i[filename]",
F3 = "(MAKE-FILENAME @i[file-system dir name]) @yl[] @i[filename]",
FN1 = "MAKE-FILENAME"
]
Returns a filename.  The arguments become the components of the filename
object.  @i[Type] and @i[gen] may be omitted, in which case they default to
null (absent).
@enddescN[]

@desc[(->FILENAME @i[filespec]) @yl[] @i[filename]]
Coerces @iixs[filespec] to a filename.
@begin[itemize]
If @i[filespec] is a filename, then it is returned.

If @i[filespec] is a list @i[l], then @tc[MAKE-FILENAME] is called,
passing null as the file system argument, and the elements of
the list as the rest of the arguments.

If @i[filespec] is a symbol @i[x], then it is treated the same
as the list @tc[(() @i[x])].

If @i[filespec] is a string, then it is converted to a filename
in an implementation-dependent way, such that @tc[FILENAME->STRING]
applied to the filename will return a string which is equal
to @i[filespec].
@end[itemize]

For example:
  @begin[ProgramExample]
(->FILENAME '#[Filename () MATH FACT T])  @ev[]  #[Filename () MATH FACT T]
(->FILENAME '(MATH FACT T))               @ev[]  #[Filename () MATH FACT T]
(->FILENAME '(MATH FACT))                 @ev[]  #[Filename () MATH FACT]
(->FILENAME 'FACT)                        @ev[]  #[Filename () () FACT]
(->FILENAME "fact.t")                     @ev[]  #[Filename () () FACT T]
  @end[ProgramExample]
The last example is plausible, but it will not necessarily hold in
all @Tau[] implementations, since the coercion of strings to filenames
is not defined here.  (In @Timp[] 2.7, strings are @i[not] parsed into
separate filename components.)
@enddesc[->FILENAME]

@info[notes="Type predicate"]
@desc[(FILENAME? @i[object]) @yl[] @i[boolean]]
Returns true if @i[object] is a filename.
@enddesc[FILENAME?]

@desc[(FILENAME-FS @i[filename]) @yl[] @i[file-system] @r[or] @i[false]]
Returns the file system component of @i[filename], or false (null)
if it has none.
@enddesc[FILENAME-FS]

@desc[(FILENAME-DIR @i[filename]) @yl[] @i[symbol] @r[or] @i[false]]
Returns the directory component of @i[filename].
@enddesc[FILENAME-DIR]

@desc[(FILENAME-NAME @i[filename]) @yl[] @i[symbol]]
Returns the name component of @i[filename].
  @begin[ProgramExample]
(FILENAME-NAME '#[Filename () MATH FACT T])  @ev[]  FACT
  @end[ProgramExample]
@enddesc[FILENAME-NAME]

@desc[(FILENAME-TYPE @i[filename]) @yl[] @i[symbol] @r[or] @i[false]]
Returns the type component of @i[filename].
@enddesc[FILENAME-TYPE]

@desc[(FILENAME-GENERATION @i[filename]) @yl[] @i[integer] @r[or] @i[false]]
Returns the generation component of @i[filename].
@enddesc[FILENAME-GENERATION]

@desc[(FILENAME->STRING @i[filename]) @yl[] @i[string]]
Returns a string representing @i[filename] in the native syntax
of @i[filename]'s file system (or of the local file system if
@i[filename] is null).

In @Timp[] 2.7, if the directory component of @i[filename] is a symbol,
then it is interpreted as a @qu[logical name] in a manner idiosyncratic
to the type of the file system:
@begin[itemize]
    Aegis: a @Tau[] logical name is interpreted as being a link in the
    naming directory.

    Unix: a @Tau[] logical name is an environment variable.

    VMS: a @Tau[] logical name is a VMS logical name.
@end[itemize]
For example:
  @begin[ProgramExample]
(FILENAME->STRING '#[Filename AN-AEGIS-FS MATH FACT T])
  @ev[]  "~math/fact.t"
(FILENAME->STRING '#[Filename A-UNIX-FS MATH FACT T])
  @ev[]  "/usr/math/fact.t"
(FILENAME->STRING '#[Filename A-VMS-FS MATH FACT T])
  @ev[]  "MATH:FACT.T"
  @end[ProgramExample]
(In the Unix example, we assume that environment variable @tc[MATH] was
defined to be @tc[/usr/math], e.g. by a @qu"@tc[setenv MATH /usr/math]"
shell command.)
@enddesc[FILENAME->STRING]


@section[Files]

A @iixs[file] is an external permanent object stored in a file system.
Files are accessed in @Tau[] via streams.
Ordinarily, files are sequences of characters, similar to strings.
An input stream open on an existing file delivers successive characters
(or lines, or parsed objects) out of the file.  An output stream open
on a new file deposits successive characters (or lines, or printed
representations of objects) into the file.

@tc[OPEN] and @tc[MAYBE-OPEN] obtain streams which access files.
Any stream created by @tc[OPEN] or @tc[MAYBE-OPEN] should be closed
(using the @tc[CLOSE] operation, page @pageref[CLOSE])
when no further access to the file is required.  This is guaranteed
if @tc[OPEN] and @tc[MAYBE-OPEN] are always used in conjunction with
@tc[WITH-OPEN-STREAMS] (page @pageref[WITH-OPEN-STREAMS]), which ensures
that any stream opened actually gets closed, even if there is a throw
out of the body of the @tc[WITH-OPEN-STREAMS] form.

@desc[(OPEN @i[filespec mode-list]) @yl[] @i[stream]]
Opens an external file for reading or for writing, and returns
a stream which accesses it.
@i[Filespec] should be a filename or any other object which can
be coerced to one (see @tc[->FILENAME], page @pageref[->FILENAME]).
@i[Mode-list] should be
a list of keywords (symbols) specifying what kind of
access to the file is desired.
The only keywords currently recognized are @tc[IN], @tc[OUT], and
@tc[APPEND], indicating reading, writing, and appending, respectively.
It is an error condition if the file cannot be opened for some reason.
  @begin[ProgramExample]
(WITH-OPEN-STREAMS ((STREAM (OPEN "file.txt" '(IN))))
  (READ-LINE STREAM))
  @end[ProgramExample]
@EndDesc[OPEN]

@desc[(MAYBE-OPEN @i[filespec modes]) @yl[] @i[stream] @r[or] @i[false]]
Like @tc[OPEN], but returns false if for any reason it
cannot open the file.
@EndDesc[MAYBE-OPEN]

@info[NOTES="Operation"]
@desc[(STREAM-FILENAME @i[stream]) @yl[] @i[filename]]
Returns the filename of the file on which @i[stream] is open.
This operation is not handled by any system-created streams other than
those created by @tc[OPEN] and @tc[MAYBE-OPEN].
@enddesc[STREAM-FILENAME]

@desc[(FILE-EXISTS? @i[filespec]) @yl[] @i[boolean]]
Returns true if the specified file exists.
@EndDesc[FILE-EXISTS?]

@desc[(FILE-MOVE @i[source-filespec] @i[dest-filespec]) @yl[] @i[undefined]]
Moves the file named by @i[source-filespec] to a new location given by
@i[dest-filespec].
In some cases, this operation can be performed without actually
copying the file, for example, if the two locations are on the same
@qu[volume] of the same file system.  In this case, @tc[FILE-MOVE]
is simply a rename operation.  In other cases, it may be more expensive.
    @BeginInset[Bug:]
    Not all versions of @Timp[] 2.7 implement @tc[FILE-MOVE].
    @EndInset[]
@EndDesc[FILE-MOVE]

@desc[(FILE-DELETE @i[filespec]) @yl[] @i[undefined]]
Deletes the specified file.
    @BeginInset[Bug:]
    Not all versions of @Timp[] 2.7 implement @tc[FILE-DELETE].
    @EndInset[]
@EndDesc[FILE-DELETE]
