@part[FUTURE, root "TMAN.MSS"]	@Comment{-*-System:TMAN-*-}
@appendix[Future work]
@label[FutureChapter]


This appendix catalogs some ideas about @Tau[]'s future development.
It is provided as a stimulus for user input, and as an assurance
that these problems are known and are being addressed.


@Section[Language design problems]

A system for managing multiple namespaces @dash[] loading files into
appropriate environments, and communicating names from one
module to another in a controlled way @dash[] is sorely needed.

Better aggregate structures are needed (arrays, hash tables).

Read macro procedures ought to take a read table as an argument.

A condition/error signalling system is needed.

Need to make up for the loss of Scheme's general @tc[CATCH] by
implementing coroutines.  Indeterminacy, timeslicing, and
synchronization primitives would be nice also.

Each special form should be marked as being either primitive or a
macro.  This would allow users to write robust program-manipulating
programs using only the released language.

There should be a way to remove bindings from locales.

There ought to be able to have variables named by objects other than
symbols.  Maybe there ought to be a generalized @tc[INTERN] which
creates a unique instance of any object, or something like OWL's
@tc[UCONS] (unique cons) primitive.

Should reintroduce @tc[DEFINE-LOCALE]?

@tc[MEMQ], @tc[ASSQ], @tc[POSQ], etc. are inconsistent with the other
aggregate accessing routines in that the aggregate argument follows the
index argument and not vice versa.

Ideas for list routines: @tc[SUBSET], @tc[FILTER], @tc[FIND],
set operations.

Need a term more specific than @qu"tree" for whatever those things are.

The tree manipulation routines (e.g. @tc[ALIKEV?]) should be
user-extensible.  Big problem with what @tc[TREE-HASH] should do with
unusual leaf nodes.

There should be a general way to do generic dispatches based on more
than one argument.

There should be a non-side-effecting way to define methods for structures.

@tc[SYNONYM] is a misleading name.

@tc[SETTER] is inadequate.  Why not @tc[PUSHER], @tc[SWAPPER],
etc.?  Is there any way to do this that's at the same time convenient,
general, and efficient?

@tc[CASE] and @tc[SELECT] should use @tc[EQUIV?] instead of @tc[EQ?].

Method-clauses aren't incrementally redefinable.  What to do about this.
Objects handling many operations become quite unmanageable.
Maybe this is an implementation and editor problem, not a language problem.

The looping/iteration constructs are maybe a little too simple.  Figure
out some better ones without compromising principles, if possible.
Waters' @tc[LetS] looks sort of good.

@tc[CHECK-ARG] is ad hoc.  Need type inference and other compiler smarts.
Need better type declaration syntax.

The character @qu"abstraction" is perhaps too closely tied to ASCII.
The @wt<#[Char ...]> syntax should probably be @wt<#[Ascii ...]>
instead.

There should be case-ignoring character and string comparison predicates.

@tc[STRING-POSQ] is not a good name.

@tc[STRING-REPLACE] should probably be called @tc[STRING-REPLACE!],
or flushed.  Similarly with @tc[VECTOR-FILL], @tc[VECTOR-REPLACE].

The name @tc[DIGIT?] is nconsistent with @tc[DIGIT->CHAR] @dash[]
does the term @i[digit] mean a character or an integer?

What about @tc[UPPERCASE?] @yl[] @tc[UPPER-CASE?]?  Ugh.

Enumerated types.

Shouldn't it be @tc[*T*] and @tc[*F*] for true and false?  (This is
mostly a frivolous suggestion, but...)

Infinities?

@tc[DIV] is a random name.

Should @tc[NOT-ZERO?] and friends be renamed to be @tc[NONZERO?] etc.?

Divulge expression syntax for backquote?

Release @tc[WALK-POPULATION]?  It's redundant, but handy.

Maybe release @tc[BOUND?].

Need a way to make read tables be read-only.

Need @tc[LET-SYNTAX-TABLE] and @tc[LET-READ-TABLE] features?

Maybe flush the random not-parsable-as-number-implies-symbol syntax feature.
It can be a real pain to catch typos in numbers.

I/O system improvements needed:
@itemize[
Streams are pretty random.  How does a stream differ from a sequence?
There should be ways to coerce from streams to (infinite) sequences,
and vice versa.  Maybe the term @i[stream] should follow Sussman's usage
(infinte sequence), not Common Lisp's (pointer into same).

The @tc[FORMAT] sublanguage is random and unextensible.

Block-mode and/or @qu"binary" I/O, for database or whatever applications.

There ought to be a way to make the printer complain if it comes
across an object which isn't re-readable.

Ought to be a way to establish the line-length of a stream.

@tc[HPOS] and @tc[VPOS] aren't precisely defined.

@tc[SPACE] operation needs a better definition.
]

Structure package improvements needed:
@itemize[
@tc[DEFINE-STRUCTURE-TYPE] features: initializers, variant record types,
arguments to constructor procedure, type-restricted fields, alternate
name construction.

Maybe structures should have an official external syntax.

Structures ought to be callable.

@tc[COPY-STRUCTURE] and @tc[COPY-STRUCTURE!] ought to take as an
additional argument the structure type to which the structure belongs.
Alternatively, a copying procedure could be associated with the
structure type object itself.

Maybe there ought to be a way to test initializedness of structure components.
]


@section[Common Lisp influence]

The design and implementation of @tau[] began around the same time that
the Common Lisp design effort started in earnest.  Some of the goals
of the projects have been similar; in many cases, the @tau[] designers
left certain problems for the Common Lisp designers to work out,
intentionally ignoring many sticky issues, such as numeric routines,
sequences, and arrays, in order to work on other areas.

Now that the Common Lisp language has matured, and portable
implementations are approaching reality, two distinct integration
projects are in order: importing ideas and facilities from Common
Lisp into @Tau[] (with appropriate customization); and building a
Common Lisp emulation package in @Tau[].

@Tau[] itself will never contain Common Lisp as a subset, but it should be
suitable as an implementation language for a Common Lisp.
This will probably take the form of alternate evaluator, reader, printer,
and namespace, together with a Common Lisp-to-@Tau[] translator.

The following Common Lisp features, at least, should be incorporated
into @Tau[] in some form:
@itemize[
  Arrays.

  Sequences.  (These would clean up a lot of the current clutter with the
  string and vector routines, but introduce a new level of implementation
  hair.)

  Multiple values.  These can be simulated now with continuation-passing,
  but the syntax is clumsy.

  Numeric routines.  Ratios and complexes.
  Multiple floating point precisions.

  @tc[SHIFTF] and @tc[ROTATEF].  (These are generalized versions of @Tau[]
  @tc[SWAP] and @tc[EXCHANGE].)

  Hash tables.

  @tc[FORMAT] enhancements: floating-point formats, etc.

  File dates.  Time and date manipulation.  Time and date parsing.
]


@section[Bugs in the implementation]

@label[BugsSection] @comment{preface}

The implementation (@Timp[] 2.7) doesn't implement everything described
in this manual.

@itemize[
    Not implemented:
    @tc[ATAN2],
    @tc[JOIN],
    @tc[ROUND],
    @tc[STREAM-POSITION],
    and @tc[TRUNCATE].
]

Many things are implemented incorrectly.

@itemize[
    Deficiencies in syntax environments (they don't exist per se) and in
    locales (shadowing loses).

    @tc[GENERATE-SYMBOL]:  The implementation generates obscure
    names, but doesn't
    guarantee uniqueness.  That is, the symbols are interned.

    @tc[ANY?] and @tc[EVERY?] of more than one list don't work.

    @tc[GET] and @tc[PUT] work only on symbols.

    @tc[READ-LINE] and @tc[UNREAD-CHAR] interact badly.

    There is no way to trace an operation.
]

Many things are implemented less efficiently than they ought to be.

@itemize[
    The garbage collector is slow.  This should be fixed.

    There ought to be an option to invoke the standard compiler on
    demand, as code is run, instead of all at once, as code is loaded.

    @tc[BIND] is implemented in a pretty cons-intensive way;
    there's a bigger performance penalty for dynamic binding than one would
    find in other Lisp implementations.

    @qu"Lexprs" are inefficient because they always cons a list for the
    rest-variable.

    The i/o system doesn't do any buffering; this really slows down
    reading and printing a lot, most notably the loading of code files.

    Operation dispatch could be done using hash tables.  @tc[DEFINE-OPERATION]
    needs to do early binding.  This is feasible, but the implementation
    could become quite hairy.

    Locales are permanent (!), and forward references to shadowed variables
    will lose big, especially with the standard compiler.

    The interpreter conses a lot more than it ought to.  It ought to do some
    small amount of closure analysis, or else use McDermott's dynamic
    migration hack.

    The combinator routines are pretty useless since TC doesn't know
    anything about them.  This should be fixed.  For example,
    @tc[((COMPOSE CAR CDR) '(A B C))] is evaluated, even in compiled code,
    by actually consing a procedure, and then invoking it.
]

Many things in the system are implemented less smoothly than they ought to be.

@itemize[
    Many system routines still don't check their argument types, for example
    @tc[LOWERCASE?] and @tc[UPPERCASE?].

    Redefining @tc[DEFINE-CONSTANT]'ed and @tc[DEFINE-INTEGRABLE]'d
    should report an error condition.

    Newline characters following input lines come out at the wrong place
    in transcript files.

    @tc[LOAD] ought to be smarter about file dates, checking for
    recompilation, etc.

    Interpreted @tc[QUOTE] ought to enforce read-only-ness.

    There ought to be a way to enforce the downwards-only-ness of escape
    procedures.
]

@dc{
TC bugs.

@itemize[
    Sometimes screws up the stack pointer.

    DEFINE-INTEGRABLE of a recursive procedure loses.
]
}

Missing features.

@itemize[
    @tc[SUSPEND] and/or clean embedded-system-building tools.

    Help system.

    More system self-knowledge: who calls x, who does x call, type analysis,
    etc.  Masterscope-like stuff.

    Block compilation.

    There should be a version of @tc[TRACE] which @i[destructively]
    modifies a procedure so that it acts traced.

]
