/*
 *
 * u n i x . c					-- Some Unix primitives
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *           Author: Erick Gallesio [eg@kaolin.unice.fr]
 *    Creation date: 29-Mar-1994 10:57
 * Last file update:  7-Jun-1994 11:53
 */

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "stk.h"

static char *absolute(char *s, char *pathname)	
     				/* Returns (mostly clean) absolute pathname of s */
{
  char *p = pathname;
  
  if (s[0] != '/') {
    getcwd(pathname, MAX_PATH_LENGTH);
    p = &pathname[strlen(pathname)];     /* place p at end of pathname */ 
  }
  *p = '/';

  for ( ; *s; s++) {
    switch (*s) {
      case '.' : if (*(s+1)) {
	           switch (*++s) {
		     case '.' : if (*(s+1) == '\0' || *(s+1) == '/') { 
			          /* We must go back to the parent */
			          if (*p == '/' && p > pathname) p--;
			          while (p > pathname && *p != '/') p--;
			        }
			        else {
			          *++p = '.';
			          *++p = '.';
			        }
			        break;
		     case '/' : if (*p != '/') *++p = '/'; 
		                break;
		     default  : *++p = '.'; *++p = *s; break;
		   }
		 }
		 break;
      case '/' : if (*p != '/') *++p = '/'; break;
      default  : *++p = *s;
    }
  }
  
  /* Place a \0 at end. If path ends with a "/", delete it */
  if (p == pathname || *p != '/') p++;
  *p = '\0';
}

SCM internal_expand_file_name(char *s)
{
  SCM z;
  char abs[2 * MAX_PATH_LENGTH];  
    /* Warning: absolute makes no control about path overflow. Hence the "2 *" */

#ifdef USE_TK
  Tcl_DString buffer;
  s = Tcl_TildeSubst(main_interp, s, &buffer);
  if (s == NULL) {
    Tcl_DStringFree(&buffer);
    err(main_interp->result, NIL);
  }
#endif

  absolute(s, abs);
  z = makestrg(strlen(abs), abs);

#ifdef USE_TK  
  Tcl_DStringFree(&buffer);
#endif
  return z;
}

void whence(char *exec, char *path)
{
  char *p, *q, dir[MAX_PATH_LENGTH];
  struct stat buf;
 
  if (*exec == '/') strncpy(path, exec, MAX_PATH_LENGTH);

  p = getenv("PATH");
  while (*p) {
    /* Copy the stuck of path in dir */
    for (q = dir; *p && *p != ':'; p++, q++) *q = *p;
    *q = '\000';

    sprintf(path, "%s/%s", dir, exec);
    if (access(path, X_OK) == 0) {
      stat(path, &buf);
      if (!S_ISDIR(buf.st_mode)) return;
    }
    
    /* Try next path */
    if (*p) p++;
  }
  /* Not found. Set path to "" */
  path[0] = '\0';
}


PRIMITIVE expand_file_name(SCM s)
{
  if (NSTRINGP(s)) err("expand-file-name: bad string", s);
  return internal_expand_file_name(CHARS(s));
}


PRIMITIVE lgetcwd(void)
{
  
  char *buf = (char *)getcwd(NULL, MAX_PATH_LENGTH);
  SCM z;

  if (!buf) err("getcwd: cannot allocate space", NIL);
  z = makestrg(strlen(buf), buf);
  free(buf);
  
  return z;
}

PRIMITIVE lchdir(SCM s)
{
  if (NSTRINGP(s)) err("chdir: bad string", s);
  
  if (chdir(CHARS(internal_expand_file_name(CHARS(s)))))
      err("chdir: cannot change directory to", s);
  return UNDEFINED;
}

PRIMITIVE lgetpid(void)
{
  return (makeinteger((int) getpid()));
}

PRIMITIVE lsystem(SCM com)
{
  if (NSTRINGP(com)) err("system: not a string", com);
  return makeinteger(system(CHARS(com)));
}
    
PRIMITIVE lgetenv(SCM str)
{
  char *tmp;
  if (NSTRINGP(str)) err("getenv: not a string", str);
  tmp = getenv(CHARS(str));
  return tmp ? makestrg(strlen(tmp), tmp) : ntruth;
}
