/*
 * r e a d  . c				-- reading stuff
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *           Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: ??-Oct-1993 ??:?? 
 * Last file update:  6-May-1994 17:04
 *
 */

#include "stk.h"

static SCM lreadr(FILE *f, int case_significant);

static int flush_ws(FILE *f, char *message)
{
  int c, commentp=0;

  for ( ; ; ) {
    c = Getc(f);
    if (c == EOF)
      if (message) err(message,NIL); else return(c);
    if (commentp) {
      if (c == '\n') commentp = 0;
    }
    else if (c == ';') commentp = 1;
    else if (!isspace(c)) return(c);
  }
}

static SCM lreadlist(FILE *f, char delim, int case_significant)
/* Read a list ended by the `delim' char */
{
  int c;
  SCM tmp;
  
  c = flush_ws(f, "end of file inside list");
  if (c == delim) return(NIL);

  /* Read the car */
  Ungetc(c, f);
  tmp = lreadr(f, case_significant);
  
  /* Read the cdr */
  if (EQ(tmp, sym_dot)) {
    tmp = lreadr(f, case_significant);
    c = flush_ws(f, "end of file inside list");
    if (c != delim) err("missing close paren", NIL);
    return(tmp);
  }
  return(cons(tmp, lreadlist(f, delim, case_significant)));
}

static void lreadword(FILE *f, int c, int case_significant) 
/* read an item whose 1st char is in c */
{ 
  register int j = 0;
  int allchars   = 0;

  for( ; ; ) {
    allchars  ^= (c == '|');
    if (c != '|') 
      tkbuffer[j++]  = (allchars || case_significant) ? c : tolower(c);

    c = Getc(f);
    if (c == EOF) break;
    if (!allchars) {
      if (isspace(c)) break;
      if (strchr("()[]'`,;\"", c)) {
	Ungetc(c, f);
	break;
      }
    }
    if (j >= TKBUFFERN-1) err("read: token too large", NIL);
  }

  tkbuffer[j] = '\0';
}

static void lreadchar(FILE *f, int c)
/* read an char (or a char name) item whose 1st char is in c */
{ 
  register int j = 0;

  for( ; ; ) {
    tkbuffer[j++] = c;
    c = Getc(f);
    if (c == EOF || isspace(c)) break;
    if (strchr("()[]'`,;\"", c)) {
      Ungetc(c, f);
      break;
    }
    if (j >= TKBUFFERN-1) err("read: token too large", NIL);
  }
  tkbuffer[j] = '\0';
}
  
static SCM lreadtoken(FILE *f, int c, int case_significant) 
{
  SCM z;

  lreadword(f, c, case_significant);
  z = Cstr2number(tkbuffer, 10L);

  if (z == ntruth)
    /* It is not a number */
    return (*tkbuffer == ':') ? makekey(tkbuffer): intern(tkbuffer);

  /* Return the number read */
  return z;
}

static SCM lreadstring(FILE *f)
{
  int j,c,n,len;
  char *p, *buffer;
  SCM z;

  j = 0;
  len = 100;
  p = buffer = must_malloc(len);

  while(((c = Getc(f)) != '"') && (c != EOF)) { 
    if (c == '\\') {
      c = Getc(f);
      if (c == EOF) err("eof after \\", NIL);
      switch(c) {
        case 'b' : c = '\b'; break;	/* Bs  */
	case 'e' : c = 0x1b; break;	/* Esc */
	case 'n' : c = '\n'; break;	/* Lf  */
	case 't' : c = '\t'; break;	/* Tab */
	case 'r' : c = '\r'; break;	/* Cr  */
        case '\n': continue;
	case '0' : n = 0;
		   for( ; ; ) {
		     c = Getc(f);
		     if (c == EOF) err("eof after \\0", NIL);
	             if (isdigit(c) && (c < '8'))
		        n = n * 8 + c - '0';
		     else {
		       Ungetc(c, f);
		       break;
		     }
		   }
	           c = n & 0xff;
      }
    }
    if ((j + 1) >= len) {
      len = len + len / 2;
      buffer = must_realloc(buffer, len);
      p = buffer + j;
    }
    j++;
    *p++ = c;
  }
  *p = '\0';
  
  z = makestrg(j, buffer);
  free(buffer);

  return z;
}

static SCM lreadr(FILE *f, int case_significant)
{
  char *p;
  int c;

  for ( ; ; ) {
    c = flush_ws(f, "end of file inside read");
    
    switch (c) {
      case '(':
        return(lreadlist(f, ')', case_significant));
      case '[':
	return(lreadlist(f, ']', case_significant));
      case ')':
      case ']':
	fprintf(stderr, "\nunexpected close parenthesis\n");
	break;
      case '\'':
	return(cons(sym_quote,cons(lreadr(f, case_significant), NIL)));
      case '`':
	return(cons(intern("quasiquote"), cons(lreadr(f, case_significant), NIL)));
      case '#':
	switch(c=Getc(f)) {
	  case 't':
          case 'T':  return truth;
	  case 'f':
	  case 'F':  return ntruth;
 	  case '\\': lreadchar(f, Getc(f));
	             return makechar(string2char(tkbuffer));
	  case '(' : return lvector(lreadlist(f, ')', case_significant));
	  case '!' : while ((c=Getc(f)) != '\n')
	               if (c == EOF) err("eof encountered in a #! notation", NIL);
	             continue;
	  case 'p':
	  case 'P': lreadword(f, Getc(f), TRUE);
	    	    return address2object(tkbuffer);
	  default:  Ungetc(c, f); return lreadtoken(f, '#', FALSE);
	}
      case ',':
	c = Getc(f);
	if (c == '@') 
	  p = "unquote-splicing";
	else {
	  p = "unquote"; Ungetc(c, f);
	}
	return(cons(intern(p), cons(lreadr(f, case_significant), NIL)));
      case '"':
	return lreadstring(f);
      default:
	return lreadtoken(f, c, case_significant);
    }
  }
}

SCM lreadf(FILE *f, int case_significant)
{
  int c;
  
  c = flush_ws(f, (char *) NULL);
  if (c == EOF) return(eof_object);
  Ungetc(c, f);
  return lreadr(f, case_significant);
}
