/*
 *
 * v e c t o r . c 			-- vectors management
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *           Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: ???
 * Last file update: 19-Dec-1993 17:07
 */

#include <memory.h>
#include "stk.h"


SCM makevect(int len, SCM init)
{
  long j;
  long flag;
  SCM  z;

  flag = no_interrupt(1);
  NEWCELL(z, tc_vector);
 
  z->storage_as.vector.dim  = len;
  z->storage_as.vector.data = (SCM *) must_malloc(len * sizeof(SCM));

  if (init)
    for(j=0 ;j<len; j++) z->storage_as.vector.data[j] = init;

  no_interrupt(flag);
  return z;
}


/**** Section 6.8  ****/

PRIMITIVE vectorp(SCM obj)
{
  return VECTORP(obj) ? truth: ntruth;
}

PRIMITIVE make_vector(SCM len, SCM init)
{
  long k;

  if ((k=integer_value(len))<0) err("make-vector: bad vector length", len);
  return makevect(k, init);
}

PRIMITIVE lvector(SCM l)
{
  int j, len = llength(l);
  SCM z, tmp;
  
  if (len >= 0) {
    z = makevect(len, NULL);
    
    for (j = 0; j < len; j++, l=CDR(l)) {
      VECT(z)[j] = CAR(l);
    }
    return z;
  }
  err("vector: Malformed parameter list", l);
}

PRIMITIVE vector_length(SCM v)
{
  if NTYPEP(v, tc_vector) err("vector-length: not a vector", v);
  return makeinteger((long) v->storage_as.vector.dim);
}

PRIMITIVE vector_ref(SCM v, SCM index)
{
  long k;

  if (NVECTORP(v))      	    err("vector-ref: not a vector", v);
  if ((k=integer_value(index)) < 0) err("vector-ref: bad index", index);
  if (k >= v->storage_as.vector.dim) 
    err("vector-ref: index out of bounds", index);
  return VECT(v)[k];
}

PRIMITIVE vector_set(SCM v, SCM index, SCM value)
{
  long k;
  
  if (NVECTORP(v))      	    err("vector-set!: not a vector", v);
  if ((k=integer_value(index)) < 0) err("vector-set!: bad index", index);
  if (k >= v->storage_as.vector.dim) 
    err("vector-set!: index out of bounds", index);
  
  VECT(v)[k] = value;
  return UNDEFINED;
}

PRIMITIVE vector2list(SCM v)
{
  int j, len;
  SCM z, tmp;

  if (NVECTORP(v)) err("vector->list: not a vector", v);
    
  len = v->storage_as.vector.dim;
  z   = NIL;

  for (j=0; j<len; j++) {
    if (j == 0)
      tmp = z = cons(VECT(v)[j], NIL);
    else 
      tmp = CDR(tmp) = cons(VECT(v)[j], NIL);
  }
  return z;
}

PRIMITIVE list2vector(SCM l)
{
  if (NCONSP(l) && NNULLP(l)) err("list->vector: not a list", l);
  return lvector(l);
}


PRIMITIVE vector_fill(SCM v, SCM fill)
{
  int j, len;

  if (NVECTORP(v)) err("vector-fill!: not a vector", v);
  
  for (j=0, len= v->storage_as.vector.dim; j < len; j++) 
    VECT(v)[j] = fill;
 
  return UNDEFINED;
}

/*
 * 
 * STk bonus
 *
 */

PRIMITIVE vector_copy(SCM vect)
{
  SCM z;
  int n;

  if (NVECTORP(vect)) err("vector-copy: bad vector", vect);
  n = vect->storage_as.vector.dim;
  z = makevect(n, NULL);
  memcpy(VECT(z), VECT(vect), n * sizeof(struct obj*));
  return z;
}

PRIMITIVE vector_resize(SCM vect, SCM size)
{
  long old_size, new_size;

  if (NVECTORP(vect))  			 err("vector-resize: bad vector", vect);
  if ((new_size=integer_value(size)) <0) err("vector-resize: bad new size", size);
  
  old_size 		       = vect->storage_as.vector.dim;
  vect->storage_as.vector.dim  = new_size;
  vect->storage_as.vector.data = must_realloc(vect->storage_as.vector.data, 
					      new_size*sizeof(SCM));

  if (old_size < new_size) { /* Fill in new cells with an unbound value */
    long i;
    
    for (i = old_size; i < new_size; i++) 
      VECT(vect)[i] = UNBOUND;
  }
  return vect;
}


PRIMITIVE lsort(SCM obj, SCM test)
{
  SCM *v;
  int list = 0;
  register int i, j, incr, n;

  if (CONSP(obj) || NULLP(obj)) { list = 1; obj = list2vector(obj); }
  if (NVECTORP(obj)) err("sort: bad object to sort", obj);
  
  obj = vector_copy(obj);
 
  /* 
   * Use a shell sort. It has good performance on small arrays
   * This sort should have better performances than a cleverer one 
   * for the sorts we'll have to do in STklos (which are always small
   * arrays).
   */

  v    = VECT(obj);
  n    = obj->storage_as.vector.dim;
  incr = n / 2;

  while (incr) {
    for (i = incr; i < n; i++) {
      j = i - incr;
      while (j >= 0) {
	if (apply(test, cons(v[j+incr], cons(v[j], NIL))) == truth) {
	  SCM tmp   = v[j+incr];
	  v[j+incr] = v[j];
	  v[j]	    = tmp;
	  
	  j -= incr;
	}
	else 
	  break;
      }
    }
    incr /= 2;
  }
  return list ? vector2list(obj) : obj;
}
