/*
 *
 * s y n t a x . c			-- Syntaxic forms implementation
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *           Author: Erick Gallesio [eg@kaolin.unice.fr]
 *    Creation date: 25-Oct-1993 23:39
 * Last file update: 20-Nov-1993 14:59
 */

/* Notes:
 * ------ 
 * C functions syntax_xxx implement the scheme syntax xxx. A syntax function 
 * returns its work in its first argument (SCM *pform). The function result
 * is a boolean. If true, it indicates to eval that this result is 
 * a final one (eval can return it unmodified). Otherwise, the eval function 
 * take the result stored in *pform and evaluates it again (in the same eval 
 * frame). This mechanaism permits to treat tail recursive calls as jump in
 * the eval function.
 *
 * Syntax function which returns EVALCAR(zzzz) are not tail recursive in debug 
 * mode (in normal mode only the first call is non tail recursive, since this 
 * first call will replace the original code by an equivalent code which is 
 * clean on tail recursive calls.
 */

PRIMITIVE syntax_quote     (SCM *pform, SCM env);
PRIMITIVE syntax_lambda    (SCM *pform, SCM env);
PRIMITIVE syntax_if        (SCM *pform, SCM env);
PRIMITIVE syntax_setq      (SCM *pform, SCM env);
PRIMITIVE syntax_cond      (SCM *pform, SCM env);
PRIMITIVE syntax_and       (SCM *pform, SCM env);
PRIMITIVE syntax_or        (SCM *pform, SCM env);
PRIMITIVE syntax_let	   (SCM *pform, SCM env);
PRIMITIVE syntax_letstar   (SCM *pform, SCM env);
PRIMITIVE syntax_letrec    (SCM *pform, SCM env);

PRIMITIVE syntax_begin     (SCM *pform, SCM env);
PRIMITIVE syntax_delay     (SCM *pform, SCM env);
PRIMITIVE syntax_quasiquote(SCM *pform, SCM env);

PRIMITIVE syntax_define(SCM *pform,SCM env);
