/*
 * s p o r t . c			-- String ports management
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *            Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: 17-Feb-1993 12:27
 * Last file update:  3-Dec-1993 23:19
 *
 *
 * This is achieved in a (surely very) dependant way. A string port is implemented
 * via a pseudo FILE descriptor malloc'd when open-input-string is called. This 
 * descriptor is released when free-string-port is called.
 */

#include "stk.h"

SCM internal_open_input_string(char *str)
{
  struct str_iob *p;
  SCM z;

  NEWCELL(z, tc_isport);
  p = (struct str_iob *) must_malloc(sizeof (struct str_iob));
  
  p->signature = SPORT_SIGNATURE;
  p->flag      = READING;
  p->cnt       = p->bufsiz = strlen(str);
  p->base      = p->ptr    = must_malloc(p->cnt + 1);
  strcpy(p->base, str);

  z->storage_as.port.f    = (FILE *) p;
  z->storage_as.port.name = NULL;
  return z;
}

PRIMITIVE open_input_string(SCM s)
{
  if (NSTRINGP(s)) err("open-input-string: not a string", s);
  return internal_open_input_string(CHARS(s));
}


PRIMITIVE open_output_string()
{
  struct str_iob *p;
  SCM z;

  NEWCELL(z, tc_osport);
  p = (struct str_iob *) must_malloc(sizeof (struct str_iob));

  p->signature = SPORT_SIGNATURE;
  p->flag      = WRITING;
  p->cnt       = 0;
  p->bufsiz    = START_ALLOC;
  p->base      = p->ptr = (char *) must_malloc(START_ALLOC);

  z->storage_as.port.f    = (FILE *) p;
  z->storage_as.port.name = NULL;
  return z;
}

PRIMITIVE get_output_string(SCM port)
{
  if (NOSPORTP(port)) err("get-output-string: Bad string-port", port);
  return makestrg(((struct str_iob *)port->storage_as.port.f)->cnt, 
		  ((struct str_iob *)port->storage_as.port.f)->base);
}

PRIMITIVE input_string_portp(SCM port)
{
  return (ISPORTP(port)) ? truth: ntruth;
}

PRIMITIVE output_string_portp(SCM port)
{
  return (OSPORTP(port)) ? truth: ntruth;
}

void free_string_port(SCM port)
{
  struct str_iob * p;

  assert(ISPORTP(port) || OSPORTP(port));
  p = (struct str_iob *) port->storage_as.port.f;
  free(p->base);
  free(p);
}

PRIMITIVE with_input_from_string(SCM string, SCM thunk)
{
  jmp_buf env, *prev_env = top_jmp_buf;
  SCM result, prev_iport = curr_iport;
  int k;

  if (NSTRINGP(string)) 
    err("with-input-from-string: bad string", string);
  if (NTYPEP(thunk, tc_subr_0) && NTYPEP(thunk, tc_closure))
    err("with-input-from-string: bad thunk", thunk);

  if ((k = setjmp(env)) == 0) {
    top_jmp_buf = &env;
    curr_iport  = internal_open_input_string(CHARS(string));
    result      = apply(thunk, NIL);
  }
  /* restore normal error jmpbuf  and current input port*/
  curr_iport  = prev_iport;
  top_jmp_buf = prev_env;

  if (k) /*propagate error */ longjmp(*top_jmp_buf, k);
  return result;
}

PRIMITIVE read_from_string(SCM str)
{
  SCM result, port;
  int eof;	/* not used here */

  if (NSTRINGP(str)) err("read-from-string: Bad string", str);

  /* Create a string port to read in the expression */
  port = internal_open_input_string(CHARS(str));
  result = internal_read_from_string(port, &eof, FALSE);

  return result == EVAL_ERROR? UNDEFINED: result;
}

