/*
 *
 * p r o c . c			-- 
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *           Author: Erick Gallesio [eg@kaolin.unice.fr]
 *    Creation date: 15-Nov-1993 22:02
 * Last file update: 20-Nov-1993 12:35
 */

#include "stk.h"

/**** Section 6.9 ****/

PRIMITIVE procedurep(SCM obj)
{
  switch (TYPE(obj)) {
    case tc_subr_0: 	
    case tc_subr_1: 	
    case tc_subr_2:  
    case tc_subr_3:	
    case tc_subr_0_or_1:	
    case tc_subr_1_or_2:
    case tc_lambda:	
    case tc_lsubr:		
    case tc_fsubr:
    case tc_closure:  
    case tc_cont:     return truth;
    default:          return ntruth;
  }
}

PRIMITIVE user_apply(SCM l)
{
  int len = llength(l);

  switch (len) {
    case 0:  err("apply: bad number of arguments", l); break;
    case 1:  return apply(CAR(l), NIL);
    case 2:  return apply(CAR(l), CAR(CDR(l)));
    default: return apply(CAR(l), liststar(CDR(l)));
  }
}

static SCM general_map(SCM l, int map)
{
  register int i, len;
  SCM res = NIL,*tmp = &res;
  SCM fct, args;

  if (NCONSP(l)) goto error;

  fct  = CAR(l);
  args = lvector(CDR(l));
  len  = args->storage_as.vector.dim;

  for ( ; ; ) {
    /* Build parameter list */
    for (l=NIL, i=len-1; i >= 0; i--) {
      if (NULLP(VECT(args)[i])) return res;
      if (NCONSP(VECT(args)[i])) goto error;

      l             = cons(CAR(VECT(args)[i]), l);
      VECT(args)[i] = CDR(VECT(args)[i]);
    }

    /* See if it's a map or a for-each call */
    if (map) {
      *tmp = cons(apply(fct, l), NIL);
      tmp  = &CDR(*tmp);
    }
    else apply(fct, l);
  }
error:
  { 
    char buff[50];
    sprintf(buff, "%s: malformed list", map? "map" : "for-each");
    err(buff, l);
  }
}

PRIMITIVE lmap(SCM l)
{
  return general_map(l, 1);
}

PRIMITIVE lfor_each(SCM l)
{
  return general_map(l, 0);
}

PRIMITIVE procedure_body(SCM proc)
{
  return TYPEP(proc, tc_closure) ? cons(sym_lambda, proc->storage_as.closure.code)
    				 : ntruth;
}

PRIMITIVE procedure_environment(SCM proc)
{
  return TYPEP(proc, tc_closure) ? makeenv(proc->storage_as.closure.env): ntruth;
}

