/*
 *
 * k e y w o r d . c				-- Keywords management
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *           Author: Erick Gallesio [eg@kaolin.unice.fr]
 *    Creation date: 19-Nov-1993 16:12
 * Last file update: 20-Nov-1993 12:23
 */

#include "stk.h"

SCM makekey(char *token)
{
  SCM z;
  NEWCELL(z, tc_keyword);
  KEYVAL(z) = must_malloc(strlen(token)+1);
  *token = '-';  /* because keywords corresponds to Tk options */
  strcpy(KEYVAL(z), token); 
  return z;
}

PRIMITIVE make_keyword(SCM str)
{
  SCM z;
  char *s;

  switch (TYPE(str)) {
    case tc_string: s = CHARS(str); break;
    case tc_symbol: s = PNAME(str); break;
    default:        err("make-keyword: Bad parameter", str);
  }
  NEWCELL(z, tc_keyword);
  KEYVAL(z)= must_malloc(strlen(s)+1);
  *(KEYVAL(z)) = '-';
  strcpy(KEYVAL(z)+1, s);
  return z;
}

PRIMITIVE keywordp(SCM obj)
{
  return KEYWORDP(obj)? truth : ntruth;
}

PRIMITIVE keyword2string(SCM obj)
{
  SCM res;

  if (NKEYWORDP(obj)) err("keyword->string: bad keyword", obj);
  res = makestrg(strlen(KEYVAL(obj)), KEYVAL(obj));
  CHARS(res)[1] = ':';
  return res;
}
