/*
 * d u m p . c				-- Image creation
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *           Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: ??-Jul-1993 ??:??
 * Last file update:  1-Dec-1993 14:10
 */

#include "stk.h"

int dumped_core = 0;

#ifdef sun

#include <a.out.h>
#include <fcntl.h>
#include <stdio.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/time.h>

#define TEXT_START(x)	(N_TXTADDR(x)+(sizeof(x)-N_TXTOFF(x)))
#define TEXT_SIZE(x)	((x).a_text - (sizeof(x)-N_TXTOFF(x)))
#define DATA_START(x)	(N_DATADDR(x))

long dumped_date;

int Create_a_out(char *argv0, char *name)
{
  int fd1, fd2;
  struct exec header,header1;

  /* find the header of current running program */
  if ((fd1 = open(argv0, O_RDONLY)) < 0) {
    fprintf(stderr, "Cannot open myself!!!\n");
    return 0;
  }
  read(fd1, &header, sizeof header);
  header1=header;
  
  /* Now that header is read, create the new a.out file in "name" file */
  if ((fd2=open(name, O_WRONLY|O_CREAT|O_TRUNC, 0755)) < 0) {
    fprintf(stderr, "Cannot open %s a.out file\n");
    close(fd1);
    return 0;
  }

  /* Build a new header */
  header.a_bss = 0;
  header.a_data = (char *) sbrk(0) - (char *) DATA_START(header);
  write(fd2, &header, sizeof header);
  
  /* Copy text segment */
  lseek(fd2, sizeof(header), 0);
  write(fd2, TEXT_START(header), TEXT_SIZE(header));
  
  /* Copy data segment */
  write(fd2, DATA_START(header), header.a_data);
  
  /* copy symbol table and string table */
  {
    char buff[2048];
    int n;

    lseek(fd1, N_SYMOFF(header1), 0);
    while (n=read(fd1, buff, 2048))
      write(fd2, buff, n);
  }

  close(fd1); close(fd2);
  return 1;
}

#endif /* sun */

PRIMITIVE ldump(SCM s)
{
#ifdef sun
  if (NSTRINGP(s)) err("dump: bad file name", s);
#ifdef USE_TK
  if (tk_initialized) err("dump: I cannot dump an image if you have "
			  "not used the `-no-tk' option.\nSorry.", NIL);
#endif
  dumped_core = 1;
  dumped_date = time(NULL);

  Create_a_out(Argv0, CHARS(s));
  return truth;
#else
  err("dump: works only on Sun hardware", NIL);
#endif
}
