
; standard macros and functions
; 
; this file is designed to be loaded into a bare Scheme
; thus all macros and functions must be defined before they are used

; all the other hand S-coded definitions are at the head of top.l and sys.s

(#!set! list (#!lambda x x))
(declare-constant 'list)

(add-to-syntax-table '(define-constant)
  (lambda (l)
    `(begin
       (#!set! ,(cadr l) ,(caddr l))
       (declare-constant ',(cadr l)))))

(define-constant any (lisp-eval 'any))
(define-constant true t)
(define-constant else t)
(define-constant false nil)
(define-constant eof (lisp-eval '(eof)))
(define-constant nat-log-base (exp 1))
(define-constant pi (* 2 (arcsin 1)))
(define-constant >>> 'a_prompt)
(define-constant thaw (#!lambda (th) (th)))

(define-constant mkmackeywords
  '(... *pattern* with withrec by-cases on-num-terms on-own-cases
     *generated-symbol* weave syntax declare-syntax declare-syntax/code
     extend-syntax syntactic-transform-function mkmac))

(define-constant mapcar
  (#!lambda (f l)
    (((#!lambda (mapcar)
	(#!set! mapcar
	  (#!lambda (l)
	    (#!if l (cons (f (car l)) (mapcar (cdr l)))))))
      any)
     l)))

(define-constant mapc
  (#!lambda (f l)
    (((#!lambda (mapc)
	(#!set! mapc
	  (#!lambda (l)
	    (#!if l (begin (f (car l)) (mapc (cdr l)))))))
      any)
     l)))

(define-constant writeln 
  ((#!lambda (writeln) (#!lambda x (writeln x)))
   ((#!lambda (writeln)
      (#!set! writeln
	(#!lambda (x)
	  (#!if x
	    (begin (print (car x)) (writeln (cdr x)))
	    (newline)))))
    any)))



(add-to-syntax-table '(case else)
  (#!lambda (*00000)
    ((#!lambda (*00000)
       (let ([tag (car *00000)] [pairs (cdr *00000)])
	 (list
	   (list '#!lambda '(*00000)
	     (iterate loop ([p pairs])
	       (#!if p
		 (#!if (and (null? (cdr p)) (eq? (caar p) 'else))
		       (cons 'begin (append (cdar p) nil))
		       (list '#!if
			 (list
			   (#!if (atom? (caar p)) 'eqv? 'memv)
			   '*00000
			   (list 'quote (caar p)))
			 (cons 'begin (append (cdar p) 'nil))
			 (loop (cdr p))))
		 (cons 'begin
		   (cons
		     '(print '|[case |)
		     (cons
		       (list 'print (list 'quote tag))
		       (cons
			 (cons '#!if (cons (list 'quote pairs) '((newline))))
			 (cons
			   (list 'mapc '(#!lambda (x) (writeln '|   | x))
			     (list 'quote pairs))
			   '((writeln '|]|)
			     (writeln
			       '|[case: unmatched tag: | *00000 '|]|))))))))))
	 tag)))
    (cdr *00000))))

; transcript, compile-file, and edit go in patches.s
; they are usually autoloaded, so their initial definition involves
;     a file pointer.  This file contains no file pointers.

(define call/cc
  (lambda (f)
     (call/ccc
	(lambda (k)
	   (f (lambda (v) (throw k v)))))))

(define-constant call-with-current-continuation call/cc)
(define-constant I (#!lambda (x) x))
(define-constant K* (#!lambda x (car x)))
(define Y
   (#!lambda (f)
      (let ([q (#!lambda (x)
		  (f (#!lambda (a) ((x x) a))))])
	 (q q))))

(define make-engine
  (#!lambda (th)
    (#!lambda (ticks sk fk)
      (try (#!lambda (v) (th)) any (+ 6 ticks) sk
	   (#!lambda (k v) (fk (make-engine (#!lambda () (k v)))))))))

(define-constant engine-return
   ((make-engine (lambda ()(call/cc (#!lambda (k) k))))
    1000
    (#!lambda (x y) x)
    (#!lambda (x) x)))

(define-constant save
  (#!lambda (filename objectlist)
    (fluid-let ([output-port (open filename 'write)])
      (pretty objectlist)
      (close output-port)
      t)))

(define-constant make-vector (lambda x (primitive-make-vector x)))
(define-constant vector (lambda x (list->vector x)))

(define-constant error
  (lambda args
    (newline)
    (print "Error: ")
    (mapc (lambda (x) (print x) (print `| |)) args)
    (reset)))

(define-constant unique (lambda () (ref 'unique)))
   
