(eval-when (eval load compile) (setsyntax 35 'vcharacter)) ; #

(declare (special ellipsis cases-tag-list mkmac-gen mknames with-list
	    withrec-list stop-gen mkmac$debug cases-selectors))

(declare (localf mkmac-car-cdr-chain-help mkmac-dottails mkmac-memq-bar
            ormap2 mkmac-dlls mkmac-ad mk-regular-body
	    mk-one-line-macro mkmac-all-quote? mkmac-member*
	    mkmac-scheme-const? mkmac-constants mkmac-atomsin
	    mkmac-top-level-ids mkmac-car-cdr-chain mkmac-idfun? mkmac-ifify
	    mkmac-funbodfun mkmac-mk-set mkmac-pt&mo mkmac-remall
	    mkmac-remquote mkmac-*pattern*-subst mkmac-anymember mkmac-sym-gen
	    mkmac-trim-gen mkmac-dotted-list-locs 
	    mkmac-replace-constants mkmac$find-dls1 mkmac$find-dls
	    get-dls belongs
	    mkmac$letrecify mkmac$getspecs mkmac$mk-atom mkmac$mke
	    mkmac$getspecpairs))

(def if
   (macro (l)
	  (cond ((= (length l) 3) `(cond (,(cadr l) ,(caddr l))))
		((= (length l) 4) `(cond (,(cadr l) ,(caddr l))
					 (t ,(cadddr l)))))))

(def M$W 
   (lexpr (x)
	(prog (I)
	      (setq I 0)	
        loop  (cond
		 [(eq x I) (return nil)])
	      (setq I (add1 I))
	      (princ (arg I))
	      (go loop))
	(terpri)))

(setq ellipsis '...)
(setq mkmac$debug nil)
(setq cases-tag-list
    (list 'by-cases 'on-num-terms 'on-own-cases))

(setq mknames
   '(syntax declare-syntax declare-syntax/code
       syntactic-transform-function extend-syntax
       mkmac))

(def add-mkmac-name
   (lambda (name) (setq mknames (cons name mknames))))

(def remove-mkmac-name
   (lambda (name) (setq mknames (delq name mknames))))

(setq with-list '(with withrec weave))
(setq withrec-list '(withrec))
(setq mkmac-gen nil)
(setq stop-gen nil)

(def circular
   (lambda (x)
      (let ([box (cons x nil)])
	 (rplacd box box)
	 box)))
   
(def mkmac-ad
   (lambda (new old)
      (if (atom (car old))
	  (cons (implode `(c ,new r)) old)
	  (let ([fun (caar old)])
	     (if (or (memq fun '(car cdr caar cadr cdar cddr))
		     (and (eq new 'a) (eq fun 'cdddr)))
		 `(,(implode
		       `(c ,new . ,(cdr (explode fun))))
		    . ,(cdar old))
		 (cons (implode `(c ,new r)) old))))))

(def mkmac-all-quote?
   (lambda (l fba)
      (cond
	 [(null l) t]
	 [(mkmac-scheme-const? (car l)) (mkmac-all-quote? (cdr l) fba)]
	 [(atom (car l)) nil]
	 [(eq (caar l) 'quote)
	  (if (not (mkmac-member* (cadar l) fba))
	      (mkmac-all-quote? (cdr l) fba))]
	 [t nil])))

(def mkmac-atomsin
   (lambda (l)
      (cond [(null l) nil]
	    [(atom l) (list l)]
	    [(atom (car l)) (cons (car l) (mkmac-atomsin  (cdr l)))]
	    [t (append (mkmac-atomsin  (car l))
		  (mkmac-atomsin  (cdr l)))])))

(def mkmac-member*
   (lambda (a l)
      (cond [(equal a l) l]
	    [(null l) nil]
	    [(atom l) (eq a l)]
	    [t (or (mkmac-member* a (car l))
		   (mkmac-member* a (cdr l)))])))

(def mkmac-scheme-const?
   (lambda (x) (or (null x) (eq x t) (numberp x))))

(def mkmac-car-cdr-chain
   (lambda (a l)
      (if (equal a l) '*pattern*
	  (let ([parts (mkmac-memq-bar l nil)])
	     (if (mkmac-member* a (car parts))
		 (mkmac-car-cdr-chain-help a l (cons '*pattern* nil))
		 (mkmac-dottails a (cdr parts) (cons '*pattern* nil)))))))

(def mkmac-car-cdr-chain-help
   (lambda (a l ans)
      (if l
	 (let ([firstchain (car l)])
	    (cond [(equal a firstchain) (mkmac-ad 'a ans)]
		  [(equal a (cdr l)) (mkmac-ad 'd ans)]
		  [(mkmac-member* a firstchain)
		   (let ([parts (mkmac-memq-bar firstchain nil)])
		      (if (mkmac-member* a (car parts))
			  (mkmac-car-cdr-chain-help
			     a 
			     firstchain
			     `(,(mkmac-ad 'a ans)))
			  (mkmac-dottails a (cdr parts)
			     `(,(mkmac-ad 'a ans)))))]
		  [t (mkmac-car-cdr-chain-help a
			(cdr l)
			`(,(mkmac-ad 'd ans)))])))))

(def mkmac-constants
   (lambda (l)
      (cond [(atom l) l]
	    [(atom (car l)) (mkmac-constants (cdr l))]
	    [(eq (caar l) 'quote)
	     (cons (cadar l) (mkmac-constants (cdr l)))]
	    [t (append (mkmac-constants (car l))
		  (mkmac-constants (cdr l)))])))

(def mkmac-dottails
   (lambda (a l ans)
      (if l
	 (if (equal a l)
	     `(memq ',(car l) . ,ans)
	     (let ([elparts (mkmac-memq-bar l nil)])
		(if (mkmac-member* a (car elparts))
		    (mkmac-car-cdr-chain-help a (car elparts)
		       `((memq ',(caar elparts) . ,ans)))
		    (mkmac-dottails a (cdr elparts) ans)))))))

(def mkmac-dlls
   (lambda (l1 l2 ans)
      (if (eq l1 l2)
	  ans 
	  (mkmac-dlls (cdr l1) l2 (mkmac-ad 'd `(,ans))))))

(def mkmac-dotted-list-locs
   (lambda (l1s l2s anss)
      ; l1s is a list of dotted-lists from abrv
      ; l2s is a list of pt&mos from abrv
      ; anss is a list of car-cdr chains for the
      ;  dotted-lists in the abrv
      (mapcar
	 (function
	    (lambda (ls)
	       (mkmac-dlls (car ls) (cadr ls) (caddr ls))))
	 (transpose (list l1s l2s anss)))))

(def mkmac-funbodfun
   (lambda (pt) `(,(car pt))))

(def mkmac-idfun?
   (lambda (b)
      (or (atom b)
	  (and (eq (car b) 'cons)
	       (not (atom (cadr b)))
	       (eq (caadr b) 'car)
	       (not (atom (caddr b)))
	       (eq (car (caddr b)) 'cdr)
	       (equal (cdr (cadr b)) (cdr (caddr b)))))))

(def mkmac-ifify
   (lambda (l)
      (cond
	 [(null l) nil]
	 [(eq (caar l) t) (cadar l)]
	 [t `(#!if ,(caar l) ,(cadar l) ,(mkmac-ifify (cdr l)))])))

(def mkmac-memq-bar  ; split list (e f ... c d) as ((e f ...) c d)
   (lambda (l ans)
      (cond [(null l) (cons ans l)]
	    [(eq (car l) ellipsis)
	     (cons (append ans (cons ellipsis nil)) (cdr l))]
	    [t (mkmac-memq-bar (cdr l)
		  (append ans (cons (car l) nil)))])))

(def mkmac-mk-set
   (lambda (l)
      (cond [(null l) nil]
	    [(memq (car l) (cdr l)) (mkmac-mk-set (cdr l))]
	    [t (cons (car l) (mkmac-mk-set (cdr l)))])))

(def mkmac-partial-process
   (lambda (p abrv)
      (cond [(atom p) (if (mkmac-member* p abrv)
			  (mkmac-car-cdr-chain p abrv)
			  p)]
	    [(null (cdr p)) (list (mkmac-partial-process (car p) abrv))]
	    [(eq (cadr p) ellipsis) (mkmac-car-cdr-chain p abrv)]
	    [(memq ellipsis p) (mkmac-ppe-loop
				  (reverse (coagulate p)) abrv nil)]
	    [t (mapcar (function
			  (lambda (p) (mkmac-partial-process p abrv)))
		  p)])))

(def coagulate
   (lambda (l)
      (cond [(null l) nil]
	    [(null (cdr l)) l]
	    [(eq (cadr l) ellipsis) (cons (list (car l) (cadr l))
					  (coagulate (cddr l)))]
	    [t (cons (car l) (coagulate (cdr l)))])))

(def mkmac-ppe-loop
   (lambda (p abrv accum)
      (cond [(null (cdr p)) `(apply ,(mkmac-partial-process (car p) abrv)
				,accum)]
	    [(atom (car p))
	     (mkmac-ppe-loop (cdr p) abrv
		`(cons ,(mkmac-partial-process (car p) abrv)
			,accum))]
	    [(eq (cadar p) ellipsis)
	     (mkmac-ppe-loop (cdr p) abrv
		`(append ,(mkmac-car-cdr-chain (car p) abrv)
		    ,accum))]
	    [t (mkmac-ppe-loop
		  (cdr p) abrv
		  `(cons ,(mkmac-partial-process (car p) abrv) ,accum))])))

(def mkmac-pt&mo
   (lambda (l)
      (cond [(atom l) nil]
	    [(atom (cdr l)) nil]
	    [(eq (cadr l) ellipsis) l]
	    [t (mkmac-pt&mo (cdr l))])))

(def mkmac-remall
   (lambda (l1 l2)
      (if l1
	 (mkmac-remall (cdr l1) (delq (car l1) l2))
	 l2)))

(def mkmac-remquote
   (lambda (l)
      (if l
	 (cons (if (mkmac-scheme-const? (car l))
		   (car l)
		   (cadr (car l)))
	       (mkmac-remquote (cdr l))))))

(def mkmac-replace-constants
   (lambda (body cl abrv)
      (if cl
	 (mkmac-replace-constants
	    (let
	       ([c (car cl)])
	       (let ([cloc
			(if (atom c)
			    (mkmac-car-cdr-chain c abrv)
			    (if (eq (car c) 'quote)
				(let
				   ([a (mkmac-car-cdr-chain (cadr c) abrv)])
				   (if a `(list 'quote ,a)))
				(mkmac-car-cdr-chain c abrv)))])
		  (if cloc
		     (subst cloc `(quote ,c) body)
		     body)))
	    (cdr cl)
	    abrv)
	 body)))

(def mkmac-sym-gen
   (lambda (mkmac-gen mkmacexp)
      (if mkmac-gen
	 `(letrec
	     ([^mkgen^
		 (#!lambda ()
		    (if ^mkflag^
		       (begin (#!set! ^mkcount^ (add1 ^mkcount^))
			      (nth ^mkcount^ ^mksyms^))
		       (begin (let ([new (gensym '^)])
				 (#!set! ^mksyms^
				    (append ^mksyms^ (cons new nil)))
				 new))))]
	      [^mksyms^ nil]
	      [^mkflag^ nil]
	      [^mkcount^ 0])
	     ,mkmacexp)
	 mkmacexp)))

(def mkmac-top-level-ids
   (lambda (l)
      (cond [(null l) nil]
	    [(atom l) (cons l nil)]
	    [(null (cdr l)) (mkmac-top-level-ids (car l))]
	    [(eq (cadr l) ellipsis) (mkmac-top-level-ids (cddr l))]
	    [(not (atom (car l)))
	     (append (mkmac-top-level-ids (car l))
		(mkmac-top-level-ids (cdr l)))]
	    [t (cons (car l) (mkmac-top-level-ids (cdr l)))])))


(def mkmac-trim-gen
   (lambda (stop-gen mkmacexp)
      (if stop-gen
	 `(let
	     ([trim
		 (#!lambda (l s)
		    (letrec
		       ([ts (#!lambda (l)
			       (#!if (or (null? l) (memq (car l) s))
				   nil
				   (cons (car l)
					 (ts (cdr l)))))])
		       (ts l)))])
	     ,mkmacexp)
	 mkmacexp)))
(def mkmac-*pattern*-subst
   (lambda (newid mapfunbod)
      (subst '*pattern* '*fbpat*
	 (subst newid '*pattern* mapfunbod))))

;(def mkmac-*pattern*-subst
;   (lambda (newid mapfunbod)
;      (cond [(null mapfunbod) nil]
;	    [(not (atom (car mapfunbod)))
;	     (cons (mkmac-*pattern*-subst newid (car mapfunbod))
;		   (mkmac-*pattern*-subst newid (cdr mapfunbod)))]
;	    [(eq (car mapfunbod) 'mapcar)
;	     (subst '*pattern* '*fbpat*
;		(subst newid '*pattern* mapfunbod))]
;	    [(eq (car mapfunbod) '*pattern*)
;	     (cons newid (mkmac-*pattern*-subst newid (cdr mapfunbod)))]
;	    [(eq (car mapfunbod) '*fbpat*)
;	     (cons '*pattern* (mkmac-*pattern*-subst newid (cdr mapfunbod)))]
;	    [t (cons (car mapfunbod)
;		     (mkmac-*pattern*-subst newid (cdr mapfunbod)))])))

(def ormap2
   (lambda (f l1 l2)
      (if l1
	 (or (funcall f (car l1) l2)
	     (ormap2 f (cdr l1) l2)))))

(def andmap2
   (lambda (f l1 l2)
      (if l1
	 (and (funcall f (car l1) l2)
	      (andmap2 f (cdr l1) l2))
	 t)))

[def mkmac$find-dls (lambda (ptype l)
		       (mkmac-mk-set (mkmac$find-dls1 ptype l)))]

[def mkmac$find-dls1
       (lambda (ptype l)
	  (cond [(null ptype) nil]
		[(atom ptype) (let ([ans (get-dls ptype l l)])
				  (if ans (list ans) nil))]
		[(let ([ans (get-dls ptype l l)])
		    (if ans (list ans) nil))]
		[(and (dtpr (cdr ptype))
		      (eq (cadr ptype) ellipsis))
		 (mkmac$find-dls (cddr ptype) l)]
		[t (append (mkmac$find-dls (car ptype) l)
		      (mkmac$find-dls (cdr ptype) l))]))]

[def get-dls
       (lambda (ept p l)
	  (cond [(null p) nil]
		[(atom p) nil]
		[(null (cdr p)) (get-dls ept (car p) (car p))]
		[(and (eq (cadr p) ellipsis) (belongs ept (car p))) l]
		[(eq (cadr p) ellipsis) (get-dls ept (cddr p) (cddr p))]
		[t (or (get-dls ept (car p) (car p))
		       (get-dls ept (cdr p) l))]))]

[def belongs
       (lambda (a l)
	  (cond [(let ([ainl (mkmac-atomsin l)]
		       [aina (mkmac-atomsin a)])
		    (andmap2 'memq aina ainl)) t]
		[t ()]))]

;		[(null l) nil]
;		[(atom l) nil]
;		[(null (cdr l)) (belongs a (car l))]
;		[(eq (cadr l) ellipsis) (belongs a (cddr l))]
;		[t (or (belongs a (car l))
;		       (belongs a (cdr l)))]))]

(def mkmac$mostopsfun
   (lambda (dl)
      (if (cddr dl) (progn (setq stop-gen t) (caddr dl)))))

[def mkmac$letrecify
   (lambda (sprec e)
      (cond [(null sprec) e]
	    [t `(,(if (memq (caar sprec) withrec-list)
		      'letrec 'let)
		  ,(cdar sprec) ,(mkmac$letrecify (cdr sprec) e))]))]

[def mkmac$getspecs
   (lambda (sprec)
      (cond
	 [(null sprec) nil]
	 [t (append
	       (mapcar 'car (cdar sprec))
	       (mkmac$getspecs (cdr sprec)))]))]

[def mkmac$mk-atom
   (lambda (atm abrv specials)
      (cond [(mkmac-scheme-const? atm) atm]
	    [(eq atm '*generated-symbol*)
	     (setq mkmac-gen t)
	     `(^mkgen^)]
	    [(memq atm specials) atm]
	    [(mkmac-member* atm abrv) (mkmac-car-cdr-chain atm abrv)]
	    [t `(quote ,atm)]))]

[def mk-one-line-macro
   (lambda (expans abrv specials nesting funbodabrv)
      (cond
	 [(atom expans) (mkmac$mk-atom expans abrv specials)]
	 [(atom (cdr expans))
	  `(cons ,(mk-one-line-macro (car expans) abrv specials
		     nesting funbodabrv)
		  ,(mkmac$mk-atom (cdr expans) abrv specials))]
	 [(memq ellipsis expans)
	  (mk-ellipsis-body expans abrv specials nesting funbodabrv)]
	 [t (if (mkmac-member* expans abrv)
		(mkmac-car-cdr-chain expans abrv)
		(let
		   ([exd (mk-regular-body expans abrv specials
			    nesting funbodabrv)])
		   (if (mkmac-all-quote? exd funbodabrv)
		       `(quote ,(mkmac-remquote exd))
		       `(list . ,exd))))]))]

[def mk-regular-body
   (lambda (expans abrv specials nesting funbodabrv)
      (if expans
	 (let ([firstex (car expans)])
	    (if (atom firstex)
		`(,(mkmac$mk-atom firstex abrv specials) .
		   ,(mk-regular-body (cdr expans) abrv specials
		       nesting funbodabrv))
		(if (proc? firstex)
		    `(,firstex .
			,(mk-regular-body (cdr expans) abrv specials
			    nesting funbodabrv))
		    `(,(mkmac$mke firstex abrv specials nesting funbodabrv) .
		       ,(mk-regular-body (cdr expans) abrv specials
			   nesting funbodabrv)))))))]

[def mkmac$mke
   (lambda (expans abrv specials nesting funbodabrv)
      (cond
	 [(atom expans) (mkmac$mk-atom expans abrv specials)]
	 [t (if (memq (car expans) mknames)
		(setq nesting nil))
	    (cond
	       [(and nesting (memq (car expans) cases-tag-list))
		(mkmac-ifify (mk-case-macro
				(predicate-type (car expans))
				(cdr expans)
				abrv specials nesting funbodabrv))]
	       [(and nesting (memq (car expans) with-list))
		(let* ([sprec (mkmac$getspecpairs expans abrv specials)]
		       [expnd
			  (mk-expander abrv (cdr sprec)
			     (append (mkmac$getspecs (car sprec))
				specials) nesting funbodabrv)])
		   (mkmac$letrecify (car sprec) expnd))]
	       [t (mk-one-line-macro
		     expans
		     abrv
		     specials
		     nesting
		     funbodabrv)])]))]

[def identity-2 
   (lambda (p dummy) p)]

[def predicate-type
   (lambda (type)
      (cond
	 [(memq type '(by-cases)) 'identity-2]
	 [(memq type '(on-num-terms)) 'mkmac$num-terms-fun]
	 [(memq type '(on-own-cases)) 'mkmac-partial-process]))]
	  
[def mk-case-macro
   (lambda (predicate-function casesexp abrv specials nesting funbodabrv)
      (if casesexp
	 (let ([firstcase (car casesexp)])
	    (let ([firstpred (car firstcase)]
		  [firstexpans (cadr firstcase)])
	       `((,(funcall predicate-function firstpred abrv)
		   ,(mkmac$mke firstexpans abrv specials 
		       nesting funbodabrv))
		 . ,(mk-case-macro
		       predicate-function
		       (cdr casesexp)
		       abrv
		       specials
		       nesting
		       funbodabrv))))))]

[def mk-ellipsis-body
   (lambda (expans abrv specials nesting funbodabrv)
      (if abrv
	 (let ([prototype (let ((temp (mkmac-pt&mo expans)))
			     (if temp (car temp) nil))])
	    (if (equal (car expans) prototype)
		(let*
		   ([dotted-lists (mkmac$find-dls
				     prototype
				     abrv)]
		    [pt&mo-abrvs (mapcar 'mkmac-pt&mo dotted-lists)]
		    [pt&mostops	 (mapcar 'mkmac$mostopsfun pt&mo-abrvs)]
		    [mapfunbod
		       (mk-expander
			  (if pt&mo-abrvs
			     (if (cdr pt&mo-abrvs)
				 (car (transpose
					 (mapcar 'mkmac-funbodfun
					    pt&mo-abrvs)))
				 (caar pt&mo-abrvs)))
			  prototype specials nesting abrv)]
		    [elocs
		       (mkmac-dotted-list-locs
			  dotted-lists
			  pt&mo-abrvs
			  (mapcar
			     'mkmac-car-cdr-chain
			     dotted-lists
			     (circular abrv)))]
		    [newid (gensym '^)]
		    [mapfun
		       (if (mkmac-idfun? mapfunbod)
			   newid
			   (mkmac-replace-constants
			      (mkmac-*pattern*-subst newid mapfunbod)
			      (mkmac-constants mapfunbod)
			      abrv))]
		    [el-part
		       (if (and elocs (car elocs))
			   (if (and (atom mapfun)
				    (not (and stop-gen (car pt&mostops))))
			       (if (cdr elocs)
				   `(transpose (list . ,elocs))
				   (car elocs))
			       (let*
				  ([map-l
				      (if (cdr elocs)
					  `(transpose
					      (list .
						 ,(if (and stop-gen
							 (car pt&mostops))
						      (mapcar
							 (function
							    (lambda (e1 stop)
							       `(trim ,e1 ,stop)))
							 elocs
							 (circular 
							    (list 'quote
							       pt&mostops)))
						      elocs)))
					  (if (and stop-gen
						 (car pt&mostops))
					      `(trim
						  ,(car elocs)
						  ',pt&mostops)
					      (car elocs)))]
				   [mapcar-exp
				      (if (atom mapfun)
					  map-l
					  `(mapcar
					      ,(cond
						  [(and
						      (atom
							 (cadr
							    mapfun))
						      (null
							 (cddr
							    mapfun)))
						   (car mapfun)]
						  [t `(#!lambda
							 (,newid)
							 ,mapfun)])
					      ,map-l))])
				  (if (and mkmac-gen
					 (mkmac-member*
					    '*generated-symbol* prototype))
				      `(begin0
					  ,mapcar-exp
					  (set! ^mkflag^ t)
					  (set! ^mkcount^ 0))
				      mapcar-exp)))
			   (if nesting ; here, (car elocs) is nil
			      (let ([try
				       (subst '*fbpat*
					  '*pattern*
					  (mk-expander funbodabrv
					     expans
					     specials
					     nesting
					     nil))])
				 (if try try
				    (progn
				       (terpri)
				       (M$W "[expansion prototype: " prototype "]")
				       (M$W "[pattern: " abrv "]")
				       (mkmac$error "expansion prototype has no pattern prototype match"))))
			      `',expans))]
		    [debugger (if mkmac$debug
				 (progn
				    (terpri)
				    (M$W "abrv: " abrv)
				    (M$W "expans: " expans)
				    (M$W "funbodabrv: " funbodabrv)
				    (M$W "prototype: " prototype)
				    (M$W "dotted-lists: " dotted-lists)
				    (M$W "pt&mo-abrvs: " pt&mo-abrvs)
				    (M$W "pt&mostops: " pt&mostops)
				    (M$W "mapfunbod: " mapfunbod)
				    (M$W "elocs: " elocs)
				    (M$W "mapfun: " mapfun)
				    (M$W "el-part: " el-part)
				    (new-line)))]
		    )
		   (if (cddr expans)
		       `(append ,el-part
			   ,(mkmac$mke (cddr expans) abrv specials
			       nesting funbodabrv))
		       el-part))
		(let ([exd `(cons ,(mkmac$mke (car expans) abrv specials
				      nesting funbodabrv)
				   ,(mk-ellipsis-body
				       (cdr expans)
				       abrv
				       specials
				       nesting
				       funbodabrv))])
		   (if (mkmac-idfun? exd)
		       (cadr (cadr exd))
		       exd))))
	 nil))]

[def mk-expander
   (lambda (abrv expans specials nesting funbodabrv)
      (mkmac$mke expans abrv specials nesting funbodabrv))]

[def weave-weaver
   (lambda (defpair abrv)
      (list (car defpair)
	    (list
	       `(lambda (*pattern*)
		   ,(mk-expander abrv
		       (beta-expand (cadr defpair))
		       specials t nil))
	       '*pattern*)))]

(def with-weaver
   (lambda (defpair abrv)
      (if (null (cddr defpair))
	  (let ([pp-def (mkmac-partial-process (cdr defpair) abrv)])
	     (cons (car defpair) pp-def))
	  (list (car defpair)
		(list 'apply
		   (cadr defpair)
		   (mk-expander abrv
		      (caddr defpair)
		      specials
		      t
		      nil))))))

[def mkmac$getspecpairs
   (lambda (e abrv specials)
      (if (memq (car e) with-list)
	  (let ([gsp (mkmac$getspecpairs (caddr e) abrv
			(append
			   (mapcar (function (lambda (i) (car i)))
			      (cadr e))
			   specials))])
	     (cons (cons (cons (car e)
			       (mapcar
				  (if (eq (car e) 'weave)
				      'weave-weaver
				      'with-weaver)			    
				  (cadr e)
				  (circular abrv)))
			 (car gsp))
		   (cdr gsp)))
	  (cons nil e)))]

(def mkmac$num-terms-fun 
   (lambda (p dummy)
      (cond
	 [(numberp p)
	  (cond
	     [(eq p 0) '(null? (cdr *pattern*))]
	     [(eq p 1) '(null? (cddr *pattern*))]
	     [(eq p 2) '(null? (cdddr *pattern*))]
	     [t `(= (length *pattern*) ,(add1 p))])]
	 [(eq p t) t]
	 [t (print "bad lhs to on-num-terms") (terpri) (reset)]))]

[def main-body
   (lambda (l)
      (let ([l (intern* l)])
	 `(#!lambda (*pattern*)
	     ,(progn
		 (setq stop-gen nil)
		 (setq mkmac-gen nil)
		 (let ([body ; this can side-effect mkmac-gen & stop-gen
			  (if (memq (car (cadddr l)) with-list)
			      (let ([sprec (mkmac$getspecpairs
					      (cadddr l) nil nil)])
				 (mkmac$letrecify (car sprec)
				    (mk-match-exp (cddr (cadddr l))
				       (cons (cadr l) (caddr l))
				       (mkmac$getspecs (car sprec)))))
			      (mk-match-exp (cdddr l)
				 (cons (cadr l) (caddr l)) nil))])
		    (mkmac-trim-gen stop-gen
		       (mkmac-sym-gen mkmac-gen body)))))))]

(def doit
   (lambda (pattern predicates expansion)
      `(,(if predicates
	    `(and (mkmac-match? *pattern* ',keywords ',pattern)
		  (let ([*pattern* (untag-special-form *pattern*)])
		     ,(mkmac-partial-process predicates pattern)))
	    `(mkmac-match? *pattern* ',keywords ',pattern))
	 ,(if (and (dtpr expansion)
		   (memq (car expansion) with-list))
	      (let
		 ([sprec
		     (mkmac$getspecpairs
			expansion
			pattern
			specials)])
		 (mkmac$letrecify (car sprec)
		    (mk-expander pattern
		       (cdr sprec)
		       (append (mkmac$getspecs (car sprec)) specials)
		       t nil)))
	      (mk-expander pattern
		 expansion specials t nil)))))

[def mk-match-exp
   (lambda (patpairs keywords specials)
      (if patpairs
	 (mkmac-ifify
	    (append
	       (mapcar
		  (function
		     (lambda (patpair keywords specials)
			(if (null (cddr patpair))
			    (doit (car patpair) nil (cadr patpair))
			    (doit (car patpair) (cadr patpair) (caddr patpair)))))
		  patpairs
		  (circular keywords)
		  (circular specials))
	       '((t (begin
		       (writeln "[syntactic extension error: ")
		       (writeln "syntactic extension use "
			  (untag-special-form *pattern*))
		       (writeln "does not match any pattern in its definition]"))))))
	 (mkmac$error "You need at least one pairing in a mkmac def")))]

(def mkmac$mkmac-debug
   (lambda (x)
      (setq mkmac$debug x)))

(def mkmac$error
   (lambda (msg)
      (M$W "[mkmac error: " msg "]")
      (reset)))
