; compiling file transducer
; input forms whose car is a member of the global variable compile-forms
;     are written to the output file in compiled form
; all input forms are executed

(define! compile-file
    (lambda (filename1 filename2)
	(if (or (not (string? filename1))
		(not (string? filename2))
		(equal? filename1 filename2))
	    (quit (begin
		    (print "compile-file arguments must be distinct strings")
		    (newline)))		
	    (fluid-let ((input-port (open filename1 'read))
		        (output-port (open filename2 'write)))
		 (letrec
		    ([loop
		       (lambda (form)
			 (if (eq? form eof)
			     (begin (close input-port)
				    (close output-port)
				    t)
			     (begin
				 (if (memq (car form) compile-forms)
				     (compile-to-file form)
				     (execute (compile form)))
				 (loop (read)))))]
		     [compile-to-file
			 (lambda (form)
			     (let ([cform (compile
					      (if (memq (car form)
							 '(define! define))
						  (cons 'set! (cdr form))
						  form))])
				 (begin (display&
					    (list 'execute
						  (list 'quote cform)))
				        (newline)
				        (execute cform))))])
		(loop (read)))))))

