(eval-when (compile load) (setsyntax 35 'vcharacter))

(declare
  (special ??? **location** **fnv** core-names table-*at table-*gs
    application-declared-semantics scheme-id-declared-semantics **comp-env**
    table-*gr host-macs =temp=))

(setq **comp-env** nil)

(def tag-vars-length
  (lambda (l)
    (let ([x (imrdc l)])
      (cond [=temp= (list '*rla (cons =temp= x) (length x))]
	    [t (list '*la l (length l))]))))

(def imrdc
  (lambda (l)
    (cond ((atom l) (setq =temp= l) nil)
	  (t (cons (car l) (imrdc (cdr l)))))))

(def purcopy*
  (lambda (s)
    (cond ((atom s)  s)
	  ((purep s) s)
	  (t (cons (purcopy* (car s)) (purcopy* (cdr s)))))))

(def flatten-comp-env (lambda (ce) (apply (function append) ce)))
	   
(def cdr-assq
  (lambda (a l)
    (cond ((null l) nil)
	  ((eq (cdar l) a) (car l))
	  (t (cdr-assq a (cdr l))))))

(setq table-*at (purcopy* `((*at . 1))))
(setq table-*gs (purcopy* `((*gs . ,(guaranteedlookup scheme-directory)))))
(setq table-*gr (purcopy* `((*gr . ,(guaranteedlookup scheme-directory)))))

(declare (special columns))

(def make-table
  (lambda (rows columns)
    (cons
      (cons rows columns)
      (reverse
	(mapnum (function (lambda (row) (make-col row columns))) rows)))))

(declare (special row))

(def make-col
  (lambda (row columns)
    (reverse
      (mapnum (function (lambda (col) (make-entry row col))) columns))))

(def make-entry
  (lambda (i j)
    (let ((box (cons i j))) (cons (cons '*lr box) (cons '*ls box)))))

(def mapnum
  (lambda (f i)
    (cond ((minusp i) nil)
	  (t (cons (apply f (list i)) (mapnum f (sub1 i)))))))

(declare (special lexical-table))

(setq lexical-table (purcopy* (make-table 4 4)))

(def local-ref-table-lookup
  (lambda (opcode args)
    (let ((rows (caar lexical-table))
	  (columns (cdar lexical-table))
	  (array (cdr lexical-table))
	  (m (car args))
	  (n (cdr args)))
      (cond ((and (or (lessp m rows) (= m rows))
		  (or (lessp n columns) (= n columns)))
	     (cond ((eq opcode '*lr)
		    (car (nthelem (1+ n) (nthelem (1+ m) array))))
		   ((eq opcode '*ls)
		    (cdr (nthelem (1+ n) (nthelem (1+ m) array))))))
	    (t (cons opcode args))))))

(def table-lookup
  (lambda (table opcode args)
    (let ((pair (cdr-assq args table)))
      (cond ((null pair)
	     (let ((newpair (cons opcode args)))
	       (nconc table (list newpair))
	       newpair))
	    (t pair)))))

(def access-system-function
  (macro (l)
    `(let ([p (getl ,(cadr l) '(constant-system-function system-function))])
       (cond [p (cadr p)] [t nil]))))

(def access-scheme-primitive
  (macro (l)
    `(let ([p (getl ,(cadr l) '(constant-primitive scheme-primitive))])
       (cond [p (cadr p)] [t nil]))))

(def one (macro (l) `(car ,(cadr l))))
(def two (macro (l) `(cadr ,(cadr l))))
(def three (macro (l) `(caddr ,(cadr l))))
(def four (macro (l) `(cadddr ,(cadr l))))
(def la-body (macro (l) `(cdddr ,(cadr l))))
(def extend (macro (l) (list 'cons (three l) (two l))))
(def &arity (macro (l) `(car ,(cadr l))))
(def &class (macro (l) `(caddr ,(cadr l))))
(def &name (macro (l) `(cdddr ,(cadr l))))

;;; Expression type predicates.  One fore each type of expression

(def quoted? 
  (macro (l)
    `(let ((temp ,(cadr l))) (and (dtpr temp) (eq (car temp) 'quote)))))

(def constant?
  (lambda (x)
    (or (and (atom x) (or (null x) (eq x t) (numberp x) (stringp x)))
	(proc? x)
	(quoted? x))))

(def identifier? (macro (l) `(atom ,(cadr l))))
(def lambda? (macro (l) (list 'eq (cons 'car (cdr l)) ''#!lambda)))
(def if? (macro (l) (list 'eq (cons 'car (cdr l)) ''#!if)))
(def set? (macro (l) (list 'eq (cons 'car (cdr l)) ''#!set!)))
(def scheme-id? (macro (l) (list 'eq (cons 'car (cdr l)) ''#!scheme-id)))
(def app? (macro (l) (list 'eq (cons 'car (cdr l)) ''#!application)))
(def fluid-bind? (macro (l) (list 'eq (cons 'car (cdr l)) ''#!fluid-bind)))

(def host-mac-exp?
  (macro (l)
    `(and (atom (car ,(cadr l))) (memq  (car ,(cadr l)) host-macs))))

(def beta-transform?
  (macro (l)
    `(let ((exp ,(cadr l)))
       (cond [(atom exp) nil]
	     [(atom (car exp)) (get (car exp) 'beta-transform)]
	     [t (eq (car (car exp)) '&transform)]))))
		
(def application? (macro (l) 't))

;;; code sequence construction

(def inst
  (macro (l)
    (let ((num-args (length l)))
      (cond ((= num-args 1) (warn "not enough args to inst" l))
	    ((= num-args 2) `(mk-inst ,(cadr l) nil))
	    ((= num-args 3) `(mk-inst . ,(cdr l)))
	    (t (warn "too many args to inst " l))))))

(def mk-inst
  (lambda (opcode args)
    (cond ((eq opcode '*at)
	   (cond ((zerop args) '(*ti . 0))
		 (t (table-lookup table-*at opcode args))))
	  ((eq opcode '*lr) (local-ref-table-lookup opcode args))
	  ((eq opcode '*ls) (local-ref-table-lookup opcode args))
	  ((eq opcode '*gr) (table-lookup table-*gr opcode args))
	  ((eq opcode '*gs) (table-lookup table-*gs opcode args))
	  ((eq opcode '*pu) '(*pu))
	  ((eq opcode '*re) '(*re))
	  (t (cons opcode args)))))

(def emit (lambda (inst code) `(,inst . ,code)))

;;; environment access

(def lookup (lambda (i env) (try-rib-m i env 0)))

(def try-rib-m
  (lambda (i e m)
    (cond [(null e) nil]
	  [(setq =temp=
	     (cond ((not (atom (one e))) (try-n i (one e) 0))
		   ((eq i (one e)) 0)
		   (t nil)))
	   (cons m =temp=)]
	  [t (try-rib-m i (cdr e) (add1 m))])))

(def try-n
  (lambda (i r n)
    (cond ((null r) nil)
	  ((eq i (one r)) n)
	  (t (try-n i (cdr r) (add1 n))))))

(def emit-fake-lambda
  (lambda (p primitive)
    (let ((numargs (car p)))
      ;;; this 'car' is a KLUDGE, because I am too lazy to restructure
      ;;; e-identifier.   --brooks
      (car
	(cond
	  ((= numargs 0)
	   (e-exp `(#!lambda () (#!application (,primitive))) nil nil))
	  ((= numargs 1)
	   (e-exp `(#!lambda (x) (#!application (,primitive (#!scheme-id x))))
	     nil nil))
	  ((= numargs 2)
	   (e-exp
	     `(#!lambda (x y)
		(#!application (,primitive (#!scheme-id x) (#!scheme-id y))))
	     nil nil))
	  ((= numargs 3)
	   (e-exp
	     `(#!lambda (x y z)
		(#!application
		  (,primitive
		    (#!scheme-id x)
		    (#!scheme-id y)
		    (#!scheme-id z))))
	     nil nil))
	  (t (raise (list 'SE%comp 0 t 'compile:
		      '|no primitive has this many arguments| numargs))))))))

(def primop
  (lambda (exp env)
    (and (atom exp)
	 (not (numberp exp))
	 (not (lookup exp env))
	 (access-scheme-primitive exp))))

;;; compilation routines

(def compile (lambda (exp) (e-exp exp nil (emit (inst '*re nil) nil))))

;;; argument compiler

(def a-args
  (lambda (a r c)
    (cond ((null a) c)
	  (t (a-args (cdr a) r (t-exp (car a) r (emit (inst '*pu) c)))))))

(def macro-expand
  (lambda (exp env)
    ;;; compile is a primitive so vsm regs they must be bound
    ;;; before macro expansion so that they are not "overwritten"
    ;;; upon completion of macro expansion.	This is especially 
    ;;; true of **fnv**.  If it is not rebound, macro expansion 
    ;;; termination will leave nil in **fnv**.  This will cause 
    ;;; an error on the next fluid lookup, which will in turn 
    ;;; reset **fnv** to something reasonable. 
    ;;; -- gsb 12/27/83
    (setq fal nil)
    (let
      ((ans
	 (newnames
	   (lexpand2
	     (copy-no-constant-no-quote
	       (let ((**fnv** **fnv**))
		 (vsm
		   '((*pr &ms . apply) (*re))
		   '((((*pr &ms . result))) nil)
		   nil
		   (list (list (tag-frees (copy-no-constant exp) nil)))
		   (cond [(atom (car exp))
			  (caddr (get (car exp) 'beta-transform))]
			 [t (caddar exp)])))))
	   nil)))
      (setq fal nil)
      ans)))

;;; expression compiler for tail-recursive expressions

(def e-exp 
   (lambda (exp env code)
      (cond ((constant? exp) (standard-e-constant exp env code))
	    ((identifier? exp) (effected-e-identifier exp env code))
	    ((scheme-id? exp) (standard-e-identifier (cadr exp) env code))
	    ((beta-transform? exp) (e-macro exp env code))
	    ((host-mac-exp? exp) (e-exp (host-mac-dispatch exp) env code))
	    ((lambda? exp) (e-lambda exp env code))
	    ((if? exp) (e-if exp env code))
	    ((set? exp) (e-set exp env code))
	    ((app? exp) (standard-e-application (cadr exp) env code))
	    ((fluid-bind? exp) (e-fluid-bind exp env code))
	    ((application? exp) (effected-e-application exp env code))
	    (t ???))))

(def standard-e-constant        ;;; constants are always tidy
  (lambda (exp env code)
    (emit
      (cond ((or (atom exp) (proc? exp)) (inst '*co exp))
	    ((quoted? exp) (inst '*co (two exp)))
	    (t (raise (list 'SE%comp 0 t 'compile: '|Bad constant| exp))))
      code)))

(def run-semantics
  (lambda (exp env semantic-fn)
    (setq **comp-env** (cons (flatten-comp-env env) **comp-env**))
    (let ([**fnv** **fnv**])
      (let ([ans (vsm '((*pr &ms . apply) (*re))
		       '((((*pr &ms . result))) nil)
		       nil
		       (list (list exp))
		       semantic-fn)])
	(setq **comp-env** (cdr **comp-env**))
	ans))))

; primitives and system functions as global references need special handling
; they cannot be rebound at the top level

(def effected-e-identifier
  (lambda (exp env code)
    (cond
      [scheme-id-declared-semantics
	(e-exp (run-semantics exp env scheme-id-declared-semantics) env code)]
      [t (standard-e-identifier exp env code)])))

(def standard-e-identifier
  (lambda (exp env code)
    (let ((m-n (lookup exp env))) ;lookup returns dotted-pair
      (emit
	(cond
	  [m-n (inst '*lr m-n)]
	  [t (let ([pair (getl exp
			   '(constant-primitive scheme-constant
			      constant-system-function system-function))])
	       (cond [pair (cond
			     [(eq (cadr pair) 'unassigned-constant)
			      (inst '*co `(&unassigned-constant . ,exp))]
			     [(eq (car pair) 'constant-primitive)
			      (emit-fake-lambda (cadr pair) exp)]
			     [(eq (car pair) 'scheme-primitive)
			      (emit-fake-lambda (cadr pair) exp)]
			     [(eq (car pair) 'system-function)
			      (inst '*co `(&sys . ,(cadr pair)))]
			     [(eq (car pair) 'constant-system-function)
			      (inst '*co `(&sys . ,(cadr pair)))]
			     [t (inst '*co (cadr pair))])]
		     [t (inst '*gr (guaranteedlookup exp))]))])
	code))))
	
(def e-lambda
  (lambda (exp env code)
    (let ((tag$vars$length (tag-vars-length (two exp))) (body (cddr exp)))
      (let ((vars (cadr tag$vars$length)))
	(emit
	  (inst (car tag$vars$length)
		`(,(caddr tag$vars$length) ,vars
		   ,@(e-stmnts
		       body
		       (cond [(null vars) env]
			     [t (extend env vars)])
		       (emit (inst '*re) nil))))
	  code)))))
	      
(def e-if
  (lambda (e r c)
    (cond
      [(not (or (= (length e) 3) (= (length e) 4)))
       (raise
	 (list 'SE%comp 0 t 'compile: '|wrong number of forms to if:| e))])
    (t-exp
      (two e) r
      (emit
	(inst '*if `(,(e-exp (three e) r c) . ,(e-exp (four e) r c)))
	nil))))

(def e-set
  (lambda (exp env code)
    (cond
      [(not (= (length exp) 3))
       (raise (list 'SE%comp 0 t 'compile:
		'|wrong number of forms to set!:| exp))])
    (t-exp
      (three exp)
      env
      (emit (let ((m-n (lookup (two exp) env)))
	      (cond (m-n (inst '*ls m-n))
		    (t (inst '*gs (guaranteedlookup (two exp))))))
	    code))))

(def e-stmnts
  (lambda (stmnts env code)
    (cond ((null (cdr stmnts))
	   (e-exp (car stmnts) env code))
	  (t (t-exp (car stmnts) env (e-stmnts (cdr stmnts) env code))))))

(def e-fluid-bind
  (lambda (exp env code)
    (let ([id (cadr exp)] [val (caddr exp)] [bodies (cdddr exp)])
      (t-exp val env
	(emit (let ((m-n (lookup id env))) ;lookup returns `(m . n)
		(cond (m-n (inst '*lf m-n))
		      (t (inst '*gf (guaranteedlookup id)))))
	      (e-stmnts bodies env code))))))
 

(def standard-e-application
  (lambda (exp env code)
    (let* ((args (cdr exp))
	   (len-args (length args))
	   (fcn (beta-expand (car exp)))
	   (prim (primop fcn env)))
      (cond
	[(and prim (not (baselocation fcn)))
	 (cond [(not (= (&arity prim) len-args))
		(raise (list 'SE%comp 0 t 'compile:
			 '|Wrong number of args to primitive:| exp))])
	 (p-exp prim args env code)]
	[(lambda? fcn)
	 (let* ([tag$vars$length (tag-vars-length (cadr fcn))]
		[tag (car tag$vars$length)]
		[vars (cadr tag$vars$length)]
		[len (caddr tag$vars$length)])
	   (cond
	     [(or (and (eq tag '*la) (not (= len len-args)))
		  (and (eq tag '*rla) (lessp len-args len)))
	      (raise (list 'SE%comp 0 t 'compile:
		       '|Wrong number of actual parameters:| exp))]
	     [(null vars) (e-stmnts (cddr fcn) env code)]
	     [t (a-args args env
		  (emit
		    (inst (cond [(eq '*la tag) '*le] [t '*rle]) vars)
		    (e-stmnts (cddr fcn) (extend env vars) code)))]))]
	[t (a-args args env
	     (t-exp fcn env (emit (inst '*at len-args) nil)))]))))

(def effected-e-application
  (lambda (e r c)
    (cond
      [application-declared-semantics
	(e-exp (run-semantics e r application-declared-semantics) r c)]
      [t (standard-e-application e r c)])))

(def e-macro
   (lambda (exp env code)
      (e-exp (macro-expand exp env) env code)))

;;; expression compiler for non-tail-recursive  expressions
;;; (ie. expressions which must be made tidy.)

(def t-exp 
   (lambda (exp env code)
      (cond ((constant? exp) (standard-e-constant exp env code))
	    ((identifier? exp) (effected-t-identifier exp env code))
	    ((scheme-id? exp) (standard-e-identifier (cadr exp) env code))
	    ((beta-transform? exp) (t-macro exp env code))
	    ((host-mac-exp? exp) (t-exp (host-mac-dispatch exp) env code))
	    ((lambda? exp) (e-lambda exp env code))
	    ((if? exp) (t-if exp env code))
	    ((set? exp) (e-set exp env code))
	    ((app? exp) (standard-t-application (cadr exp) env code))
	    ((fluid-bind? exp) (t-fluid-bind exp env code))
	    ((application? exp) (effected-t-application exp env code))
	    (t ???))))

(def effected-t-identifier
  (lambda (exp env code)
    (cond
      [scheme-id-declared-semantics
	(t-exp (run-semantics exp env scheme-id-declared-semantics) env code)]
      [t (standard-e-identifier exp env code)])))

(def t-if
  (lambda (exp env code)
    (cond [(not (or (= (length exp) 3) (= (length exp) 4)))
	   (raise (list 'SE%comp 0 t 'compile:
		    '|wrong number of forms to if:| exp))])
    (t-exp
      (two exp)
      env
      (emit
	(inst '*if
	  `(,(t-exp (three exp) env code) . ,(t-exp (four exp) env code)))
	nil))))

(def t-stmnts 
  (lambda (stmnts env code)
    (cond
      ((null (cdr stmnts)) (t-exp (car stmnts) env code))
      (t (t-exp (car stmnts) env (t-stmnts (cdr stmnts) env code))))))

(def t-fluid-bind
  (lambda (exp env code)
    (let ([id (cadr exp)] [val (caddr exp)] [bodies (cdddr exp)])
      (emit (inst '*sa code)
	    (t-exp val env
	      (emit (let ((m-n (lookup id env))) ;lookup returns `(m . n)
		      (cond (m-n (inst '*lf m-n))
			    (t (inst '*gf (guaranteedlookup id)))))
		    (t-stmnts bodies env
		      (emit (inst '*re) nil))))))))

(def standard-t-application
  (lambda (exp env code)
    (let* ((args (cdr exp))
	   (len-args (length args))
	   (fcn (beta-expand (car exp)))
	   (prim (primop fcn env)))
      (cond
	[(and prim (not (baselocation fcn)))
	 (cond [(not (= (&arity prim) len-args))
		(raise (list 'SE%comp 0 t 'compile:
			  '|Wrong number of args to primitive:| exp))])
	 (p-exp prim args env code)]
	[(lambda? fcn)
	 (let* ([tag$vars$length (tag-vars-length (cadr fcn))]
		[tag (car tag$vars$length)]
		[vars (cadr tag$vars$length)]
		[len (caddr tag$vars$length)])
	   (cond
	     [(or (and (eq tag '*la) (not (= len len-args)))
		  (and (eq tag '*rla) (lessp len-args len)))
	      (raise (list 'SE%comp 0 t 'compile:
		       '|Wrong number of actual parameters:| exp))]
	     [(null vars) (t-stmnts (cddr fcn) env code)]
	     [t (emit
		  (inst '*sa code)
		  (a-args args env
		    (emit
		      (inst (cond [(eq '*la tag) '*le] [t '*rle]) vars)
		      (e-stmnts
			(cddr fcn)
			(extend env vars)
			(emit (inst '*re) nil)))))]))]
	[t (emit
	     (inst '*sa code)
	     (a-args args env
	       (t-exp fcn env
		 (emit (inst '*at len-args) nil))))]))))

(def effected-t-application
  (lambda (exp r code)
    (cond
      [application-declared-semantics
	(t-exp (run-semantics exp r application-declared-semantics) r code)]
      [t (standard-t-application exp r code)])))

(def t-macro
  (lambda (exp env code)
    (t-exp (macro-expand exp env) env code)))

;;; primitive expression compiler

(def p-exp 
  (lambda (prim args env code)
    (a-args (cdr args) env (t-exp (car args) env (emit (cdr prim) code)))))
