
; Scheme translator environment and module

(define scheme-translator-env
  (make-program-env
     'scheme-translator
     (list revised^4-scheme-module)))

(define scheme-translator-sig
  (make-signature
    'scheme-translator
    '(make-program-env
      make-signature
      make-module
      program-env-id
      program-env-package
      program-env-lookup
      program-env-define!
      translate
      translate-lambda
      really-translate-file
      translator-version
      perform-usual-integrations!
      scheme-translator-env
      scheme-translator-module
      revised^4-scheme-module
      scheme-user-environment
      )
    '()))

(define scheme-translator-module
  (make-module 'scheme-translator
	       scheme-translator-sig
	       scheme-translator-env))

(define (move-value-or-denotation name from to)
  (let ((den (program-env-lookup from name)))
    (if (and (node? den)
	     (program-variable? den))
	(let ((from-sym (program-variable-location den)))
	  (lisp:if (lisp:boundp from-sym)
		   (let ((to-sym (program-variable-location
				  (program-env-lookup to name))))
		     (lisp:setf (lisp:symbol-value to-sym)
				(lisp:symbol-value from-sym))
		     (schi:set-function-from-value to-sym))
		   ;; This case handles ELSE and =>.
		   (program-env-define! to name den)))
	(program-env-define! to name den))))


; A pristine user environment with no integrations.

(define scheme-user-environment
  (make-program-env 'scheme '()))

(for-each (lambda (name)
	    (move-value-or-denotation name
				      revised^4-scheme-env
				      scheme-user-environment))
	  (signature-names revised^4-scheme-sig))


; Add integrations ("benchmark mode")

(define (perform-usual-integrations! env)
  (for-each (lambda (name)
	      (let ((probe (get-integration
			     (program-env-lookup revised^4-scheme-env name))))
		(if probe
		    (define-integration! (program-env-lookup env name)
		      probe))))
	    (signature-names revised^4-scheme-sig)))


; These don't really belong anywhere

(define (eval-for-syntax form env)
  (lisp:eval (translate form env)))

(let ((env (get-environment-for-syntax scheme-user-environment)))
  (eval-for-syntax `(define syntax-error #f) env)
  ((eval-for-syntax `(lambda (x) (set! syntax-error x)) env)
   syntax-error))

(define (error . rest)
  (apply #'schi:scheme-error rest))
