; File bootit.scm / -*- Mode: Scheme; Syntax: Scheme; Package: Scheme; -*-
; Copyright (c) 1989 Jonathan Rees / See file COPYING

; Booting new Pseudoscheme

; In any scheme-in-CL implementation, load this file and do
; (bootit).  This compiles and loads the translator, then invokes
; the translator to translate itself.
; Actually, a fair amount of hacking will be needed before this can be
; done in a non-Common-Lisp-based Scheme.

(define *pseudoscheme-directory* #f)

(define (bootit . dir-option)
  (cond ((not (null? dir-option))
	 (set! *pseudoscheme-directory* (lisp:pathname (car dir-option))))
	((not *pseudoscheme-directory*)
	 (set! *pseudoscheme-directory*
	       (lisp:make-pathname :name nil
				   :type nil
				   :defaults *default-pathname-defaults*))))
  (init-hacks)
  (load-untranslated-translator)
  (boot-r^3-package)
  (translate-runtime)
  (translate-translator))

(define (new-package name . args)
  (if (lisp:find-package name)
      (let ((loser (string-append "OLD-" name)))
	(cond ((not (lisp:find-package loser))
	       (lisp:warn "Renaming existing ~A package to be ~A."
			  name
			  loser)
	       (lisp:rename-package name loser)
	       (apply #'lisp:make-package name args))
	      (else
	       (lisp:warn "Using existing ~A package."
			  name)
	       (lisp:find-package name))))
      (apply #'lisp:make-package name args)))

(define hacks-package #f)
(define clever-load #f)
(define lisp-package #f)
(define scheme-package (lisp:symbol-package 'askdjfh))

(define (init-hacks)
  (set! hacks-package
	(new-package "SCHEME-HACKS" :use '("LISP") :nicknames '("SCHH")))
  (lisp:let ((lisp:*package* hacks-package))
    (lisp:load (pseudo-pathname "CLEVER") :verbose #f)	;Get clever file loader
    (set! clever-load (lisp:symbol-function (hack-symbol 'clever-load)))
    (clever-load (pseudo-pathname "HACKS")
		 :compile-if-necessary t)
    (lisp:funcall (hack-symbol 'fix-scheme-package-if-necessary)
		  scheme-package)
    (clever-load (pseudo-pathname "SCHI"))  ;Create SCHI package
    (set! lisp-package (lisp:symbol-value (hack-symbol 'lisp-package)))
    (clever-load (pseudo-pathname "READTABLE")
		 :compile-if-necessary t)))

(define (hack-symbol name)
  (lisp:intern (symbol->string name) hacks-package))

(define (pseudo-pathname name)
  (lisp:make-pathname :name name
		      :defaults *pseudoscheme-directory*))

(define (preferred-case name)
  #+unix (lisp:string-downcase name)
  #-unix name
  )

(define *scheme-file-type*     (preferred-case "SCM"))
(define *translated-file-type* (preferred-case "PSO"))

; ----- Load the translator into a scheme emulation

(define (load-untranslated-translator)
  ;; Make sure we perform integrations!
  (if (lisp:fboundp 'go)
      (go 'usual))
  (clever-load (pseudo-pathname "FILES")
	       #+LispM :package #+LispM scheme-package)
  (for-each load-scheme translator-files)
  'done)

(define (load-scheme file)
  (clever-load (pseudo-pathname file)
	       :source-type *scheme-file-type*
	       :object-type *boot-file-type*
	       :compile-if-necessary t))

; ----- Translating the runtime system

(define revised^3-scheme-package #f)

(define (boot-r^3-package)
  (set! revised^3-scheme-package
	(or (lisp:find-package "REVISED^3-SCHEME")
	    (lisp:make-package "REVISED^3-SCHEME"
			       :use (list lisp-package))))
  (let ((intern-it (lisp:symbol-function
		     (hack-symbol 'intern-renaming-perhaps))))
    (lisp:export (map (lambda (name)
			(intern-it (symbol->string name)
				   revised^3-scheme-package))
		      (signature-vars revised^3-scheme-sig))
		 revised^3-scheme-package)))

(define (translate-runtime)
  ;; In principle, there could be more stuff here.
  (write-closed-definitions revised^3-scheme-package
			    (lisp:make-pathname :type *translated-file-type*
						:defaults (pseudo-pathname "CLOSED"))))

; ----- Translating the translator

(define scheme-translator-package #f)

(define (translate-translator)
  (set! scheme-translator-package
	(or (lisp:find-package "SCHEME-TRANSLATOR")
	    (lisp:make-package "SCHEME-TRANSLATOR")))
  (lisp:use-package (list revised^3-scheme-package
			  lisp-package)
		    scheme-translator-package)
  (for-each translate-translator-file
	    translator-files)
  'done)

(define (translate-translator-file file)
  ;; Make 'FOO read in as (SCHEME::QUOTE FOO)
  (lisp:let ((lisp:*readtable* (lisp:symbol-value (hack-symbol 'scheme-readtable))))
    (really-translate-file (lisp:make-pathname :type *scheme-file-type*
					       :defaults (pseudo-pathname file))
			   (lisp:make-pathname :type *translated-file-type*
					       :defaults (pseudo-pathname file))
			   usual-macrologies
			   usual-integrations
			   scheme-translator-package)))
