/*
GET HERSHEY FONTS
*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	"font.h"

#define	GLYPHNUM	256

int	offset[GLYPHNUM];
char	width[GLYPHNUM];
unsigned data[25000];

unsigned encode( int x, int y, int line )
{
	union	{
		struct
		{
			signed	xoff  : 7;
			unsigned flag1 : 1;
			signed	yoff  : 7;
			unsigned flag2 : 1;
		}	cword;
		unsigned u;
	}	data;
	data.cword.xoff = x;
	data.cword.yoff = y;
	data.cword.flag1 = 1;
	data.cword.flag2 = line;

	return	data.u;
}

int	process( char *line, int glyph, int req, char &capitol, char &descender, int &dp )
{
	int	first, num, strokes, ladj, radj, y;
	char	tmp[1000];

	strcpy( tmp, line ); tmp[5] = ' ';
	strcpy( tmp+6, line+5 ); tmp[9] = 0;

	sscanf( tmp, "%d %d", &num, &strokes );
	if( req != num )
		return	0;	/* done here */
	fprintf( stderr, "Glyph %d\r", num );

	if( offset[glyph] )
	{
		fprintf( stderr, "\t\t\aGlyph %d overwritten (by HERSHEY %d)\r", glyph, num );
		exit( 1 );
	}

	line += 8;		/* skip the counts */
	ladj = *line++ - 'R';
	radj = *line++ - 'R';
	width[glyph] = radj - ladj;
	offset[glyph] = 2*dp;

	first = strokes-1;
	while( --strokes > 0 )
	{
		if( *line == ' ')
		{
			data[dp++] = encode( line[2] - ladj - 'R',
				y = '[' - line[3], 0 );
			line += 4;
			strokes--;
		} else {
			data[dp++] = encode( line[0] - ladj - 'R',
				y = '[' - line[1], strokes!=first );
			line += 2;
		}
		if( y < descender )
			descender = y;
		if( y > capitol )
			capitol = y;
	}
	data[dp++] = encode( radj - ladj, 0, 0 );/* move to new pos */
	data[dp++] = 0;		/* mark end */
	return	1;		/* continue */
}

int	getarequest( int &glyph, int &num )
{
	static	gto = -1, _glyph = 0, _num;
	char	line[200];

	if( _glyph >= gto )
	{
		gto = -1;
		glyph = gto = 0;
		do
			if( gets( line ) != line )
				return	0;
		while( sscanf( line, " %c", &num ) != 1 );

		if( sscanf( line, "%d \\%d-\\%d", &num, &glyph, &gto ) != 3 )
		if( sscanf( line, "%d %c-%c", &num, &glyph, &gto ) != 3 )
		if( sscanf( line, "%d \\%d", &num, &glyph ) != 2 )
		if( sscanf( line, "%d %c", &num, &glyph ) != 2 )
			return	0;
		_glyph = glyph;
		_num = num;
		return	1;
	}
	glyph = ++_glyph;
	num = ++_num;
	return	1;
}

int	main( int argc, char **argv )
{
	FILE	*in, *out;
	char	line[1000], outname[10];
	int	glyph, stroke, i, num;
	HEADER	h;
	struct {
		char	text[60];
		FHEADER	h;
	}	f;

	if( argc < 2 )
		return	1;

	if( (in = fopen("HERSHEY.DAT", "rt")) == NULL )
		return	1;

	h.sig = SIGNATURE;
	h.mystery = 0;
	h.scan_flag = 0;
	h.org_to_base = 0;
	h.unused = 0;		/* still unset: nchrs, first, cdefs, org2cap, org2dec */

	strcpy( f.text, "PK\b\bHERSHEY fonts, (C) 1993 by Larry Bartholdi & his gang\r\n\032");
	f.h.header_size = Prefix_Size;
	f.h.font_major = 1, f.h.font_minor = 0;
	f.h.min_major = 1, f.h.min_minor = 0;

	for( i = 0; argv[1][i]; i++ )
		argv[1][i] = toupper( argv[1][i] );
	strncpy( f.h.font_name, argv[1], 4 );
	strncpy( h.fntname, argv[1], 4 );
				/* still unset: size */
	sprintf( outname, "%s.CHR", argv[1] );
	out = fopen( outname, "wb");
	for( i = 0; i < GLYPHNUM; i++ )
		width[i] = offset[i] = 0;
	i = 0;
	data[i++] = 0;
	h.org_to_cap = h.org_to_dec = 0;

	fgets( line, 1000, in );	/* get the machine rolling */
	
	while( getarequest( glyph, num ) )
	{
		while( !process( line, glyph, num, h.org_to_cap, h.org_to_dec, i ) )
		if( !fgets( line, 1000, in ) )
		{
			fprintf( stderr, "\t\t\aCan't process glyph %d (HERSHEY %d)\r", glyph, num );
			exit( 2 );
		}
	}
	for( h.first = 0; h.first != -1 && !offset[h.first]; h.first++ );
	for( h.nchrs = GLYPHNUM-h.first; h.nchrs >= h.first && !offset[h.nchrs+h.first-1]; h.nchrs-- );
	f.h.font_size = sizeof h + 3*h.nchrs + 2*i;
	h.cdefs = sizeof h + 3*h.nchrs;

	fwrite( &f, Prefix_Size, 1, out );
	fwrite( &h, sizeof h, 1, out );
	fwrite( offset+h.first, 2 * h.nchrs, 1, out );
	fwrite( width+h.first, h.nchrs, 1, out );
	fwrite( data, 2*i, 1, out );
	fclose( out );
	fclose( in );
	return	0;
}
