/*
GET HERSHEY FONTS
*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	"font.h"

#define	GLYPHNUM	200

int	offset[GLYPHNUM];
char	width[GLYPHNUM];
unsigned data[25000];

unsigned encode( int x, int y, int line )
{
	union	{
		struct
		{
			signed	xoff  : 7;
			unsigned flag1 : 1;
			signed	yoff  : 7;
			unsigned flag2 : 1;
		}	cword;
		unsigned u;
	}	data;
	data.cword.xoff = x;
	data.cword.yoff = y;
	data.cword.flag1 = 1;
	data.cword.flag2 = line;

	return	data.u;
}

int	process( char *line, int group, char &capitol, char &descender, int &dp )
{
	int	first, glyph, strokes, ladj, radj, y;
	char	tmp[1000];

	strcpy( tmp, line ); tmp[5] = ' ';
	strcpy( tmp+6, line+5 ); tmp[9] = 0;

	sscanf( tmp, "%d %d", &glyph, &strokes );
	if( glyph >= group+GLYPHNUM )
		return	0;	/* done here */
	glyph -= group;
	line += 8;		/* skip the counts */
	ladj = *line++ - 'R';
	radj = *line++ - 'R';
	width[glyph] = radj - ladj;
	offset[glyph] = 2*dp;

	first = strokes-1;
	while( --strokes > 0 )
	{
		if( *line == ' ')
		{
			data[dp++] = encode( line[2] - ladj - 'R',
				y = '[' - line[3], 0 );
			line += 4;
			strokes--;
		} else {
			data[dp++] = encode( line[0] - ladj - 'R',
				y = '[' - line[1], strokes!=first );
			line += 2;
		}
		if( y < descender )
			descender = y;
		if( y > capitol )
			capitol = y;
	}
	data[dp++] = encode( radj - ladj, 0, 0 );/* move to new pos */
	data[dp++] = 0;		/* mark end */
	return	1;		/* continue */
}

int	main( int argc, char **argv )
{
	FILE	*in, *out;
	char	line[1000], outname[10];
	int	glyph, stroke, i, group;
	HEADER	h;
	struct {
		char	text[60];
		FHEADER	h;
	}	f;

	if( (in = fopen("HERSHEY.DAT", "rt")) == NULL )
		return	1;

	h.sig = SIGNATURE;
	h.nchrs = 200;
	h.mystery = 0;
	h.first = 32;
	h.cdefs = sizeof h + 3 * GLYPHNUM;
	h.scan_flag = 0;
	h.org_to_base = 0;
	h.unused = 0;		/* still unset: org2cap, org2dec, name */

	strcpy( f.text, "PK\b\bHERSHEY fonts, (C) 1993 by Larry Bartholdi & his gang\r\n\032");
	f.h.header_size = Prefix_Size;
	f.h.font_major = 1, f.h.font_minor = 0;
	f.h.min_major = 1, f.h.min_minor = 0;
				/* still unset: name, size */

	fgets( line, 1000, in );	/* get the machine rolling */

	for( group = 0; group < 5200; group += 200 )
	{
		fprintf( stderr, "Fonts %d--%d\r", group, group+GLYPHNUM-1 );

		sprintf( h.fntname, "H_%02d", group/100 );
		sprintf( f.h.font_name, "H_%02d", group/100 );
		sprintf( outname, "H_%02d.CHR", group/100 );
		out = fopen( outname, "wb");

		for( i = 0; i < GLYPHNUM; i++ )
			width[i] = offset[i] = 0;
		i = 0;
		data[i++] = 0;
		h.org_to_cap = h.org_to_dec = 0;
		while( process( line, group, h.org_to_cap, h.org_to_dec, i ) )
		if( !fgets( line, 1000, in ) )
			break;
		f.h.font_size = sizeof h + 3*GLYPHNUM + 2*i;
		fwrite( &f, Prefix_Size, 1, out );
		fwrite( &h, sizeof h, 1, out );
		fwrite( offset, 2 * GLYPHNUM, 1, out );
		fwrite( width, GLYPHNUM, 1, out );
		fwrite( data, 2*i, 1, out );
		fclose( out );
	}
	fclose( in );
	return	0;
}
