/* MSDOS.C
 ************************************************************************
 *									*
 *		PC Scheme/Geneva 4.00 Borland C code			*
 *									*
 * (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
 * (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
 *									*
 *----------------------------------------------------------------------*
 *									*
 *		Special MesS-DOS File Functions				*
 *									*
 *----------------------------------------------------------------------*
 *									*
 * Created by: L. Bartholdi		Date: 1992			*
 * Revision history:							*
 * - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
 *									*
 *					``In nomine omnipotentii dei''	*
 ************************************************************************/

#include	<stdlib.h>
#include	"scheme.h"

#define	IOBUFSIZE	4096

int	copy_file(char *source, char *dest)
{
	int		hsource, hdest, count;
	unsigned long	len;
	void		*buffer;

	if( (buffer = malloc(IOBUFSIZE)) == NULL )
		return	-1;

	if( zopen( &hsource, source, 0, &len ) )
	{
		free(buffer);
		return	-1;
	}
	if( zcreate( &hdest, dest ) )
	{
		free(buffer);
		return	-1;
	}

	while( !zread( hsource, buffer, &(count = IOBUFSIZE) ) && count )
	if( zwrite( hdest, buffer, &count ) )
	{
		free(buffer);
		return	-1;
	}

	free(buffer);
	zclose(hsource);
	zclose(hdest);

	return	0;
}


long	filesize( char *filename )
{
	int             handle;
	unsigned long	size = -1;

	if( zopen( &handle, filename, 0, &size ) )
		zclose(handle);
	return	size;
}
