;* EYES.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*			A Simple Mouse Demo				*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: L. Bartholdi		Date: 19930930			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

; 0 . . . . . . . . . . . . . . . . 
; 1 . . . . . . . . . . . . . . . . 
; 2 . . o o o . . . . . . . . . . . 
; 3 . o . . . o . . . . . . . . . . 
; 4 . o . . . o . . . . . . . . . . 
; 5 o . . . . . o . . . . . . . . . 
; 6 o . . . . . o . . . . . . . . . 
; 7 o . . . . . o . . . . . . . . . 
; 8 o . . . . . o . . . . . . . . . 
; 9 o . o o o . o . . . . . . . . . 
;10 o o . . . o o . . . . . . . . . 
;11 . o . . . o . . . . . . . . . . 
;12 . o . . . o . . . . . . . . . . 
;13 . . o o o . . . . . . . . . . . 
;14 . . . . . . . . . . . . . . . . 
;15 . . . . . . . . . . . . . . . . 
;  151413121110 9 8 7 6 5 4 3 2 1 0

(define open-eye '(0 0 ( #b0000000011111111
			 #b0000000011110111
			 #b0000000011100011
			 #b0000000011000001
			 #b0000000011000001
			 #b0000000010000000
			 #b0000000010000000
			 #b0000000010000000
			 #b0000000010000000
			 #b0000000010000000
			 #b0000000010000000
			 #b0000000011000001
			 #b0000000011000001
			 #b0000000011100011
			 #b0000000011110111
			 #b0000000011111111 )

		       ( #b0000000000000000
			 #b0000000000000000
			 #b0000000000011100
			 #b0000000000100010
			 #b0000000000100010
			 #b0000000001000001
			 #b0000000001000001
			 #b0000000001000001
			 #b0000000001000001
			 #b0000000001011101
			 #b0000000001100011
			 #b0000000000100010
			 #b0000000000100010
			 #b0000000000011100
			 #b0000000000000000
			 #b0000000000000000 )
		       ))
(define closed-eye `(0 0 ,(caddr open-eye)
		         ( #b0000000000000000
			   #b0000000000000000
			   #b0000000000011100
			   #b0000000000100010
			   #b0000000000100010
			   #b0000000001000001
			   #b0000000001000001
			   #b0000000001011101
			   #b0000000001111111
			   #b0000000001110111
			   #b0000000001100011
			   #b0000000000110110
			   #b0000000000111110
			   #b0000000000011100
			   #b0000000000000000
			   #b0000000000000000 )
		       ))

(define (right pattern)
  (map (lambda (x) (* x #x100)) pattern))

(define (join p1 p2)
  (map (lambda (x y) (bitwise-or x y))
       p1 (right p2)))

(define m0 (list 0 0
		 (join (caddr open-eye) (caddr open-eye))
		 (join (cadddr open-eye) (cadddr open-eye))))
(define m1 (list 0 0
		 (join (caddr open-eye) (caddr closed-eye))
		 (join (cadddr open-eye) (cadddr closed-eye))))
(define m2 (list 0 0
		 (join (caddr closed-eye) (caddr open-eye))
		 (join (cadddr closed-eye) (cadddr open-eye))))
(define m3 (list 0 0
		 (join (caddr closed-eye) (caddr closed-eye))
		 (join (cadddr closed-eye) (cadddr closed-eye))))

(init-graph)
(mouse 'RESET)
(mouse 'SHOW)
(mouse 'SHAPE m0)
(mouse 'HANDLER `((LEFT RIGHT) . 
		  ,(lambda (event state . rest)
		     (mouse 'SHAPE
			    (cond
			      ((equal? state '()) m0)
			      ((equal? state '(LEFT)) m1)
			      ((equal? state '(RIGHT)) m2)
			      ((equal? state '(LEFT RIGHT)) m3))))))
(writeln "Press any key to abort...")
((rec loop
   (lambda (count)
     (when (not (char-ready?))
       (let ((fade (* 100 (exp (/ (* count count) -40000.0)))))
	 (if (> (random 100) fade)
	     (begin
	       (mouse 'HIDE)
	       (mouse 'SHOW)
	       (set-color 0))
	     (set-color (1+ (random (-1+ (get-max-color)))))))
       (line (cons (random (car (get-max-xy))) (random (cdr (get-max-xy))))
	     (cons (random (car (get-max-xy))) (random (cdr (get-max-xy)))))
       (loop (1+ count)))))
 0)
(read-char)
(close-graph)
(mouse 'RESET)
