%* B.SW
%************************************************************************
%*									*
%*		PC Scheme/Geneva 4.00 Scheme-WEB code			*
%*									*
%* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
%* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
%*									*
%*----------------------------------------------------------------------*
%*									*
%*			Scheme support for Brief (TM)			*
%*									*
%*----------------------------------------------------------------------*
%*									*
%* Created by: Larry Bartholdi		Date: 1993			*
%* Revision history:							*
%*									*
%*					``In nomine omnipotentii dei''	*
%************************************************************************

\documentstyle[11pt,a4,astyped]{article}
\title{Scheme--BRIEF interface}
\author{Larry Bartholdi \& his gang}
\date{\today}

\newcommand{\pcs}{{\sc PcScheme}}
\newcommand{\brief}{{\sc Brief}}
\newcommand{\quot}[1]{$\langle$#1$\rangle$}

\begin{document}
\maketitle
\tableofcontents
\section{Introduction}
It is well known that many powerful editors (like {\sc Emacs}) are based
on Scheme and cohabit with it; and it is well known to Scheme programmers
that closing 10 parentheses or so with primitive command editing and
no indentation is painful.
Up to now, the only choice \pcs\ users had was to endure the keyboard typing
or to use the unreliable and poor editor {\sc EdWin}.

Rather than re-write yet another powerful editor, I have chosen to make
good use of the macro capabilities of an already-existing product,
\brief\footnote{\brief is trademark of Borland International}.
\brief\ has many of the options provided by {\sc Emacs}, while being well
suited to PC compatibles; it is programmable in a subset of the C language.

The problem with this approach is interfacing between \brief\ and \pcs.
The solution chosen is to create a temporary file within \brief, that will
be loaded as scheme code by \pcs. The only two messages supported are
``evaluate the buffer'' and ``evaluate the marked block'', which are written
as simple Scheme expressions by the \brief macros.

\section{Installation}
You need the following files:
\begin{description}
\item[{\tt SCHEME.CM}]	the \brief\ compiled code
\item[{\tt SCHEME.MNU}]	the help file
\item[{\tt SCHEME.CMP}]	the completion dictionary
\item[{\tt SCHEME.CB}]	(optional) the \brief\ source code.
\end{description}
Move {\tt SCHEME.CM} to \verb+\brief\macros+ and {\tt SCHEME.MNU}
to \verb+\brief\help+; add ``\verb+set BSCHEME=+{\em the path to
{\tt SCHEME.CMP}, including the trailing \verb+\+}'' to your
\verb+autoexec.bat+ file; and you know what to do with {\tt SCHEME.CB}\ldots

You then have to add the following to your initials macro file:
\begin{verbatim}
 (macro .s
     (
         (tabs 9 17)
         (if (== (inq_macro "scheme_indent") 0)
             (load_macro "scheme")
         )
     )
 )
\end{verbatim}
and (if you program in Scheme-WEB),
\begin{verbatim}
 (macro .sw
     (
         (.s)
     )
 )
\end{verbatim}
Don't forget to recompile it!

\section{Use of the \brief\ package}
A few commands have been redefined, following where possible the \brief\
tradition. Interface to PCS, () matching, indentation, S-expression
marking, and word completion from an arbirary dictionary
have been added to the basics.

The commands whose meaning changed are:
\begin{description}
\item[\quot{Enter}]	Automatically indents the next line
\item[\quot{Ctrl-h}]	Provides a short description of the new commands
\item[")"]	Searches for the matching "("; if the match is visible,
	highlights it for a second; otherwise displays the line where
	the match came from on the status line.
\item[\quot{Tab}]	If a block has been marked, indents every
	line in the block; if the cursor is in leading whitespace,
	indents the current line; otherwise completes the current word.
	The current word is considered to start at the closest parenthesis
	or whitespace backwards, whichever comes first (well, last).
	Continually depressing the \quot{Tab} key searches for another
	completion to the current word. \quot{Esc} aborts the completion process.
\item[\quot{Shift-Tab}]	Positions the cursor to column 49 and inserts a
	\verb*+; + (start of comment). It is my hope this will make
	programs more readable\ldots
\item[\quot{Ctrl-G}]	Creates a menu of all the objects defined in the buffer.
	If procedures are defined by \verb+(define (foo x y) ...)+,
	the procedure's name with its arguments are displayed. In any case
	selecting an entry positions the cursor on that object's
	declaration.
\item[\quot{Ctrl-A}]	Marks the smallest S-expression (list) containing the
	cursor. An error occurs if the cursor is not inside a list.
\item[\quot{Ctrl-Z}]	Marks the largest S-expression (list) containing the
	cursor. An error occurs if the cursor is not inside a list.
\item[\quot{Alt-F10}]	Evaluates the entire buffer, passing control to
	\pcs\ (or whoever called \brief).
\item[\quot{Ctrl-F10}]	Evaluates the marked block, passing control to
	\pcs\ (or whoever called \brief). If no block is marked, the largest
	S-expression is selected first.
\item[\quot{Ctrl-F1}]	Toggles on or off the tabbing and autoindentation
	features. Use this when very desperate, esp. if you edit a very
	large file, or want to insert some non-scheme text (like in Scheme-WEB).
\end{description}

\section{A Few Notes on Identation}
\brief\ tries to be smart at guessing where to indent Scheme code.
Its algorithm is to find the parenthesis opening the list that contains the
current position; then to look at the first element of that list to see if
it is a special word --- |lambda|, |define| and others. In that case, the
current line gets aligned two spaces; In case the current symbol is a closing
parenthesis, the current line is aligned with the opening brace. In all
other cases, the current line is aligned to the first item in the list.

\section{Bugs}
\begin{itemize}
\item	We proudly inherit all bugs in \brief (!).
\item	\brief\ is not shareware.
\item	There is no mechanism to handle source-file errors elegantly.
\item	The macros may be slow; this is because CBrief is an interpreted
	language.
\item	Some problems occur in Scheme-WEB files, when text editing should
	supersede Scheme macro capabilities.
\end{itemize}

\section{The \pcs\ side}
A small procedure, |b|, is defined. It can be called with 0 or 1 arguments,
the optional argument being faithfully passed to brief.

|B| calls \brief\ with all memory available and no screen-saving option.
This is not necessary since \brief\ saves the screen itself.

|B| then loads the file handed back by \brief, and loads it.

(define (b . args)
  (let ((brief (dos-search-file "b.exe"))
	(transfer (string-append ""
				 (dos-get-env "BSCHEME")
				 "scheme.tmp"))
	(getarg (lambda (a)
	  (cond ((string? a) (string-append " " a))
		((integer? a)
		 (string-append " -m\"goto_line "
				(integer->string a 10)
				"\""))
		(else (error 'B "Invalid argument " a))))))
    (if (null? brief)
       	(error 'B "Could not find B.EXE"))
    (dos-call brief
	      (apply string-append (map getarg args))
	      0
	      1)
    (if (file-exists? transfer)
	(load transfer))
    *the-non-printing-object*))

\end{document}

