;; Patches to PC Scheme 3.02 to add optional features of the
;; Revised^3 Report on the Algorithmic Language Scheme
;;
;; (c) Copyright 1990 Carl W. Hoffman.  All rights reserved.
;;
;; This file may be freely copied, distributed, or modified for non-commercial
;; use provided that this copyright notice is not removed.  For further
;; information about other utilities for PC Scheme, contact the following
;; address:
;;
;;   Carl W. Hoffman, 363 Marlborough Street, Boston, MA 02115, U.S.A.
;;   CompuServe: 76416,3365    Fax: 617-262-4284

;; This file is an enhancement to Texas Instruments PC Scheme to add some of
;; the optional features of the Revised^3 Report on the Algorithmic Language
;; Scheme, and to fix one significant incompatibility.

;; The most recent version of PC Scheme which I have tested this file in is
;; version 3.02.  If changes are necessary for more recent versions of PC
;; Scheme, I would appreciate hearing about them.

(cond
  ((not (getprop '%pcs-symbol? 'pcs*primop-handler))
   (define %pcs-symbol? (eval 'symbol?))
   (putprop '%pcs-symbol? (getprop 'symbol? 'pcs*primop-handler) 'pcs*primop-handler)
   (putprop '%pcs-symbol? (getprop 'symbol? 'pcs*opcode) 'pcs*opcode)
   (remprop 'symbol? 'pcs*primop-handler)
   (remprop 'symbol? 'pcs*opcode)
   (putprop '%pcs-cond (getprop 'cond 'pcs*macro) 'pcs*macro)
   (define %pcs-apply (eval 'apply))
   (putprop '%pcs-apply (getprop 'apply 'pcs*primop-handler) 'pcs*primop-handler)
   (remprop 'apply 'pcs*primop-handler)
   (define %pcs-map (eval 'map))
   (define %pcs-for-each (eval 'for-each))
   ))

;; PC Scheme 3.02 returns #T for (SYMBOL? #T).  This is incompatible with the
;; standard.

(define (symbol? x)
  (if (eq? x #t) #f (%pcs-symbol? x)))

;; These procedures are missing from PC Scheme 3.02.

(define (char-upper-case? char)
  (and (char<=? #\A char) (char<=? char #\Z)))

(define (char-lower-case? char)
  (and (char<=? #\a char) (char<=? char #\z)))

(define (char-alphabetic? char)
  (or (char-upper-case? char)
      (char-lower-case? char)))

(define (char-numeric? char)
  (and (char<=? #\0 char) (char<=? char #\9)))

(define (char-whitespace? char)
  (or (char=? char #\space)
      (char=? char #\tab)
      (char=? char #\newline)))

;; Support the => feature in COND

(macro cond
  (lambda (form)
    (let ((clauses (cdr form))
          (=>seen? #f))

      ;; First pass.  Check if any clauses use =>.  If they do
      ;; verify that the syntax is correct.
      (for-each
        (lambda (clause)
          (cond ((not (pair? clause))
                 (error "COND clause not a list"))
                ((and (pair? (cdr clause)) (eq? (cadr clause) '=>))
                 (if (not (pair? (cddr clause)))
                     (error "COND clause using => has length < 3"))
                 (if (not (null? (cdddr clause)))
                     (error "COND clause using => has length > 3"))
                 (set! =>seen? #t))))
        clauses)

      ;; Second pass.  Transform those clauses using =>.
      (if (not =>seen?)
          `(%pcs-cond . ,clauses)
          `(let ((=>temp_ #f))
             (%pcs-cond .
               ,(map (lambda (clause)
                       (if (and (pair? (cdr clause))
                                (eq? (cadr clause) '=>))
                           `((begin (set! =>temp_ ,(car clause)) =>temp_)
                             (,(caddr clause) =>temp_))
                           clause))
                     clauses)))))))

;; Enable the following functions to take more than two arguments:
;;   APPLY, MAP, FOR-EACH

(define (apply proc . args)
  ;; I'm not sure this is always safe to do.
  ;; We may be clobbering some constant list structure someplace.
  (if (null? (cdr args))
      (%pcs-apply proc (car args))
      ;; Reuse the already consed list of arguments, instead of doing
      ;;   (%pcs-apply proc (%pcs-apply list* args))
      ;; Is this always safe?
      (begin
        (do ((l args (cdr l)))
            ((null? (cddr l))
             (set-cdr! l (cadr l))))
        (%pcs-apply proc args))))

(define (%check-nary-list-args args)
  (if (null? args)
      (error "MAP and FOR-EACH require at least two arguments."))
  (let ((arg1-length (length (car args))))
    (%pcs-for-each
      (lambda (arg)
        (if (not (= arg1-length (length arg)))
            (error-procedure
              "The list arguments to MAP and FOR-EACH must all be the same length."
              args '())))
      args)))

(define (map proc . args)
  (%check-nary-list-args args)
  (case (length args)

    (1
      (%pcs-map proc (car args)))

    (2
      (let collect
           ((arg1 (car args))
            (arg2 (cadr args))
            (result '()))
        (if (null? arg1)
            (reverse! result)
            (collect (cdr arg1) (cdr arg2)
                     (cons (proc (car arg1) (car arg2))
                           result)))))
    (3
      (let collect
           ((arg1 (car args))
            (arg2 (cadr args))
            (arg3 (caddr args))
            (result '()))
        (if (null? arg1)
            (reverse! result)
            (collect (cdr arg1) (cdr arg2) (cdr arg3)
                     (cons (proc (car arg1) (car arg2) (car arg3))
                           result)))))
    (4
      (let collect
           ((arg1 arg1)
            (arg2 arg2)
            (arg3 arg3)
            (arg4 arg4)
            (result '()))
        (if (null? arg1)
            (reverse! result)
            (collect (cdr arg1) (cdr arg2) (cdr arg3) (cdr arg4)
                     (cons (proc (car arg1) (car arg2) (car arg3) (car arg4))
                           result)))))
    (else
      (let collect
           ((args args))
        (if (null? (car args))
            '()
            (cons (%pcs-apply proc (%pcs-map car args))
                  (collect (%pcs-map cdr args))))))))

(define (for-each proc . args)
  (%check-nary-list-args args)
  (case (length args)

    (1
      (%pcs-for-each proc (car args)))

    (2
      (let repeat
           ((arg1 (car args))
            (arg2 (cadr args)))
        (cond ((not (null? arg1))
               (proc (car arg1) (car arg2))
               (repeat (cdr arg1) (cdr arg2))))))
    (3
      (let repeat
           ((arg1 (car args))
            (arg2 (cadr args))
            (arg3 (caddr args)))
        (cond ((not (null? arg1))
               (proc (car arg1) (car arg2) (car arg3))
               (repeat (cdr arg1) (cdr arg2) (cdr arg3))))))
    (4
      (let repeat
           ((arg1 (car args))
            (arg2 (cadr args))
            (arg3 (caddr args))
            (arg4 (cadddr args)))
        (cond ((not (null? arg1))
               (proc (car arg1) (car arg2) (car arg3) (car arg4))
               (repeat (cdr arg1) (cdr arg2) (cdr arg3) (cdr arg4))))))
    (else
      (let repeat
           ((args args))
        (cond ((not (null? (car args)))
               (%pcs-apply proc (%pcs-map car args))
               (repeat (%pcs-map cdr args))))))))
