/* -*-C-*-

$Header: Xlib.h,v 1.1 87/07/23 23:47:48 GMT cph Rel $

Copyright (c) 1987 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. */

/* Xlib Interface Definitions */

#include <X/Xlib.h>

/* Resource ID Representations */

#define UNDEFINED_RESOURCE 0

#define FAST_RESOURCE_TO_OBJECT(resource)				\
  ((((long) (resource)) == 0) ? NIL :					\
   ((((unsigned long) (resource)) <= ADDRESS_MASK)			\
    ? (MAKE_UNSIGNED_FIXNUM ((unsigned long) (resource)))		\
    : (RESOURCE_TO_OBJECT (resource))))

#define RESOURCE_TO_OBJECT(resource) (resource_to_object ((long) (resource)))
#define RESOURCE_ARG(type, arg) ((type) (resource_arg (arg)))

#define RESOURCE_OBJECT_P(object)					\
  (((object) == NIL) ||							\
   (FIXNUM_P (object)) ||						\
   ((NON_MARKED_VECTOR_P (object)) && ((Vector_Length (object)) == 1)))

#define RESOURCE_GC_CHECK() Primitive_GC_If_Needed (2)

extern Pointer resource_to_object ();
extern long resource_arg ();

/* Strictly speaking, displays are not X resource objects,
   but they can be treated the same way. */

#define XDISPLAY_ARG(arg) (RESOURCE_ARG (Display *, arg))
#define XDISPLAY_VALUE RESOURCE_TO_OBJECT
#define FAST_XDISPLAY_VALUE FAST_RESOURCE_TO_OBJECT

#define XWINDOW_ARG(arg) (RESOURCE_ARG (Window, arg))
#define XWINDOW_VALUE RESOURCE_TO_OBJECT
#define FAST_XWINDOW_VALUE FAST_RESOURCE_TO_OBJECT

#define XFONT_ARG(arg) (RESOURCE_ARG (Font, arg))
#define XFONT_VALUE RESOURCE_TO_OBJECT
#define FAST_XFONT_VALUE FAST_RESOURCE_TO_OBJECT

#define XPIXMAP_ARG(arg) (RESOURCE_ARG (Pixmap, arg))
#define XPIXMAP_VALUE RESOURCE_TO_OBJECT
#define FAST_XPIXMAP_VALUE FAST_RESOURCE_TO_OBJECT

#define XBITMAP_ARG(arg) (RESOURCE_ARG (Bitmap, arg))
#define XBITMAP_VALUE RESOURCE_TO_OBJECT
#define FAST_XBITMAP_VALUE FAST_RESOURCE_TO_OBJECT

#define XCURSOR_ARG(arg) (RESOURCE_ARG (Cursor, arg))
#define XCURSOR_VALUE RESOURCE_TO_OBJECT
#define FAST_XCURSOR_VALUE FAST_RESOURCE_TO_OBJECT

#define XLOCATOR_ARG(arg) (RESOURCE_ARG (Locator, arg))
#define XLOCATOR_VALUE RESOURCE_TO_OBJECT
#define FAST_XLOCATOR_VALUE FAST_RESOURCE_TO_OBJECT

/* Structure Representations */

#define XSTRUCT_ALLOCATE(type, gc_check_p)				\
  (allocate_non_marked_vector						\
   (TC_NON_MARKED_VECTOR, (BYTES_TO_POINTERS (sizeof (type))), gc_check_p))

#define XSTRUCT_DESCRIPTOR(type, xstruct)				\
  ((type *) (Nth_Vector_Loc (xstruct, 1)))

#define XSTRUCT_P(type, object)						\
  ((NON_MARKED_VECTOR_P (object)) &&					\
   ((Vector_Length (object)) == (BYTES_TO_POINTERS (sizeof (type)))))

#define XSTRUCT_ARG(type, arg)						\
  ((type *) (xstruct_arg ((BYTES_TO_POINTERS (sizeof (type))), arg)))

extern char *xstruct_arg ();

#define XEVENT_ALLOCATE(gc_check_p) (XSTRUCT_ALLOCATE (XEvent, gc_check_p))
#define XEVENT_DESCRIPTOR(event) (XSTRUCT_DESCRIPTOR (XEvent, event))
#define XEVENT_P(object) (XSTRUCT_P (XEvent, object))
#define XEVENT_ARG(arg) (XSTRUCT_ARG (XEvent, arg))

#define X_OPAQUE_FRAME_ALLOCATE(gc_check_p)				\
  (XSTRUCT_ALLOCATE (OpaqueFrame, gc_check_p))
#define X_OPAQUE_FRAME_DESCRIPTOR(opaque_frame)				\
  (XSTRUCT_DESCRIPTOR (OpaqueFrame, opaque_frame))
#define X_OPAQUE_FRAME_P(object) (XSTRUCT_P (OpaqueFrame, object))
#define X_OPAQUE_FRAME_ARG(arg) (XSTRUCT_ARG (OpaqueFrame, arg))

#define X_TRANSPARENT_FRAME_ALLOCATE(gc_check_p)			\
  (XSTRUCT_ALLOCATE (TransparentFrame, gc_check_p))
#define X_TRANSPARENT_FRAME_DESCRIPTOR(transparent_frame)		\
  (XSTRUCT_DESCRIPTOR (TransparentFrame, transparent_frame))
#define X_TRANSPARENT_FRAME_P(object) (XSTRUCT_P (TransparentFrame, object))
#define X_TRANSPARENT_FRAME_ARG(arg) (XSTRUCT_ARG (TransparentFrame, arg))

#define X_BATCH_FRAME_ALLOCATE(gc_check_p)				\
  (XSTRUCT_ALLOCATE (BatchFrame, gc_check_p))
#define X_BATCH_FRAME_DESCRIPTOR(batch_frame)				\
  (XSTRUCT_DESCRIPTOR (BatchFrame, batch_frame))
#define X_BATCH_FRAME_P(object) (XSTRUCT_P (BatchFrame, object))
#define X_BATCH_FRAME_ARG(arg) (XSTRUCT_ARG (BatchFrame, arg))

#define X_WINDOW_INFO_ALLOCATE(gc_check_p)				\
  (XSTRUCT_ALLOCATE (WindowInfo, gc_check_p))
#define X_WINDOW_INFO_DESCRIPTOR(window_info)				\
  (XSTRUCT_DESCRIPTOR (WindowInfo, window_info))
#define X_WINDOW_INFO_P(object) (XSTRUCT_P (WindowInfo, object))
#define X_WINDOW_INFO_ARG(arg) (XSTRUCT_ARG (WindowInfo, arg))

#define X_FONT_INFO_ALLOCATE(gc_check_p)				\
  (XSTRUCT_ALLOCATE (FontInfo, gc_check_p))
#define X_FONT_INFO_DESCRIPTOR(font_info)				\
  (XSTRUCT_DESCRIPTOR (FontInfo, font_info))
#define X_FONT_INFO_P(object) (XSTRUCT_P (FontInfo, object))
#define X_FONT_INFO_ARG(arg) (XSTRUCT_ARG (FontInfo, arg))

#define XMAP_DATA_ALLOCATE(length, gc_check_p)				\
  (allocate_non_marked_vector						\
   (TC_NON_MARKED_VECTOR, (BYTES_TO_POINTERS (length)), gc_check_p))

#define XMAP_DATA_P(length, object)					\
  ((NON_MARKED_VECTOR_P (object)) &&					\
   ((Vector_Length (object)) == (BYTES_TO_POINTERS (length))))

#define XMAP_DATA_DESCRIPTOR(map_data)					\
  ((short *) (Nth_Vector_Loc (map_data, 1)))

#define XMAP_DATA_ARG(length, arg)					\
  ((XMAP_DATA_P (length, (ARG_REF (arg))))				\
   ? (XMAP_DATA_DESCRIPTOR (ARG_REF (arg)))				\
   : ((short *) (error_wrong_type_arg (arg))))

#define STRUCT_SELECTOR(a1, slot, value)				\
{									\
  PRIMITIVE_HEADER (1);							\
									\
  RESOURCE_GC_CHECK ();							\
  PRIMITIVE_RETURN (value ((a1 (1)) -> slot));				\
}

#define OPERATION_0(c_name, value)					\
{									\
  PRIMITIVE_HEADER (0);							\
									\
  RESOURCE_GC_CHECK ();							\
  PRIMITIVE_RETURN (value (c_name ()));					\
}

#define OPERATION_1(c_name, value, a1)					\
{									\
  PRIMITIVE_HEADER (1);							\
									\
  RESOURCE_GC_CHECK ();							\
  PRIMITIVE_RETURN (value (c_name (a1 (1))));				\
}

#define OPERATION_2(c_name, value, a1, a2)				\
{									\
  PRIMITIVE_HEADER (2);							\
									\
  RESOURCE_GC_CHECK ();							\
  PRIMITIVE_RETURN (value (c_name ((a1 (1)), (a2 (2)))));		\
}

#define OPERATION_3(c_name, value, a1, a2, a3)				\
{									\
  PRIMITIVE_HEADER (3);							\
									\
  RESOURCE_GC_CHECK ();							\
  PRIMITIVE_RETURN (value (c_name ((a1 (1)), (a2 (2)), (a3 (3)))));	\
}

#define OPERATION_4(c_name, value, a1, a2, a3, a4)			\
{									\
  PRIMITIVE_HEADER (4);							\
									\
  RESOURCE_GC_CHECK ();							\
  PRIMITIVE_RETURN (value (c_name ((a1 (1)),				\
				   (a2 (2)),				\
				   (a3 (3)),				\
				   (a4 (4)))));				\
}

#define OPERATION_5(c_name, value, a1, a2, a3, a4, a5)			\
{									\
  PRIMITIVE_HEADER (5);							\
									\
  RESOURCE_GC_CHECK ();							\
  PRIMITIVE_RETURN (value (c_name ((a1 (1)),				\
				   (a2 (2)),				\
				   (a3 (3)),				\
				   (a4 (4)),				\
				   (a5 (5)))));				\
}

#define OPERATION_6(c_name, value, a1, a2, a3, a4, a5, a6)		\
{									\
  PRIMITIVE_HEADER (6);							\
									\
  RESOURCE_GC_CHECK ();							\
  PRIMITIVE_RETURN (value (c_name ((a1 (1)),				\
				   (a2 (2)),				\
				   (a3 (3)),				\
				   (a4 (4)),				\
				   (a5 (5)),				\
				   (a6 (6)))));				\
}

#define OPERATION_7(c_name, value, a1, a2, a3, a4, a5, a6, a7)		\
{									\
  PRIMITIVE_HEADER (7);							\
									\
  RESOURCE_GC_CHECK ();							\
  PRIMITIVE_RETURN (value (c_name ((a1 (1)),				\
				   (a2 (2)),				\
				   (a3 (3)),				\
				   (a4 (4)),				\
				   (a5 (5)),				\
				   (a6 (6)),				\
				   (a7 (7)))));				\
}

#define OPERATION_8(c_name, value, a1, a2, a3, a4, a5, a6, a7, a8)	\
{									\
  PRIMITIVE_HEADER (8);							\
									\
  RESOURCE_GC_CHECK ();							\
  PRIMITIVE_RETURN (value (c_name ((a1 (1)),				\
				   (a2 (2)),				\
				   (a3 (3)),				\
				   (a4 (4)),				\
				   (a5 (5)),				\
				   (a6 (6)),				\
				   (a7 (7)),				\
				   (a8 (8)))));				\
}

#define OPERATION_9(c_name, value, a1, a2, a3, a4, a5, a6, a7, a8, a9)	\
{									\
  PRIMITIVE_HEADER (9);							\
									\
  RESOURCE_GC_CHECK ();							\
  PRIMITIVE_RETURN (value (c_name ((a1 (1)),				\
				   (a2 (2)),				\
				   (a3 (3)),				\
				   (a4 (4)),				\
				   (a5 (5)),				\
				   (a6 (6)),				\
				   (a7 (7)),				\
				   (a8 (8)),				\
				   (a9 (9)))));				\
}

#define OPERATION_10(c_name, value, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10) \
{									\
  PRIMITIVE_HEADER (10);						\
									\
  RESOURCE_GC_CHECK ();							\
  PRIMITIVE_RETURN (value (c_name ((a1 (1)),				\
				   (a2 (2)),				\
				   (a3 (3)),				\
				   (a4 (4)),				\
				   (a5 (5)),				\
				   (a6 (6)),				\
				   (a7 (7)),				\
				   (a8 (8)),				\
				   (a9 (9)),				\
				   (a10 (10)))));			\
}

#define XSTATUS(status)							\
{									\
  if ((status) == 0)							\
    PRIMITIVE_RETURN (TRUTH);						\
}

#define VOID_VALUE(value) ((value), NIL)
#define BOOLEAN_VALUE BOOLEAN_TO_OBJECT

/* Must be careful about this because it may cause a GC */
#define STRING_VALUE C_String_To_Scheme_String

#define Z_PixmapSize(width, height)					\
  (((DisplayPlanes ()) <= 8)						\
   ? (BZPixmapSize (width, height))					\
   : (WZPixmapSize (width, height)))

#define XY_PixmapSize(width, height)					\
  (XYPixmapSize (width, height, (DisplayPlanes ())))
