;;; -*- Mode: Scheme; Syntax: Scheme; Package: (SCHEME :USE (PSEUDOSCHEME)) -*-

;;;
;;;	$Header$
;;;
;;;	Copyright (c) 1986, 1987 Massachusetts Institute of Technology
;;;     Initial implementation due to Ken Haase (KWH@AI.AI.MIT.EDU)
;;;
;;;	This material was developed by the Scheme project at the
;;;	Massachusetts Institute of Technology, Department of
;;;	Electrical Engineering and Computer Science.  Permission to
;;;	copy this software, to redistribute it, and to use it for any
;;;	purpose is granted, subject to the following restrictions and
;;;	understandings.
;;;
;;;	1. Any copy made of this software must include this copyright
;;;	notice in full.
;;;
;;;	2. Users of this software agree to make their best efforts (a)
;;;	to return to the MIT Scheme project any improvements or
;;;	extensions that they make, so that these may be included in
;;;	future releases; and (b) to inform MIT of noteworthy uses of
;;;	this software.
;;;
;;;	3. All materials developed as a consequence of the use of this
;;;	software shall duly acknowledge such use, in accordance with
;;;	the usual standards of acknowledging credit in academic
;;;	research.
;;;
;;;	4. MIT has made no warrantee or representation that the
;;;	operation of this software will be error-free, and MIT is
;;;	under no obligation to provide any services, by way of
;;;	maintenance, update, or otherwise.
;;;
;;;	5. In conjunction with products arising from the use of this
;;;	material, there shall be no use of the name of the
;;;	Massachusetts Institute of Technology nor of any adaptation
;;;	thereof in any advertising, promotional, or sales literature
;;;	without prior written consent from MIT in each case.
;;;

(declare (usual-integrations))
(declare (integrate-external "/u/kwh/programs/utility/plus")
	 (integrate-external "/u/kwh/programs/utility/mutable")
	 (integrate-external "/u/kwh/programs/utility/tuple")
	 (integrate-external "/u/kwh/programs/typical/kernel"))



;;;; Properties of random objects.

(define annotations (make-mutable))
(set-type-properties! lisp-objects
		      (list annotations daemons-inhibited daemons-already-run))

(define (annotate! x . annotation)
  ((mutator annotations) x
   (lambda (v) (if (undefined? v) (list annotation) (cons annotation v)))))

(set-property-printer! annotations (list-field-printer "Annotations" $printout))
(set-property-printer! daemons-inhibited   (list-field-printer "Inhibitions" $daemon))
(set-property-printer! daemons-already-run (list-field-printer "Daemon History" $daemon))


;;;; Properties of lists.

(add-property! car lists "CAR of list:")
(add-property! cdr lists "CDR of list:")


;;;; Properties of procedures:

(add-property! function-domain procedures "Domain")
(add-property! function-range  procedures "Range")

(add-type-property! types-for-daemon daemons)
(set-property-printer! types-for-daemon	(list-field-printer "For Types" identity))

(add-type-property! inverse invertibles)
(set-property-name+format! inverse "Inverse" $procedure)

(add-type-property! mutator mutables)
(set-property-name+format! mutator "Mutator" $procedure)

(add-type-property! enumerator enumerables)
(set-property-name+format! enumerator "Enumerator" $procedure)

(add-type-property! memoizer-cache memoizers)
(add-type-property! memoizer-function memoizers)

(add-type-property! procedure-description procedures)
(set-property-name+format!
 procedure-description "Procedure Description" $printout)


;;; Properties of tuples:

(add-property! tuple-elements tuples "As List")


;;;; Properties of tasks

(add-property! task-initial-application tasks "Initialization")
(add-type-property! task-state-description tasks)
(set-property-name+format! task-state-description "Current State" $call)
(add-property! task-state tasks "Next State")


;;;; Properties of types

;;; For types, you want to know about the specification, their lattice position,
;;;  and any daemons defined for them.
(set-type-properties!
 types (list td-generalizations td-specializations
	     complement-cache subtypes-of-cache supertypes-of-cache
	     daemons-for-type domain-for range-for images-constrained))

(set-property-printer! td-generalizations
		       (list-field-printer "Generalizations" identity))
(set-property-printer! td-specializations
		       (list-field-printer "Specializations" identity))

(set-property-name! subtypes-of-cache "Subtypes Type (Power Set)")
(set-property-name! supertypes-of-cache "Supertypes Type")
(set-property-name! complement-cache "Complement")

(set-property-printer! range-for
		       (list-field-printer "Range for" $procedure))
(set-property-printer! domain-for
		       (list-field-printer "Domain for" $procedure))
(set-property-printer! images-constrained
		       (list-field-printer "Constrains Images" $constraint))
(set-property-printer! daemons-for-type (list-field-printer "Daemons" $daemon))


;;;; Describing particular types.

;;; Simple types

(add-property! simple-type-predicate simple-types "Calls Predicate")
(add-property! simple-type-beneath simple-types "Defined Beneath")

;;; Collections

(add-property! collection-size collections "Number of Elements")

;;; Power sets

(add-property!  most-general-instance-of  subtype-types "Most General Instance (Top)")
(add-property!  most-specific-instance-of supertype-types "Most Specific Instance (Bottom)")

;;; Image Constraints

(add-property! image-constraint-image image-constraints "Requires image to be in")
(add-property! image-constraint-mapping image-constraints "Uses image of")

;;; Intersections

(add-property! type-intersection-right type-intersections "Defining Generalization")
(add-property! type-intersection-left type-intersections "Defining Generalization")

;;; Unions

(add-property! type-union-right type-unions "Defining Specialization")
(add-property! type-union-left  type-unions "Defining Specialization")

;;; Inductive definitions.

(add-property! induction-anchor inductive-definitions "Definition Anchor")
(add-property! induction-test inductive-definitions "Inductive Test")
(add-type-property! induction-links inductive-definitions)
(set-property-printer! induction-links (list-field-printer "Recurs On" $procedure))


