;;; -*- Mode: Scheme; Syntax: Scheme; Package: (SCHEME :USE (PSEUDOSCHEME)) -*-

;;;
;;;	$Header$
;;;
;;;	Copyright (c) 1986, 1987 Massachusetts Institute of Technology
;;;     Initial implementation due to Ken Haase (KWH@AI.AI.MIT.EDU)
;;;
;;;	This material was developed by the Scheme project at the
;;;	Massachusetts Institute of Technology, Department of
;;;	Electrical Engineering and Computer Science.  Permission to
;;;	copy this software, to redistribute it, and to use it for any
;;;	purpose is granted, subject to the following restrictions and
;;;	understandings.
;;;
;;;	1. Any copy made of this software must include this copyright
;;;	notice in full.
;;;
;;;	2. Users of this software agree to make their best efforts (a)
;;;	to return to the MIT Scheme project any improvements or
;;;	extensions that they make, so that these may be included in
;;;	future releases; and (b) to inform MIT of noteworthy uses of
;;;	this software.
;;;
;;;	3. All materials developed as a consequence of the use of this
;;;	software shall duly acknowledge such use, in accordance with
;;;	the usual standards of acknowledging credit in academic
;;;	research.
;;;
;;;	4. MIT has made no warrantee or representation that the
;;;	operation of this software will be error-free, and MIT is
;;;	under no obligation to provide any services, by way of
;;;	maintenance, update, or otherwise.
;;;
;;;	5. In conjunction with products arising from the use of this
;;;	material, there shall be no use of the name of the
;;;	Massachusetts Institute of Technology nor of any adaptation
;;;	thereof in any advertising, promotional, or sales literature
;;;	without prior written consent from MIT in each case.
;;;

(declare (usual-integrations))
(declare (integrate-external "/u/kwh/programs/utility/plus")
	 (integrate-external "/u/kwh/programs/utility/mutable")
	 (integrate-external "/u/kwh/programs/typical/kernel"))



;;;; Meta-Types

(define simple-types
  (type "Simple Test types" record td-specification
	(record car (primitive-set-of (list simple-type) procedures))))
(define (simple-type-predicate x) (second (td-specification x)))
(define (simple-type-beneath x) (third (td-specification x)))
(name-procedure! simple-type 'SIMPLE-TYPE)
(declare-function! simple-type-predicate types procedures)
(declare-function! simple-type-beneath types types)

(define query-types
  (type "Query Types" image-constraint
	td-specification
	(image-constraint car (primitive-set-of (list query-type) procedures))))
(name-procedure! query-type 'QUERY-TYPE)

(define divided-types
  (type "Divided Types" record td-specification
	(record car (primitive-set-of (list divided-type) procedures))))
(name-procedure! divided-type 'DIVIDED-TYPE)
(define test-types (type "Test Types" <OR> simple-types query-types divided-types))

(define inductive-definitions
  (type "Inductive Definitions" simple-type inductive-definition?
	simple-types))
(begin ((modifier collection-enumerator) inductive-definitions
	(lambda () all-inductive-definitions)))
(declare-function! induction-test inductive-definitions types)
(declare-function! induction-anchor inductive-definitions types)
(declare-function! induction-links inductive-definitions conses)

(define collections
  (type "Collections" simple-type collection? types))
(define mutable-types
  (type "Mutable Types" simple-type mutable-type? types))
(define mutable-collections
  (type "Mutable Collections" <AND> collections mutable-types))
(define fixed-collections
  (type "Fixed Collections" record td-specification
	(record car (primitive-set-of (list primitive-set-of-type) procedures))))
(define generated-collections
  (type "Generated Collections" simple-type generated-collection? simple-types))
(define (collection-size collection)
  (length (collection-elements collection)))

(define synthetic-types
  (type "Synthetic Types" <OR> test-types collections))

;;;; Analytic meta-types

(define subtype-types
  (type "Subtype Types" record td-specification
	(record car (primitive-set-of (list subtypes-of) procedures))))
(name-procedure! subtypes-of 'subtypes-of)
(define (most-general-instance-of x) (second (td-specification x)))
(declare-function! most-general-instance-of subtype-types types)

(define supertype-types
  (type "Supertype Types" record td-specification
	(record car (primitive-set-of (list supertypes-of) procedures))))
(name-procedure! supertypes-of 'supertypes-of)
(define (most-specific-instance-of x) (second (td-specification x)))
(declare-function! most-specific-instance-of supertype-types types)

(define image-constraints
  (type "Image Constraints" record td-specification
	(record car (primitive-set-of (list constraint-on-image) procedures))))
(name-procedure! constraint-on-image 'constraint-on-image)
(define (image-constraint-mapping x) (second (td-specification x)))
(define (image-constraint-image x) (third (td-specification x)))
(declare-function! image-constraint-mapping image-constraints declared-functions)
(declare-function! image-constraint-image   image-constraints types)

(define type-intersections
  (type "Type Intersections" record td-specification
	(record car (primitive-set-of (list type-intersection) procedures))))
(name-procedure! type-intersection 'type-intersection)
(declare-function! type-intersection-right type-intersections types)
(declare-function! type-intersection-left type-intersections types)

(define type-unions
  (type "Type Unions" record td-specification
	(record car (primitive-set-of (list type-union) procedures))))
(name-procedure! type-union 'type-union)
(declare-function! type-union-right type-unions types)
(declare-function! type-union-left type-unions types)

(define complements
  (type "Complements" record td-specification
	(record car (primitive-set-of (list type-complement) procedures))))
(name-procedure! type-complement 'type-complement)
(declare-function! complement types types)
(define (complement-of c) (complement-cache c))
(declare-function! complement-of complements types)

(define direct-types
  (type "Direct Types" <OR> type-intersections type-unions complements))
(define indirect-types
  (type "Indirect types" <OR> supertype-types subtype-types image-constraints))

(define analytic-types
  (type "Analytic Types" <OR> direct-types indirect-types))


;;;; Partial and complete types

(define complete-type-types ())
(define (complete-type? type)
  (some? complete-type-types (lambda (x) (in? type x))))
(define complete-types
  (type "Complete Types" simple-type complete-type? types))

;;; All initially defined types are revealed complete types.
(define revealed-complete-type-list type-list)
;;; Define the type of revealed complete types.
(define revealed-complete-types
  (type "Revealed Complete Types" simple-type
	(lambda (x) (memq x revealed-complete-type-list))
	types))
(define (declare-revealed-complete-type x f)
  (if (memq revealed-complete-types unlocked-collections)
      (if f (set! revealed-complete-type-list (cons x revealed-complete-type-list)))))
(begin ((modifier collection-modifier) revealed-complete-types
	 declare-revealed-complete-type))
                
;;; Revealed complete types are a revealed complete type.
(fluid-let ((unlocked-collections (cons revealed-complete-types unlocked-collections)))
  (put-in-collection! revealed-complete-types revealed-complete-types))

(define complete-inductive-definitions
  (type "Complete Inductive Types" record
	induction-anchor complete-types
	induction-test complete-types))

(define complete-synthetic-types
  (type "Complete Synthetic Types" <OR>
	revealed-complete-types fixed-collections
	generated-collections complete-inductive-definitions))
(define partial-synthetic-types
  (type "Partial Synthetic Types"
	<AND> synthetic-types (complement complete-synthetic-types)))

(define complete-image-constraint-types
  (type "Complete Image Constraint Types"
	record image-constraint-image complete-types))
(define complete-union-types
  (type "Complete Union Types"
	record type-union-left complete-types type-union-right complete-types))
(define complete-intersection-types
  (type "Complete Intersection Types"
	record type-intersection-left complete-types type-intersection-right complete-types))
(define complete-complement-types
  (type "Complete Complement Types" image-constraint complement-of complete-types))

(set! complete-type-types
      (list revealed-complete-types subtype-types supertype-types
	    complete-intersection-types complete-union-types
	    complete-complement-types
	    complete-image-constraint-types
	    complete-inductive-definitions))

(for-each (lambda (x) (add-td-generalization! x complete-types))
	  complete-type-types)


;;;; Complicated collection types

(define empirical-collections
  (type "Empirical Collections" generated-collection simple-types))
(define empirical-collection
  (collection-generator empirical-collections make-empirical-collection))
(define divided-collections
  (type "Divided Collections" generated-collection divided-types))
(define divided-collection
  (collection-generator divided-collections make-divided-collection))


;;;; TYPICAL procedure declarations

(declare-function! ->td lisp-objects types '->TD)
(declare-function! td-predicate types procedures 'td-predicate)
(declare-function! td-id types integers 'td-id)
(declare-function! td-generalizations types (list-of types) 'td-generalizations)
(declare-function! td-specializations types (list-of types) 'td-specializations)
(declare-function! td-property symbols (image-constraint function-domain types)
		   'td-property)

(declare-procedure! td-subsumed-by? booleans types types)
(declare-procedure! disjoint? booleans types types)
(declare-procedure! in? booleans lisp-objects types)

(declare-function! collection-enumerator collections procedures
		   'collection-enumerator)
(declare-function! collection-modifier   mutable-collections procedures
		   'collection-modifier)
(declare-function! collection-elements   collections lists
		   'collection-elements)

(declare-procedure! simple-type simple-types procedures types)
(declare-function!  subtypes-of types subtype-types)
(declare-function!  complement  types types)
(declare-procedure! primitive-set-of fixed-collections lists types)
(declare-procedure! query-type query-types strings types)

(declare-procedure! type-intersection type-intersections types types)
(declare-procedure! type-union type-unions types types)
(declare-function! (simplified-procedure <AND>) (list-of types) types)
(declare-function! (simplified-procedure <OR>)  (list-of types) types)

(declare-procedure! image-constraint image-constraints declared-functions types)
(declare-procedure! determine-image-constraints (list-of types) declared-functions types)
(declare-function! cddr (image-constraint cdr conses) lists)
(declare-function!
 (simplified-procedure record)
 (inductive-definition
  empty-lists
  (<AND> (image-constraint car declared-functions)
	 (image-constraint cdr (image-constraint car types)))
  (list cddr))
 types)
		      
