;;; -*- Mode: Scheme; Syntax: Scheme; Package: (SCHEME :USE (PSEUDOSCHEME)) -*-

;;;
;;;	$Header$
;;;
;;;	Copyright (c) 1986, 1987 Massachusetts Institute of Technology
;;;     Initial implementation due to Ken Haase (KWH@AI.AI.MIT.EDU)
;;;
;;;	This material was developed by the Scheme project at the
;;;	Massachusetts Institute of Technology, Department of
;;;	Electrical Engineering and Computer Science.  Permission to
;;;	copy this software, to redistribute it, and to use it for any
;;;	purpose is granted, subject to the following restrictions and
;;;	understandings.
;;;
;;;	1. Any copy made of this software must include this copyright
;;;	notice in full.
;;;
;;;	2. Users of this software agree to make their best efforts (a)
;;;	to return to the MIT Scheme project any improvements or
;;;	extensions that they make, so that these may be included in
;;;	future releases; and (b) to inform MIT of noteworthy uses of
;;;	this software.
;;;
;;;	3. All materials developed as a consequence of the use of this
;;;	software shall duly acknowledge such use, in accordance with
;;;	the usual standards of acknowledging credit in academic
;;;	research.
;;;
;;;	4. MIT has made no warrantee or representation that the
;;;	operation of this software will be error-free, and MIT is
;;;	under no obligation to provide any services, by way of
;;;	maintenance, update, or otherwise.
;;;
;;;	5. In conjunction with products arising from the use of this
;;;	material, there shall be no use of the name of the
;;;	Massachusetts Institute of Technology nor of any adaptation
;;;	thereof in any advertising, promotional, or sales literature
;;;	without prior written consent from MIT in each case.
;;;

(declare (usual-integrations))
(declare (integrate-external "/u/kwh/programs/utility/plus")
	 (integrate-external "/u/kwh/programs/utility/mutable")
	 (integrate-external "/u/kwh/programs/typical/kernel"))


;;;----------------------------------------------------------------
;;;;  <AND> combinator (composite)

(define (<AND> . types)
  (define (multi-intersection types intersection)
    (if (null? types) intersection
	(multi-intersection
	 (rest types) (type-intersection (first types) intersection))))
  (let ((minimals  (minimal-type-set types)))
    (multi-intersection (rest minimals) (first minimals))))


;;; ----------------------------------------------------------------
;;;;    <OR> combinator (composite)

(define (<OR> . types)
  (define (multi-union types union)
    (if (null? types) union
	(multi-union (rest types) (type-union (first types) union))))
  (let ((maximals (maximal-type-set types)))
  (multi-union (rest maximals) (first maximals))))


;;; ----------------------------------------------------------------
;;;;   RECORD combinator

(define (record . constraints)
  (if (even? (length constraints))
      (composite-constraint constraints)
      (ERROR "Odd number of CONSTRAINTS to RECORD=" constraints)))

(define (composite-constraint constraints)
  (define (extend-constraint constraint by)
    (if (null? by) constraint
	(extend-constraint
	 (<AND> constraint (image-constraint (first by) (second by)))
	 (rest (rest by)))))
  (if (even? (length constraints)) 
      (extend-constraint lattice-top constraints)
      (ERROR "Ill-formed constraint list CONSTRAINTS=" constraints)))
 

;;; ----------------------------------------------------------------
;;;;   CROSS-PRODUCT combinator

(define (make-cross-product . constraints)
  (define (create-cross-product constraints)
    (if (null? constraints) empty-lists
	(let ((cdr-constraint (create-cross-product (cdr constraints))))
	  (let ((cross-product (record car (car constraints) cdr cdr-constraint)))
	    ((td-modifier cross-product) 'pretty-name (cross-product-printer constraints))
	    cross-product))))
  (create-cross-product constraints))

(define cross-product (canonical-cache make-cross-product))
      
;;; Cross products are made to print out in a particular way.
(define (cross-product-printer constraints)
  (define (print-cross-product-notation element-sets)
    (cond ((null? element-sets) #T)
	  ((null? (rest element-sets)) (printout (first element-sets)))
	  (else (printout (first element-sets) " X ")
		(print-cross-product-notation (rest element-sets)))))
  (lambda ()
    (unwind-protect (begin (printout "(") (print-cross-product-notation constraints))
		    (printout ")"))))


;;; ----------------------------------------------------------------
;;;;   TUPLE-OF combinator

(define (tuple-product . element-types)
  (let ((type (image-constraint
	       tuple-elements (apply cross-product element-types))))

    (name-type! type (tuple-product-printer element-types))
    type))

(define (tuple-of a-type)
  (type (list "Tuple of " a-type)
	image-constraint tuple-elements (list-of a-type)))

(define (tuple-product-printer constraints)
  (define (print-tuple-product-notation element-sets)
    (cond ((null? element-sets) #T)
	  ((null? (rest element-sets)) (printout (first element-sets)))
	  (else (printout (first element-sets) " X ")
		(print-tuple-product-notation (rest element-sets)))))
  (lambda ()
    (unwind-protect (begin (printout "<") (print-tuple-product-notation constraints))
		    (printout ">"))))