;;; -*- Scheme -*-

(define-syntax (define-macro . args) `(define-syntax ,@args))
(define-syntax (definline . args) `(define-integrable ,@args))

(define (add-structure-printer key printer) printer)

(define procedure-name identification)

(define first car)
(define second cadr)
(define rest cdr)

(define (string x)
  (if (string? x) x
      (if (symbol? x) (symbol->string x)
	  (error "Not a string:" x))))

(define (hour-minute-second) (list 12 0 0))

(import *t-implementation-env* copy-bignum bignum-vector bignum? fixnum?
	*bits-per-hyperdigit* *bits-per-fixnum* bignum-size)

(define-integrable (bignum-digit big i) (vref (bignum-vector big) i))
(define-integrable (set-bignum-digit big i x)
  (set (vref (bignum-vector big) i) x))

(define (bignum-logand big1 big2)
  (let ((smallest (if (> (bignum-size big1) (bignum-size big2)) big2 big1)))
    (let ((size (bignum-size smallest))
	  (new-bignum (copy-bignum smallest))
	  (other (if (eq? smallest big1) big2 big1)))
      (do ((i 0 (+ i 1)))
	  ((>=
	(set-bignum-digit new-bignum i
			  (fixnum-logand (bignum-digit new-bignum i)
					 (bignum-digit other i)))))))))

(define (%logand x y)
  (cond ((and (bignum? x) (bignum? y)) (bignum-logand x y))
	((and (bignum? x) (fixnum? y)) (fixnum-logand (bignum-digit x 0) y))
	((and (fixnum? x) (bignum? y)) (fixnum-logand (bignum-digit y 0) x))
	((and (fixnum? x) (fixnum? y)) (fixnum-logand x y))))

(define (bignum-logior big bf)
  (if (bignum? bf)
      (let ((smallest (if (> (bignum-size big) (bignum-size bf))
			  bf big)))
	(let ((size (bignum-size smallest))
	      (other (if (eq? smallest big) bf big)))
	  (let ((new-bignum (copy-bignum other)))
	    (do ((i 0 (+ i 1)))
		((>= i size) new-bignum)
	      (set-bignum-digit new-bignum i
				(fixnum-logior (bignum-digit new-bignum i)
					       (bignum-digit smallest i)))))))
      (let ((new (copy-bignum big)))
	(set-bignum-digit new 0 (fixnum-logior (bignum-digit new 0) bf))
	new)))

(define (%logior x y)
  (cond ((and (bignum? x) (bignum? y)) (bignum-logior x y))
	((and (bignum? x) (fixnum? y)) (bignum-logior x y))
	((and (fixnum? x) (bignum? y)) (bignum-logior y x))
	((and (fixnum? x) (fixnum? y)) (fixnum-logior x y))))


(define (make-bit-string ignore) 0)
(define empty-bit-string 0)
(define bit-string-and %logand)
(define bit-string-or %logior)

(define (check-bit bits index)
  (if (fixnum? bits)
      (if (> index *bits-per-fixnum*) NIL
	  (not (zero? (bit-field bits index 1))))
      (let ((word (div index *bits-per-hyperdigit*))
	    (index (mod index *bits-per-hyperdigit*)))
	(and (< word (bignum-size bits))
	     (not (zero? (fixnum-bit-field
			  (bignum-digit bits word) index 1)))))))
(define (bit-string-modify bits index flag)
  (if (fixnum? bits)
      (if (< index *bits-per-fixnum*)
	  (set-bit-field bits index 1 (if flag 1 0))
	  (bit-string-or (ash 1 index) bits))
      (if flag (bignum-logior (ash 1 index) bits)
	  (let ((word (div index *bits-per-hyperdigit*))
		(index (mod index *bits-per-hyperdigit*)))
	    (if (< word (bignum-size bits))
		(let ((new-bits (copy-bignum bits)))
		  (set-bignum-digit new-bits word
				    (set-bit-field (bignum-digit new-bits word)
						   index 1 0)))
		bits)))))
(define bit-string-modify! bit-string-modify)

(define (bit-string-length bits)
  (* (bit-string-size bits) *bits-per-hyperdigit*))

(define (print-bits bitstring)
  (define (bit-print index to-go)
    (cond ((zero? to-go) (newline))
	  ((check-bit bitstring index) (write-char #\1)
	   (bit-print (1+ index) (-1+ to-go)))
	  (else  (write-char #\0)
		 (bit-print (1+ index) (-1+ to-go)))))
  (bit-print 0 (bit-string-length bitstring)))



