;;; -*- Mode: Scheme; Syntax: Scheme; Package: (SCHEME :USE (PSEUDOSCHEME)) -*-

(declare (usual-integrations)
	 (integrate-external "/u/kwh/programs/utility/plus")
	 (integrate-external "/u/kwh/programs/utility/mutable")
	 (integrate-external "/u/kwh/programs/utility/tuple")
	 (integrate-external "/u/kwh/programs/typical/kernel")
	 (integrate-external "/u/kwh/programs/cyrano/rel"))


;;; This file implements a CYRANO configuration.
;;;  CYRANO configuration files do the actual setup of a version
;;;   of CYRANO.  They typically load some set of representations and
;;;   define daemons and operations with respect to that operation.  Then,
;;;   into that framework a `problem', given in the newly loaded representation,
;;;   is loaded.

;;;; Discovery Properties

(focus-property! right-deterministic (<AND> relations potential-foci))
(focus-property! left-deterministic  (<AND> relations potential-foci))

(focus-property! reflexive-relations (<AND> pairings (complement lisp-application-types)))
(focus-property! symmetric-relations (<AND> pairings (complement lisp-application-types)))

(focus-property! abelian-operations (<AND> combining-operations right-deterministic))
(focus-property! associative-operations (<AND> closed-operations right-deterministic))

(add-daemon! (hypothesize anti-reflexive-relations)
	     (<AND> pairings (complement reflexive-relations)))
(add-daemon! (hypothesize anti-symmetric-relations)
	     (<AND> pairings (complement symmetric-relations)))

(add-inference! (<AND> symmetric-relations right-deterministic) left-deterministic)
(add-inference! (<AND> symmetric-relations left-deterministic)  right-deterministic)
(add-inference! (<AND> symmetric-relations (complement right-deterministic))
		(complement left-deterministic))
(add-inference! (<AND> symmetric-relations (complement left-deterministic))
		(complement right-deterministic))

;;;; Proposing Concepts

;;; The cluster abstraction generator.
(process! (concept-generator clustering-abstraction)
	  (foci-class (<AND> symmetric-relations many-to-many)))

;;; Generating new operations:
(process! (concept-generator coalesce-operation) (foci-class combining-operations))
(process! (concept-generator operation->relation)
	  (<AND> potential-foci right-deterministic lisp-application-types))

(process! find-left-extrema
	  (foci-class (<AND> (complement right-deterministic)
			     (complement lisp-application-types))))
(process! find-right-extrema
	  (foci-class (<AND> (complement left-deterministic)
			     (complement lisp-application-types))))

(process! (concept-generator use-operation-as-distance)
	  (foci-class reducing-operations))
(process! (generator-generator generate-iterative-composers)
	  (foci-class reducing-operations))
(process! (generator-generator generate-iterative-combiners)
	  (foci-class reducing-operations))

(define (try-surrendering-on-flip . ignore)
  (if (and current-task (surrender?))
      (sequence
	(message $NL "<<< Aborting execution of task " current-task " at GC.")
	(task-abort #T))))
;(add-gc-daemon! try-surrendering-on-flip)


