;;; -*- Mode: Scheme; Syntax: Scheme; Package: (SCHEME :USE (PSEUDOSCHEME)) -*-

(declare (usual-integrations))
(declare (integrate-external "/u/kwh/programs/utility/plus")
	 (integrate-external "/u/kwh/programs/utility/mutable")
	 (integrate-external "/u/kwh/programs/utility/tuple")
	 (integrate-external "/u/kwh/programs/typical/kernel")
	 (integrate-external "/u/kwh/programs/cyrano/rel"))



;;;; Abstraction operations.

(define satisfaction-relation
  (type "Satisfies-Relation" simple-type
	(lambda (x) (and (tuple? x) (= (length (tuple-elements x)) 2)
			 (type-description? (left x))
			 (satisfies? (right x) (left x))))
	(tuple-product types lisp-objects)))

(define (make-an-abstraction kernel)
  (let ((abstraction-type
	 (type (list ($procedure kernel) "-ABSTRACTION") <AND>
	       (tuple-product (function-range kernel) (function-domain kernel))
	       satisfaction-relation)))
    ((modifier application-implementation) abstraction-type kernel)
    (add-generator! abstraction-type
		    (make-combiner abstraction-type (lambda (i) (tuple (kernel i) i))
				   (function-domain kernel)))
    abstraction-type))
(define abstractions
  (type "Abstractions" generated-collection (subtypes-of satisfaction-relation)))
(define make-abstraction (collection-generator abstractions make-an-abstraction))


;;;; Instantiation functions.

(define (make-instantiation-function abstraction)
  (let ((kernel (application-implementation abstraction)))
    (let ((instantiations (inverse kernel)))
      (define (instantiate x)
	(let ((choices (instantiations x)))
	  (if (defined? choices)
	      (list-ref choices (random (length choices)))
	      (if (tuple? x) (map-tuple instantiate x) x))))
      (function! instantiate (function-range kernel) (function-domain kernel)
		($procedure kernel) "-INSTANTIATE"))))
(define instantiation-function (simple-cache make-instantiation-function))


;;;; Subtype abstractions.

(define (make-subtype-abstraction abstraction)
  (let ((kernel (application-implementation abstraction))
	(instantiate (instantiation-function abstraction)))
    (define (abstract-subtype subtype)
      (let ((abstracted-subtype
	     (type (list "TYPE-ABSTRACTION of " subtype " by " abstraction)
		   image-constraint instantiate subtype)))
	(add-generator! abstracted-subtype
			(make-combiner abstracted-subtype kernel subtype))
	abstracted-subtype))
    (function! abstract-subtype
	       (<AND> (subtypes-of (right-constraints abstraction))
		      (complement lisp-application-types))
	       (subtypes-of (left-constraints abstraction))
	       ($procedure kernel) "-ABSTRACT-TYPE")))
(define subtype-abstraction (simple-cache make-subtype-abstraction))
(name-procedure! subtype-abstraction 'SUBTYPE-ABSTRACTION)


;;;; Tuple type abstractions.

(define (make-tuple-mapper function)
  (function! (lambda (t) (map-tuple function t))
	     (tuple-of (function-domain function))
	     (tuple-of (function-range function))
	     "MAP-" ($procedure function)))
(define tuple-mapper (simple-cache make-tuple-mapper))

(define (make-tuple-abstraction abstraction)
  (let ((kernel (application-implementation abstraction))
	(instantiate (instantiation-function abstraction))
	(type-abstract (subtype-abstraction abstraction)))
    (let ((map-abstract (tuple-mapper kernel))
	  (map-instantiate (tuple-mapper instantiate)))
      (define (abstract-tuple tuple-type)
	(let ((elements (tuple-constraints tuple-type)))
	  (if (eq? tuple-type (apply tuple-product elements))
	      (apply tuple-product (map type-abstract elements))
	      (let ((abstracted-tuple-type 
		      (type (list "TUPLE-ABSTRACTION of " tuple-type " by " abstraction)
			    <AND> (apply tuple-product (map type-abstract elements))
			    (image-constraint map-instantiate tuple-type))))
		(add-generator! abstracted-tuple-type
				(make-combiner abstracted-tuple-type
					       map-abstract tuple-type))
		abstracted-tuple-type))))
      (function! abstract-tuple
		 (<AND> (subtypes-of (tuple-of (right-constraints abstraction)))
			(complement lisp-application-types))
		 (subtypes-of (tuple-of (left-constraints abstraction)))
		 ($procedure kernel) "-ABSTRACT-TUPLE"))))
(define tuple-abstraction (simple-cache make-tuple-abstraction))
(name-procedure! tuple-abstraction 'tuple-abstraction)


;;;; Mapping abstractions.

(define (make-unary-mapping-abstraction abstraction)
  (let ((kernel (application-implementation abstraction))
	(instantiate (instantiation-function abstraction))
	(type-abstract (subtype-abstraction abstraction)))
    (define (abstract-simple-mapping m)
      (let ((domain (right-constraints m)) (range (left-constraints m)))
	(let ((implementation (application-implementation m)))
	  (define (abstracted-implementation input)
	    (let ((instance (instantiate input)))
	      (if (in? instance domain)
		  (kernel (implementation instance))
		  (%undefined))))
	  (type! (list "MAPPING-ABSTRACTION of " m " by " abstraction)
		 lisp-application-type
		 (function! (if (<<? domain (function-range instantiate))
				abstracted-implementation typed-abstracted-implementation)
			    (type-abstract domain) (type-abstract range)
			    "ABSTRACTION-OF-" m)))))
    (function! (simple-cache abstract-simple-mapping)
	       (<AND> lisp-application-types
		      (complement (image-constraint right-constraints
						    (subtypes-of tuples)))
		      (subtypes-of (tuple-product (right-constraints abstraction)
						  (right-constraints abstraction))))
	       (<AND> implemented-operations
		      (subtypes-of (tuple-product (left-constraints abstraction)
						  (left-constraints abstraction))))
	       ($procedure kernel) "-ABSTRACT-MAPPING")))
(define unary-mapping-abstraction (simple-cache make-unary-mapping-abstraction))
(name-procedure! unary-mapping-abstraction 'UNARY-MAPPING-ABSTRACTION)

(define (make-nary-mapping-abstraction abstraction)
  (let ((range-abstract (subtype-abstraction abstraction))
	(domain-abstract (tuple-abstraction abstraction))
	(kernel (application-implementation abstraction))
	(instantiate (instantiation-function abstraction)))
    (define (abstract-complex-mapping m)
      (let ((domain (right-constraints m)) (range (left-constraints m)))
	(let ((implementation (application-implementation m)))
	  (define (abstracted-implementation input)
	    (let ((instance (instantiate input)))
	      (if (in? instance domain) (kernel (implementation instance))
		  (%undefined))))
	  (type! (list "OPERATION-ABSTRACTION of " m " by " abstraction)
		 lisp-application-type
		 (function! (if (<<? domain (function-range instantiate))
				abstracted-implementation typed-abstracted-implementation)
			    (domain-abstract domain) (range-abstract range)
			    "ABSTRACTION-OF-" m)))))
    (function! (simple-cache abstract-complex-mapping)
	       (<AND> implemented-operations
		      (subtypes-of (tuple-product (function-domain range-abstract)
						  (function-domain domain-abstract))))
	       (<AND> lisp-application-types
		      (subtypes-of (tuple-product (function-range range-abstract)
						  (function-range domain-abstract))))
	       ($procedure kernel) "-ABSTRACT-OPERATION")))
(define nary-mapping-abstraction (simple-cache make-nary-mapping-abstraction))
(name-procedure! nary-mapping-abstraction 'NARY-MAPPING-ABSTRACTION)


;;;; Daemon setup.

(add-daemon! (generator-generator subtype-abstraction)
	     (foci-class abstractions))
(add-daemon! (generator-generator tuple-abstraction)
	     (foci-class abstractions))
(add-daemon! (generator-generator unary-mapping-abstraction)
	     (foci-class abstractions))
(add-daemon! (generator-generator nary-mapping-abstraction)
	     (foci-class abstractions))

