(declare (usual-integrations))

(define (profile-primitives thunk)
  (let ((slot (fixed-objects-vector-slot 'PRIMITIVE-PROFILING-TABLE))
	(new
	 (cons (make-vector number-of-internal-primitive-procedures 0)
	       (make-vector number-of-external-primitive-procedures 0)))
	(old))
    (dynamic-wind
     (lambda ()
       (set! old
	     (vector-set! (get-fixed-objects-vector) slot new)))
     thunk
     (lambda ()
       (vector-set! (get-fixed-objects-vector) slot old)))
    (let ((slot (primitive-datum vector-set!)))
      (vector-set! (car new) slot (-1+ (vector-ref (car new) slot))))
    (let ((slot (primitive-datum get-fixed-objects-vector)))
      (vector-set! (car new) slot (-1+ (vector-ref (car new) slot))))
    new))

(define (get-primitive-profiles profiles)
  (let ((internal (car profiles))
	(external (cdr profiles))
	(names
	 (vector-ref (get-fixed-objects-vector)
		     (fixed-objects-vector-slot
		      'MICROCODE-PRIMITIVES-VECTOR))))
    (append!
     (let ((length (vector-length internal)))
       (define (loop index)
	 (cond ((>= index length) '())
	       ((zero? (vector-ref internal index))
		(loop (1+ index)))
	       (else
		(cons (cons (let ((name (vector-ref names index)))
			      (if (pair? name)
				  (car name)
				  name))
			    (vector-ref internal index))
		      (loop (1+ index))))))
       (loop 0))
     (let ((length (vector-length external))
	   (get-external-name (make-primitive-procedure 'GET-EXTERNAL-NAME)))
       (define (loop index)
	 (cond ((>= index length) '())
	       ((zero? (vector-ref external index))
		(loop (1+ index)))
	       (else
		(cons (cons (get-external-name index)
			    (vector-ref external index))
		      (loop (1+ index))))))
       (loop 0)))))

(define (write-profile-report profiles #!optional filename)
  (define (kernel)
    (for-each (lambda (entry)
		(write (car entry))
		(write-string " ")
		(write (cdr entry))
		(newline))
	      (sort (get-primitive-profiles profiles)
		    (lambda (x y)
		      (> (cdr x) (cdr y))))))
  (if (unassigned? filename)
      (kernel)
      (with-output-to-file filename kernel)))