#| -*-Scheme-*-

$Header: free.scm,v 1.1 87/10/16 17:21:44 GMT cph Exp $

Copyright (c) 1987 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Free Variable Analysis

(declare (usual-integrations))

(define free-expression)

(define (free-expressions expressions)
  (if (null? expressions)
      '()
      (eq?-union (free-expression (car expressions))
		 (free-expressions (cdr expressions)))))

(let ()

(set! free-expression
(named-lambda (free-expression expression)
  ((free-dispatch expression) expression)))

(define (free-constant constant)
  '())

(define (free-primitive primitive)
  (list primitive))

(define (free-variable variable)
  (list (variable-name variable)))

(define (free-assignment assignment)
  (assignment-components assignment
    (lambda (name value)
      (eq?-adjoin name (free-expression value)))))

(define (free-lambda lambda)
  (eq?-difference (free-expression (lambda-body lambda))
		  (lambda-bound lambda)))

(define (free-open-block open-block)
  (open-block-components open-block
    (lambda (names declarations body)
      (eq?-difference (free-expression body)
		      names))))

(define (free-definition definition)
  (definition-components definition
    (lambda (name value)
      (error "Free definition encountered.  (PROCEED) to continue."
	     'FREE-DEFINITION name)
      (eq?-remove name (free-expression value)))))

(define (free-combination combination)
  (free-expressions (combination-components combination cons)))

(define (free-sequence sequence)
  (free-expressions (sequence-actions sequence)))

(define (free-conditional conditional)
  (free-expressions (conditional-components conditional list)))

(define (free-disjunction disjunction)
  (free-expressions (disjunction-components disjunction list)))

(define (free-comment comment)
  (free-expression (comment-expression comment)))

(define (free-delay delay)
  (free-expression (delay-expression delay)))

(define (free-access access)
  (free-expression (access-environment access)))

(define (free-in-package in-package)
  (in-package-components in-package
    (lambda (environment expression)
      (scan-defines expression
	(lambda (defined declarations expression*)
	  (eq?-union (free-expression environment)
		     (eq?-difference (free-expression expression*)
				     defined)))))))

(define free-dispatch
  (make-type-dispatcher
   `((,primitive-procedure-type ,free-primitive)
     (,variable-type ,free-variable)
     (,assignment-type ,free-assignment)
     (,definition-type ,free-definition)
     (,sequence-type ,free-sequence)
     (,conditional-type ,free-conditional)
     (,disjunction-type ,free-disjunction)
     (,comment-type ,free-comment)
     (,delay-type ,free-delay)
     (,access-type ,free-access)
     (,in-package-type ,free-in-package)
     (,lambda-type ,free-lambda)
     (,open-block-type ,free-open-block)
     (,combination-type ,free-combination))
   free-constant))

)