/* Copyright  1991 Gustavus Adolphus College.  All rights reserved.
 *
 * Schematik was developed by Gustavus Adolphus College (GAC) with
 * support from NeXT Computer, Inc.  Permission to copy this software,
 * to redistribute it, and to use it for any purpose is granted,
 * subject to the following restrictions and understandings.
 *
 * 1. Any copy made of this software must include this copyright
 * notice in full.
 *
 * 2. Users of this software agree to make their best efforts (a) to
 * return to the GAC Mathematics and Computer Science Department any
 * improvements or extensions that they make, so that these may be
 * included in future releases; and (b) to inform GAC of noteworthy
 * uses of this software.
 *
 * 3. All materials developed as a consequence of the use of this
 * software shall duly acknowledge such use, in accordance with the
 * usual standards of acknowledging credit in academic research.
 *
 * 4. GAC makes no express or implied warranty or representation of
 * any kind with respect to this software, including any warranty
 * that the operation of this software will be error-free.  ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 * PURPOSE IS HEREBY DISCLAIMED.  GAC is under no obligation to
 * provide any services, by way of maintenance, update, or otherwise.
 *
 * 5. In conjunction with products arising from the use of this
 * material, there shall be no use of the name of Gustavus Adolphus
 * College nor of any adaptation thereof in any advertising,
 * promotional, or sales literature without prior written consent
 * from GAC in each case.
 */

// General application macros
#define APPVERSION		"1.1.5.2"
#define APPNAME			"Schematik"
#define DOCUMENTEXTENSION	"scm"

// Macros for names of header files
#define DocText_h		"../Doc.subproj/DocText.h"
#define DocWin_h		"../Doc.subproj/DocWin.h"
#define FindAgent_h		"../Agent.subproj/FindAgent.h"
#define GraphicsView_h		"../Graphics.subproj/GraphicsView.h"
#define HelpAgent_h		"../Agent.subproj/HelpAgent.h"
#define IndentationState_h	"../Doc.subproj/DocText.h"
#define InfoAgent_h		"../Agent.subproj/InfoAgent.h"
#define InteractionWin_h	"../Doc.subproj/InteractionWin.h"
#define Main_h			"../Main.subproj/Main.h"
#define Marker_h		"../Doc.subproj/DocText.h"
#define MyFontPanel_h		"../Main.subproj/Main.h"
#define PrefAgent_h		"../Agent.subproj/PrefAgent.h"
#define SchemeProtocol_h		"../Main.subproj/SchemeProtocol.h"

// Macro constants used in more than one source file
#define BACKUPEXTENSION		"~"
#define BROWSERCOLUMN		0
#define EVALUATING		1
#define FINDBACKWARD		-1
#define FINDFORWARD		1
#define GARBCOLLECT		2
#define GOODFONT1		"Ohlfs"
#define GOODFONT2		"Courier"
#define INPUTSTATE		0
#define NEWLINECHAR		'\n'
#define NEWLINESTRING		"\n"
#define PATHSEPARATOR		'/'
#define PREVIOUS		-1
#define SIGNALABORTPREV		SIGQUIT
#define SIGNALABORTSAME		SIGUSR2
#define SIGNALABORTTOP		SIGINT
#define SIGNALBREAKPOINT	SIGUSR1
#define WHITESPACECHARS		" \n\t\r\v\f"

// Macros for local strings
#define ADDCMDLINEPARAMS	LocalString("Additional command-line parameters",NULL)
#define CMDLINEPARAMS		LocalString("Command-line parameters",NULL)
#define DEFAULTFILENAME		LocalString("~/UNTITLED",NULL)
//
#define ERRORALTERNATE		LocalString("No",NULL)
#define ERRORDEFAULT		LocalString("Yes",NULL)
#define ERRORMESSAGE		LocalString("%s\nAbort computation?",NULL)
#define ERRORTITLE		LocalString("Error",NULL)
#define EVALMESSAGE		LocalString("Evaluating...",NULL)
#define EXECERRORMESSAGE	LocalString("ERROR: Scheme process could not be exec'd.", NULL)
#define FILENAMETEMPLATE	LocalString("%s/English.lproj/Help/%s.rtf",NULL)
#define FILEOPENERROR		LocalString("Could not open file.",NULL)
#define FILESAVEERROR		LocalString("Could not save file.", NULL)
#define FORKERRORMESSAGE	LocalString("Could not vfork to create Scheme process.", NULL)
#define GCMESSAGE		LocalString("Garbage collecting...",NULL)
#define GENERICTITLE		LocalString("Graphics (#%d)",NULL)
#define GRAPHICSPROTOCOLERROR	LocalString("Unimplemented graphics protocol: (ESC G %c)",NULL)
#define HELPBROWSERTITLE	LocalString("Topics",NULL)
#define HELPDIR			LocalString("%s/English.lproj/Help",NULL)
#define HELPPANELTITLE		LocalString("Help",NULL)
#define INTERWINDOWTITLE	LocalString("Interaction Window",NULL)
#define LEVELTITLE		LocalString("Level:",NULL)
#define LICENSEPANELTITLE	LocalString("Licenses",NULL)
#define MEMORYSTREAMERROR	LocalString("Cannot open memory stream.",NULL)
#define NOHELPFILE		LocalString(".NoHelp",NULL)
#define NONPROTOCOLERROR	LocalString("(ESC %c) sequence received from Scheme.  This is not a valid protocol sequence.", NULL)
#define NOTFOUNDMESSAGE		LocalString("Not\nFound",NULL)
#define NOVALUESTRING		LocalString("No value",NULL)
#define OKSTRING		LocalString("OK", NULL)
#define OPENALERTTITLE		LocalString("Open",NULL)
#define PROCESSEXITTERM		LocalString("The scheme process has terminated on exit(%u).",NULL)
#define PROCESSRESTARTBAD	LocalString("The scheme process could NOT be sucessfully restarted.", NULL)
#define PROCESSRESTARTOK	LocalString("The scheme process was restarted.", NULL)
#define PROCESSSIGTERM		LocalString("The scheme process has terminated on signal %u: %s.",NULL)
#define PROCESSSTOPPED		LocalString("The scheme process has stopped on signal %u: %s.",NULL)
#define PROTOCOLERROR		LocalString("Protocol Error", NULL)
//
#define QUERYALTERNATE		LocalString("No",NULL)
#define QUERYDEFAULT		LocalString("Yes",NULL)
#define QUERYTITLE		LocalString("Query",NULL)
#define QUITALERTALTERNATE	LocalString("Quit Anyway",NULL)
#define QUITALERTDEFAULT	LocalString("Review Unsaved",NULL)
#define QUITALERTMESSAGE	LocalString("You have unsaved documents.",NULL)
#define QUITALERTMESSAGE2	LocalString("Save interaction window?",NULL)
#define QUITALERTOTHER		LocalString("Cancel",NULL)
#define QUITALERTTITLE		LocalString("Quit",NULL)
#define REPLACEDMESSAGE		LocalString("%i\nreplaced",NULL)
//
#define RESTARTALTERNATE	LocalString("No",NULL)
#define RESTARTDEFAULT		LocalString("Restart",NULL)
//
#define REVERTALERTALTERNATE	LocalString("No", NULL)
#define REVERTALERTDEFAULT	LocalString("Revert", NULL)
#define REVERTALERTQUERY	LocalString("Do you want to lose changes in %s?", NULL)
#define REVERTALERTTITLE	LocalString("Revert", NULL)
#define SAVEALERTALTERNATE	LocalString("No",NULL)
#define SAVEALERTDEFAULT	LocalString("Save",NULL)
#define SAVEALERTOTHER		LocalString("Cancel",NULL)
#define SAVEALERTQUERY		LocalString("Save changes to %s?", NULL)
#define SAVEALERTTITLE		LocalString("Save", NULL)
#define SAVEERRORMESSAGE	LocalString("An error occurred in saving the file.  Possibly the file is write protected.", NULL)
#define SAVINGMESSAGE		LocalString("saving: %s", NULL)
#define SCHEMEPROCMESSAGE	LocalString("Scheme Process",NULL)
#define SOCKETERRORMESSAGE	LocalString("Could not create socketpair to Scheme process.", NULL)
#define TERMINATIONERRORMESSAGE	LocalString("Scheme process terminated unexpectedly.", NULL)
#define UNIMPLEMENTEDERROR	LocalString("Unimplemented protocol: (ESC %c)", NULL)
#define VALUESTRING		LocalString("Value: ",NULL)


// Menu cell tags.  Names ending in some lowercase characters denote leaves.
#define MENU_INFO	0
#define MENU_INFO_InfoPanel	0
#define MENU_INFO_License	1
#define MENU_INFO_Help		2
#define MENU_INFO_Manual	3
#define MENU_INFO_Preferences	4
#define MENU_DOCUMENT	1
#define MENU_DOCUMENT_Open	0
#define MENU_DOCUMENT_New	1
#define MENU_DOCUMENT_Save	2
#define MENU_DOCUMENT_SaveAs	3
#define MENU_DOCUMENT_Revert	4
#define MENU_DOCUMENT_Close	5
#define MENU_EDIT        2
#define MENU_EDIT_Cut		0
#define MENU_EDIT_Copy		1
#define MENU_EDIT_Paste		2
#define MENU_EDIT_Undo		3
#define MENU_EDIT_FIND		4
#define MENU_EDIT_FIND_FindPanel	0
#define MENU_EDIT_FIND_FindNext		1
#define MENU_EDIT_FIND_FindPrevious	2
#define MENU_EDIT_SelectAll	5
#define MENU_FORMAT	3
#define MENU_FORMAT_FontPanel	0
#define MENU_FORMAT_AdjIndents	1
#define MENU_FORMAT_PageLayout	2
#define MENU_ACTIONS	4
#define MENU_ACTIONS_Evaluate	0
#define MENU_ACTIONS_EvalAll	1
#define MENU_ACTIONS_AbortTop	2
#define MENU_ACTIONS_AbortSame	3
#define MENU_ACTIONS_AbortPrev	4
#define MENU_ACTIONS_Breakpoint	5
#define MENU_Print	5
#define MENU_WINDOWS	6
#define MENU_WINDOWS_Arrange	0
#define MENU_WINDOWS_Miniturize	1
#define MENU_WINDOWS_Close	2
#define MENU_SERVICES	7
#define MENU_Hide	8
#define MENU_Quit	9

// Macros for common operations
#define LoadNIB(file,owned,zone)	[[NXApp prefAgent] loadLocalNib:file owner:owned fromZone:zone]
#define FindMenuCell1(tag1)		[[NXApp mainMenu] findCellWithTag:tag1]
#define FindMenuCell2(tag1,tag2)	[[[[NXApp mainMenu] findCellWithTag:tag1] target] findCellWithTag:tag2]
#define FindMenuCell3(tag1,tag2,tag3)	[[[[[[NXApp mainMenu] findCellWithTag:tag1] target] findCellWithTag:tag2] target] findCellWithTag:tag3]
#define EnableMenuItem(cell)		[cell setEnabled:YES]
#define DisableMenuItem(cell)		[cell setEnabled:NO]

// Macros for debugging

#define DEBUG
#undef DEBUG

#ifdef DEBUG
  #import <stdio.h>
  #import <objc/Object.h>
  #define DEBUGLEVEL		3
  #define DEBUGTHRESHOLD	3
  #define DEBUG_OUTFILE		stderr
  #define DEBUG_VERSION		APPNAME " version " APPVERSION ".\n  Source file " __FILE__ " last compiled on " __DATE__ " at " __TIME__ "\n"
  #define DEBUG_PUTS(string)	fputs(string, DEBUG_OUTFILE)
  #define DEBUG_PRINTF		fprintf(DEBUG_OUTFILE,
  #define DEBUG_PRINTFIF(x)	if (x) DEBUG_PRINTF
  #define DEBUG_ASSERT(x)	if (!(x)) DEBUG_PRINTF "Assertion: %s failed in source file: %s line: %i\n",#x,__FILE__,__LINE__);
  #define DEBUG_ASSERTIF(x,y)	if ((x)&&!(y)) DEBUG_PRINTF "Assertion: %s failed in source file: %s line: %i\n",#y,__FILE__,__LINE__);
  #define DEBUG_FUNC1		doDebug

void translateencoding(char *, void *, int);

  #define doDebug(level)		\
    {					\
      unsigned int i,numargs;					\
      Method thisMeth;						\
      BOOL inClassMethod=!NXOrderStrings((unsigned char *)@encode(typeof(self)),(unsigned char *)"#",YES,-1,NULL);	\
      switch(level)						\
        {							\
         case 4 : DEBUG_PUTS(DEBUG_VERSION);			\
                  break;					\
         case 3 : DEBUG_PRINTF "In class: %s, ",__FILE__);	\
         case 2 : thisMeth=(inClassMethod?class_getClassMethod(isa,_cmd):class_getInstanceMethod(isa,_cmd));		\
                  numargs=method_getNumberOfArguments(thisMeth);		\
                  DEBUG_PRINTF "%s called",sel_getName(_cmd));			\
		  if (2<numargs) DEBUG_PRINTF " with: ");			\
                  for(i=2; i<numargs; i++)					\
                    {								\
                      char *type;						\
                      int offset;						\
                      method_getArgumentInfo(thisMeth,i,&type,&offset);		\
                      translateencoding(type,&self,offset);			\
                    }								\
                  DEBUG_PRINTF "\n");						\
                  break;							\
         case 1 : DEBUG_PRINTF "%s called.\n", sel_getName(_cmd));		\
                  break;							\
         default: break;							\
       }								\
   }

#else
  #define DEBUG_ASSERT(x)	{}
  #define DEBUG_ASSERTIF(x,y)	{}
  #define DEBUG_FUNC1(x)	{}
#endif /* DEBUG */
