/* Copyright  1991 Gustavus Adolphus College.  All rights reserved.
 *
 * Schematik was developed by Gustavus Adolphus College (GAC) with
 * support from NeXT Computer, Inc.  Permission to copy this software,
 * to redistribute it, and to use it for any purpose is granted,
 * subject to the following restrictions and understandings.
 *
 * 1. Any copy made of this software must include this copyright
 * notice in full.
 *
 * 2. Users of this software agree to make their best efforts (a) to
 * return to the GAC Mathematics and Computer Science Department any
 * improvements or extensions that they make, so that these may be
 * included in future releases; and (b) to inform GAC of noteworthy
 * uses of this software.
 *
 * 3. All materials developed as a consequence of the use of this
 * software shall duly acknowledge such use, in accordance with the
 * usual standards of acknowledging credit in academic research.
 *
 * 4. GAC makes no express or implied warranty or representation of
 * any kind with respect to this software, including any warranty
 * that the operation of this software will be error-free.  ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 * PURPOSE IS HEREBY DISCLAIMED.  GAC is under no obligation to
 * provide any services, by way of maintenance, update, or otherwise.
 *
 * 5. In conjunction with products arising from the use of this
 * material, there shall be no use of the name of Gustavus Adolphus
 * College nor of any adaptation thereof in any advertising,
 * promotional, or sales literature without prior written consent
 * from GAC in each case.
 */

#import "defines.h"
#import "Main.h"
#import "Agent.subproj/PrefAgent.h"
#import "Main.subproj/SchemeProtocol.h"
#import <stdlib.h>
#import <string.h>
#import <syslog.h>

#define NIBFILE	"Schematik.nib"

char *stlchr(const char *, int);
static void exit_monitor(void);
char *appDirectory;

void main(int argc, char *argv[])
{
    atexit(exit_monitor);
    appDirectory = stlchr(NXCopyStringBuffer(argv[0]), PATHSEPARATOR);
    NXApp = [Main new];
    DEBUG_ASSERT(NXApp!=nil)
    [[NXApp prefAgent] loadLocalMainMenu:NIBFILE];
    [NXApp addWindowsItem:[NXApp interactionWindow] title:INTERWINDOWTITLE filename:NO];
    [NXApp run];
    [NXApp free];
    exit(0);
}

static void exit_monitor()
{
    if(schemePid){
      int result=kill(schemePid, 9);
      if (result<0)
        syslog(LOG_WARNING|LOG_LOCAL1, "Scheme kill unsuccessful in exit_monitor().  Scheme pid:%i  errno=%i (%s).", schemePid, errno, strerror(errno));
      else
        schemePid=0;
    }
  }

char *stlchr(char *path, int chr)
{
    int x=strlen(path);

    while (x)
      if (path[--x]==chr)
        {
          path[x] = '\0';
          break;
        }
    return (path);
}

#ifdef DEBUG
void translateencoding(char *encoding, void *argFrame, int offset)
{
    switch (*encoding)
      {
	case _C_CHR : DEBUG_PRINTF "(char)%c ",marg_getValue(argFrame,offset,char)); break;
	case _C_UCHR: DEBUG_PRINTF "(unsigned char)%c ",marg_getValue(argFrame,offset,unsigned char)); break;
	case _C_INT : DEBUG_PRINTF "(int)%i ",marg_getValue(argFrame,offset,int)); break;
	case _C_UINT: DEBUG_PRINTF "(unsigned)%u ",marg_getValue(argFrame,offset,unsigned)); break;
	case _C_SHT : DEBUG_PRINTF "(short)%hi ",marg_getValue(argFrame,offset,short)); break;
	case _C_USHT: DEBUG_PRINTF "(unsigned short)%hu ",marg_getValue(argFrame,offset,unsigned short)); break;
	case _C_LNG : DEBUG_PRINTF "(long)%li ",marg_getValue(argFrame,offset,long)); break;
	case _C_ULNG: DEBUG_PRINTF "(unsigned long)%lu ",marg_getValue(argFrame,offset,unsigned long)); break;
	case _C_FLT : DEBUG_PRINTF "(float)%g ",marg_getValue(argFrame,offset,double)); break;
	case _C_DBL : DEBUG_PRINTF "(double)%g ",marg_getValue(argFrame,offset,double)); break;
	case _C_VOID: DEBUG_PRINTF "(void) "); break;
	case _C_SEL : DEBUG_PRINTF "(SEL)%s ",sel_getName(marg_getValue(argFrame,offset,SEL))); break;
	case _C_ID  : DEBUG_PRINTF "(id)%s ",[marg_getValue(argFrame,offset,id) name]); break;
	case _C_BFLD: DEBUG_PRINTF "(bitfield)%i ",marg_getValue(argFrame,offset,int)); break;
	case _C_CHARPTR : DEBUG_PRINTF "(char *)%s ",marg_getValue(argFrame,offset,char *)); break;
	case _C_CLASS   : DEBUG_PRINTF "(Class)%s ",marg_getValue(argFrame,offset,Class)->name); break;
	case _C_ARY_B   : DEBUG_PRINTF "(array) "); break;
	case _C_STRUCT_B: DEBUG_PRINTF "(struct) "); break;
	case _C_UNION_B : DEBUG_PRINTF "(union) "); break;
	case _C_PTR     : DEBUG_PRINTF "(pointer) "); break;
	case _C_UNDEF   : DEBUG_PRINTF "<unknown> "); break;
	default         : DEBUG_PRINTF "<unsupported> "); break;
      }
}
#endif
