/* Copyright  1991 Gustavus Adolphus College.  All rights reserved.
 *
 * Schematik was developed by Gustavus Adolphus College (GAC) with
 * support from NeXT Computer, Inc.  Permission to copy this software,
 * to redistribute it, and to use it for any purpose is granted,
 * subject to the following restrictions and understandings.
 *
 * 1. Any copy made of this software must include this copyright
 * notice in full.
 *
 * 2. Users of this software agree to make their best efforts (a) to
 * return to the GAC Mathematics and Computer Science Department any
 * improvements or extensions that they make, so that these may be
 * included in future releases; and (b) to inform GAC of noteworthy
 * uses of this software.
 *
 * 3. All materials developed as a consequence of the use of this
 * software shall duly acknowledge such use, in accordance with the
 * usual standards of acknowledging credit in academic research.
 *
 * 4. GAC makes no express or implied warranty or representation of
 * any kind with respect to this software, including any warranty
 * that the operation of this software will be error-free.  ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 * PURPOSE IS HEREBY DISCLAIMED.  GAC is under no obligation to
 * provide any services, by way of maintenance, update, or otherwise.
 *
 * 5. In conjunction with products arising from the use of this
 * material, there shall be no use of the name of Gustavus Adolphus
 * College nor of any adaptation thereof in any advertising,
 * promotional, or sales literature without prior written consent
 * from GAC in each case.
 */

#import <appkit/Text.h>

@interface DocText:Text
{
    id	markerList;
    id	indentationState;
}

- appendNewlineIfNeeded;
- appendText:(const char *)aString commented:(BOOL)aBoolean withNewline:(BOOL)aBoolean2;
- (STR)getAll;
- (STR)getSelection;
- setInsertionBar:(int)anInt;
- (BOOL)selectScope;
- (BOOL)selectScope2;
- saveSelectionState;
- restoreSelectionState;
- formatTextSelectionOnly:(BOOL)aBoolean;
- (int)stringSearch:(const char *)theTarget forAgent:theAgent direction:(int)direction ignoreCase:(BOOL)ignorecase  wholeWord:(BOOL)wholeword inSel:(BOOL)inSel;

@end

#define MARKLEFT	-10
#define MARKCENTER	0
#define MARKRIGHT	10

@interface Marker:Object
{
           int	charpos;
   signed char	type;
}

- initAt:(int)anInt type:(signed char)aChar;

- (int)markerPosition;
- adjustTo:(int)anInt forPositionsFrom:(int)begin to:(int)end andAfterBy:(int)anInt2;
- adjustTo:(int)anInt;

@end

@interface IndentationState:Object
{
  id text;
  int knownLine;
  NXStream *stream;
  void *contexts;
  BOOL inString;
  int keywordListVersion;
}

- changeAt:(int)position;
- initText:text;
- (int)determineIndentation:(int)line;
- setupStream;
- scanLine;
- (int)indent;
- describeSelf;

@end
