/* Copyright  1991 Gustavus Adolphus College.  All rights reserved.
 *
 * Schematik was developed by Gustavus Adolphus College (GAC) with
 * support from NeXT Computer, Inc.  Permission to copy this software,
 * to redistribute it, and to use it for any purpose is granted,
 * subject to the following restrictions and understandings.
 *
 * 1. Any copy made of this software must include this copyright
 * notice in full.
 *
 * 2. Users of this software agree to make their best efforts (a) to
 * return to the GAC Mathematics and Computer Science Department any
 * improvements or extensions that they make, so that these may be
 * included in future releases; and (b) to inform GAC of noteworthy
 * uses of this software.
 *
 * 3. All materials developed as a consequence of the use of this
 * software shall duly acknowledge such use, in accordance with the
 * usual standards of acknowledging credit in academic research.
 *
 * 4. GAC makes no express or implied warranty or representation of
 * any kind with respect to this software, including any warranty
 * that the operation of this software will be error-free.  ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 * PURPOSE IS HEREBY DISCLAIMED.  GAC is under no obligation to
 * provide any services, by way of maintenance, update, or otherwise.
 *
 * 5. In conjunction with products arising from the use of this
 * material, there shall be no use of the name of Gustavus Adolphus
 * College nor of any adaptation thereof in any advertising,
 * promotional, or sales literature without prior written consent
 * from GAC in each case.
 */

#import "InfoAgent.h"
#import "../defines.h"
#import Main_h
#import PrefAgent_h
#import <appkit/Matrix.h>
#import <mach.h>

#define NIBFILE1	"Info.nib"
#define NIBFILE2	"Licenses.nib"
#define INFOZONENAME	"InfoAgnt"
static id theAgent=nil;

@implementation InfoAgent

+ new
{
DEBUG_FUNC1(DEBUGLEVEL);
    if (theAgent==nil)
      {
        NXZone *tempZone;

        tempZone = NXCreateZone(vm_page_size, vm_page_size, YES);
        DEBUG_ASSERT(tempZone!=NULL)
        theAgent = self = [super allocFromZone:tempZone];
	agentZone = tempZone;
	NXNameZone(agentZone, INFOZONENAME);
      }
    return theAgent;
}

- activateAgent:sender
{
DEBUG_FUNC1(DEBUGLEVEL);
    switch ([sender tag])
      {
        case MENU_INFO_InfoPanel: if (!infoPanel)
                                    {
				      infoPanel = LoadNIB(NIBFILE1, theAgent, agentZone);
				      DEBUG_ASSERT(infoPanel!=nil)
				      [infoPanel useOptimizedDrawing:YES];
				    }
				  [infoPanel makeKeyAndOrderFront:self];
				  break;
        case MENU_INFO_License  : if (!licensePanel)
				    {
				      licensePanel = LoadNIB(NIBFILE2, theAgent, agentZone);
				      DEBUG_ASSERT(licensePanel!=nil)
				      [licensePanel useOptimizedDrawing:YES];
				      [licensePanel setTitle:LICENSEPANELTITLE];
				    }
				  [licensePanel center];
				  [licensePanel makeKeyAndOrderFront:self];
      }
    return self;
}

@end

@implementation InfoAgent (Delegate)

- windowWillClose:sender
{
DEBUG_FUNC1(DEBUGLEVEL);
    if ([sender isEqual:infoPanel])
      infoPanel = nil;
    else if ([sender isEqual:licensePanel])
      licensePanel = nil;
    return self;
}

@end
