#| -*-Scheme-*-

debug/read-eval-print modified by Max Hailperin <max@nic.gac.edu>
on September 21, 1991 to replace "Type C-c C-u" with the more generic
"Use Abort to Previous" for the benefit of Schematik.

$Header: dbgcmd.scm,v 14.10 90/11/02 02:06:08 GMT cph Rel $

Copyright (c) 1988, 1989, 1990 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Debugger Command Loop Support
;;; package: (runtime debugger-command-loop)

(declare (usual-integrations))

(define (make-command-set name definitions)
  (let ((command-set (list name)))
    (for-each (lambda (entry)
		(define-letter-command command-set
		  (car entry)
		  (if (eq? standard-help-command (cadr entry))
		      (standard-help-command command-set)
		      (cadr entry))
		  (caddr entry)))
	      definitions)
    command-set))

(define (define-letter-command command-set new-command function help-text)
  (let ((entry (assv new-command (cdr command-set))))
    (if entry
	(set-cdr! entry (list function help-text))
	(let loop ((command-set command-set))
	  (if (or (null? (cdr command-set))
		  (char<? new-command (caadr command-set)))
	      (set-cdr! command-set
			(cons (list new-command function help-text)
			      (cdr command-set)))
	      (loop (cdr command-set)))))))

(define (letter-commands command-set message prompt state)
  (with-standard-proceed-point
   (lambda ()
     (push-cmdl letter-commands/driver
		(vector command-set prompt state)
		message
		make-cmdl))))

(define (letter-commands/driver cmdl)
  (let ((command-set (vector-ref (cmdl/state cmdl) 0))
	(prompt (vector-ref (cmdl/state cmdl) 1))
	(state (vector-ref (cmdl/state cmdl) 2)))
    (let loop ()
      (let ((char (char-upcase (prompt-for-command-char prompt cmdl))))
	(with-output-to-port (cmdl/output-port cmdl)
	  (lambda ()
	    (let ((entry (assv char (cdr command-set))))
	      (if entry
		  ((cadr entry) state)
		  (begin
		    (beep)
		    (newline)
		    (write-string "Unknown command char: ")
		    (write char)
		    (loop)))))))))
  (cmdl-message/null))

(define ((standard-help-command command-set) state)
  state					;ignore
  (for-each (lambda (entry)
	      (newline)
	      (write-string "   ")
	      (write-char (car entry))
	      (write-string "   ")
	      (write-string (caddr entry)))
	    (cdr command-set))
  unspecific)

(define (standard-exit-command state)
  state					;ignore
  (proceed))

(define (initialize-package!)
  (set! hook/leaving-command-loop default/leaving-command-loop))

(define hook/leaving-command-loop)

(define (leaving-command-loop thunk)
  (hook/leaving-command-loop thunk))

(define (default/leaving-command-loop thunk)
  (thunk))

(define (debug/read-eval-print environment from to prompt)
  (leaving-command-loop
   (lambda ()
     (read-eval-print
      environment
      (cmdl-message/standard
       (string-append
	"You are now in " to ".  Use Abort to Previous to return to " from "."))
      prompt))))

(define (debug/eval expression environment)
  (leaving-command-loop
   (lambda ()
     (eval expression environment))))

(define (debug/scode-eval expression environment)
  (leaving-command-loop
   (lambda ()
     (extended-scode-eval expression environment))))

(define (debug/where environment)
  (leaving-command-loop
   (lambda ()
     (where environment))))