(##declare
  (multilisp)
  (extended-bindings)
  (not safe)
  (not autotouch)
  (block)
  (fixnum)
  (not intr-checks))

;------------------------------------------------------------------------------

; Drawing window

(define clear-graphics #f)
(define position-pen #f)
(define draw-line-to #f)
(define draw-point #f)
(define clear-point #f)
(define graphics-text #f)

(let ()

  (define y-max   200.) ; must be inexact (flonum)
  (define x-max   200.) ;   "        "
  (define scaling 1.)   ;   "        "

  (define (cx x)
    (##flonum.->fixnum
      (##flonum.* (##flonum.+ x-max (##real-part (##exact->inexact x)))
                  scaling)))

  (define (cy y)
    (##flonum.->fixnum
      (##flonum.* (##flonum.+ y-max (##real-part (##exact->inexact y)))
                  scaling)))

  (let* ((width (##flonum.->fixnum (##flonum.* (##flonum.* 2. x-max) scaling)))
         (height (##flonum.->fixnum (##flonum.* (##flonum.* 2. y-max) scaling)))
         (pen-x0 (cx 0))
         (pen-y0 (cy 0))
         (pen-x #f)
         (pen-y #f)
         (w #f))

    (define (init)
      (set! pen-x pen-x0)
      (set! pen-y pen-y0)
      (set! w (##x-open-window "Drawing" width height))
      (if w (##x-clear-window w)))

    (define (clear)
      (if w (##x-clear-window w) (init)))

    (define (add action)
      (if (not w) (init))
      (if w (action)))

    (define (make-position-pen x y)
      (lambda ()
        (set! pen-x x)
        (set! pen-y y)))

    (define (make-draw-line-to x y)
      (lambda ()
        (##x-draw-line w 1 pen-x pen-y x y)
        (set! pen-x x)
        (set! pen-y y)))

    (define (make-draw-point x y)
      (lambda ()
        (##x-draw-line w 1 x y x y)))

    (define (make-clear-point x y)
      (lambda ()
        (##x-draw-line w 0 x y x y)))

    (define (make-graphics-text text x y)
      (lambda ()
        (##x-draw-string w 1 x y text)))

    (set! clear-graphics
      (lambda () (clear) #f))

    (set! position-pen
      (lambda (x y) (add (make-position-pen (cx x) (cy y))) #f))

    (set! draw-line-to
      (lambda (x y) (add (make-draw-line-to (cx x) (cy y))) #f))

    (set! draw-point
      (lambda (x y) (add (make-draw-point (cx x) (cy y))) #f))

    (set! clear-point
      (lambda (x y) (add (make-clear-point (cx x) (cy y))) #f))

    (set! graphics-text
      (lambda (text x y)
        (if (##string? text) (add (make-graphics-text text (cx x) (cy y))))
        #f))))

;------------------------------------------------------------------------------
