/* gcv.c, Author: Marc Feeley (08/01/90) */

/*

This program converts Gambit .O files (object files) into .o files
that can be linked with 'glk' to form an executable program.

The .O file is first transformed into a C file and then compiled
with cc.

To convert the file 'file.O' it should be called like this

   gcv file

*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>


/*---------------------------------------------------------------------------*/

/* string utils */


char *alloc( n )
int n;
{ char *p = (char *)malloc( n );
  if (p == NULL)
  { fprintf( stderr, "Error: out of memory\n" ); exit(1); }
  return p;
}


int string_length( str )
char *str;
{ int len = 0;
  while (*(str++) != '\0') len++;
  return len;
}


char *string_extend( ptr, str )
char *ptr, *str;
{ while (*str != '\0') *(ptr++) = *(str++);
  *ptr = '\0';
  return ptr;
}


char *string_append( str1, str2 )
char *str1, *str2;
{ char *p1;
  p1 = alloc( string_length( str1 ) + string_length( str2 ) + 1 );
  string_extend( string_extend( p1, str1 ), str2 );
  return p1;
}


/*---------------------------------------------------------------------------*/


FILE *input, *output;

short *data;

char *argvect[10];


/*---------------------------------------------------------------------------*/


char *filename_tail( str )
char *str;
{ char *s = str, *p = str;
  while (*p != '\0') if (*(p++) == '/') s = p;
  return s;
}


void generate_filename_key( output, str )
FILE *output;
char *str;
{ char *s = filename_tail( str );
  while (*s != '\0')
  { char c = *(s++);
    if (((c>='a') && (c<='z')) || ((c>='0') && (c<='9')) || (c=='_'))
      fprintf( output, "%c", c );
    else
      fprintf( output, "X%02x", (c & 0xff) );
  }
}


void main( argc, argv )
int argc;
char *argv[];
{ struct stat stats;
  int i, j, n;
  char *o_file, *O_file, *c_file;

  if (argc != 2)
  { fprintf( stderr, "Error: a file name must be supplied\n" ); exit(1); }

  o_file = string_append( argv[1], ".o" );
  O_file = string_append( argv[1], ".O" );
  c_file = string_append( argv[1], ".c" );

  input = fopen( O_file, "r" );
  if (input == NULL)
  { fprintf( stderr, "Error: can't open input file\n" ); exit(1); }

  output = fopen( c_file, "w" );
  if (output == NULL)
  { fprintf( stderr, "Error: can't open output file\n" ); exit(1); }

  /* get info from input file */

  if (fstat( fileno(input), &stats ) != 0)
  { fprintf( stderr, "Error: could not stat input\n" ); exit(1); }

  if ((stats.st_size <= 0) || (stats.st_size & 1 != 0))
  { fprintf( stderr, "Error: alignment error\n" ); exit(1); }

  data = (short *)alloc( stats.st_size );

  if (fread( (char *)data, 1, stats.st_size, input ) != stats.st_size)
  { fprintf( stderr, "Error: read error\n" ); exit(1); }

  fprintf( output, "short link_ofile_" );
  generate_filename_key( output, argv[1] );
  fprintf( output, "[] =\n{" );

  i = 0;
  n = stats.st_size/2;
  while (i < n)
  { if (i % 8 == 0) fprintf( output, "\n/*%08X*/", i*2 );
    fprintf( output, " 0x%04X", (data[i++] & 0xffff) );
    if (i != n) fprintf( output, "," );
  }
  fprintf( output, "\n};\n\nlong link_sizeof_ofile_" );
  generate_filename_key( output, argv[1] );
  fprintf( output, " = sizeof link_ofile_" );
  generate_filename_key( output, argv[1] );
  fprintf( output, ";\n" );

  fclose( output );

  i = fork();
  if (i == -1)
  { fprintf( stderr, "Error: can't fork\n" ); exit(1); }

  if (i == 0)
  { int argcount = 0;
    argvect[argcount++] = "cc";
    argvect[argcount++] = "-c";
    argvect[argcount++] = c_file;
    argvect[argcount++] = NULL;
    execv( "/bin/cc", argvect );
    fprintf( stderr, "Error: can't call up 'cc'\n" ); exit(1);
  }

  j = wait( &n );
  unlink( c_file );
  if ((j != i) || (n != 0)) exit(1);

  rename( string_append( filename_tail( argv[1] ), ".o" ), o_file );

  exit(0);
}


/*---------------------------------------------------------------------------*/
