(##include "header.scm")

(##declare (not intr-checks))

;------------------------------------------------------------------------------

; Procedures to support multitasking

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

; (##read-not-ready ind) is called when there is an attempt to read from a
; port that does not yet contain chars (i.e. the read would normally block).
; ##read-not-ready should always return -1.

(define ##read-not-ready #f)
(set! ##read-not-ready
  (lambda (ind)
    (if (not (##switch-task)) ; block only if no other tasks to run
      (##os-file-block-read ind))
    -1))

; (##write-not-ready ind) is called when there is an attempt to write to a
; port that is not ready to accept characters (i.e. the write would normally
; block).  ##write-not-ready should always return -1.

(define ##write-not-ready #f)
(set! ##write-not-ready
  (lambda (ind)
    (if (not (##switch-task)) ; block only if no other tasks to run
      (##os-file-block-write ind))
    -1))

; (##switch-task) is called when control is to be passed to another task
; (usually at the end of the quantum, but possibly before).

(define ##quantum 0)

(define (##set-quantum x)
  (set! ##quantum x)
  (##os-set-timer-interval x))

(define (##switch-task)
  (###_kernel.switch-task))

; (##add-timer-interrupt-job thunk) can be called to add another
; job to do on timer interrupts.  (##clear-timer-interrupt-jobs) clears
; the jobs.

(define ##timer-interrupt-jobs #f)

(define (##add-timer-interrupt-job thunk)
  (##add-job ##timer-interrupt-jobs thunk))

(define (##clear-timer-interrupt-jobs)
  (set! ##timer-interrupt-jobs (##make-jobs))
  (##add-timer-interrupt-job
    (lambda ()
      (let loop ()
        (let ((proc ##handle-os-event))
          (if (and (##procedure? proc)
                   (##eq? ##handle-os-event-enable #t))
            (let ((event (##os-get-next-event))) ; get event from OS
              (and event (proc event) (loop)))))))))

(##clear-timer-interrupt-jobs)

; (##timer-interrupt) is called periodically, based on VIRTUAL (cpu) time.
; The interval is set by a call to (##os-set-timer-interval x), where 'x'
; is the time expressed in milliseconds.

(define ##timer-interrupt-enable #f)
(set! ##timer-interrupt-enable #t)

(define ##handle-os-event-enable #f)
(set! ##handle-os-event-enable #t)

(define ##timer-interrupt #f)
(set! ##timer-interrupt
  (lambda ()
    (if (##eq? ##timer-interrupt-enable #t)
      (begin
        (##invoke-jobs ##timer-interrupt-jobs)
        (##switch-task)))))

(##set-quantum 100) ; 10 task switches per second

; (##handle-os-event event) is called when the OS has generated an
; event and ##handle-os-event-enable is #t.  The meaning of 'event' is
; OS dependent.  Events that can't be handled by the application
; should be passed back to the OS by a call to ##os-handle-event for
; further processing.  ##handle-os-event should return #t to go on to
; the next event immediately or #f to wait until the next timer
; interrupt.

(define ##handle-os-event #f)
(set! ##handle-os-event
  (lambda (event)
    (##os-handle-event event)))

; (##add-gc-finalize-job thunk) can be called to add another job to do
; after a GC.  (##clear-gc-finalize-jobs) clears the jobs.

(define ##gc-finalize-jobs #f)

(define (##add-gc-finalize-job thunk)
  (##add-job ##gc-finalize-jobs thunk))

(define (##clear-gc-finalize-jobs)
  (set! ##gc-finalize-jobs (##make-jobs)))

(##clear-gc-finalize-jobs)

(define ##gc-finalize #f)
(set! ##gc-finalize
  (lambda ()
    (##invoke-jobs ##gc-finalize-jobs)))

;------------------------------------------------------------------------------
