/* zprototypes.h adapted from prototypes.h
 * allow both new, old style function definitions. must declare
 *       int f(int a,float b)
 *  as
 *       int ZDECLARE2(f,int,a,float,b)
 *
 * BEWARE in using this, the declarations MUST be in the proper order-
 * when converting a k&r style declaration e.g.
 *      foo(a,b,c)
 *      int a,c; float b;
 * the type declarations can be out of order.
 *
 * modified
 * 9apr
 */

/*
 * Copyright (c) 1991, 1992 Sam Leffler
 * Copyright (c) 1991, 1992 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

#if Eansi
# define	ZDECLARE1(f,t1,a1)		f(t1 a1)
# define	ZDECLARE2(f,t1,a1,t2,a2)		f(t1 a1, t2 a2)
# define	ZDECLARE3(f,t1,a1,t2,a2,t3,a3)	f(t1 a1, t2 a2, t3 a3)
# define	ZDECLARE4(f,t1,a1,t2,a2,t3,a3,t4,a4)\
	f(t1 a1, t2 a2, t3 a3, t4 a4)
# define	ZDECLARE5(f,t1,a1,t2,a2,t3,a3,t4,a4,t5,a5)\
	f(t1 a1, t2 a2, t3 a3, t4 a4, t5 a5)
# define	ZDECLARE6(f,t1,a1,t2,a2,t3,a3,t4,a4,t5,a5,t6,a6)\
	f(t1 a1, t2 a2, t3 a3, t4 a4, t5 a5, t6 a6)
# define	ZDECLARE1V(f,t1,a1)		f(t1 a1 ...)
# define	ZDECLARE2V(f,t1,a1,t2,a2)	f(t1 a1, t2 a2, ...)
# define	ZDECLARE3V(f,t1,a1,t2,a2,t3,a3)	f(t1 a1, t2 a2, t3 a3, ...)
#else /*!Eansi*/
# define	ZDECLARE1(f,t1,a1)		f(a1) t1 a1;
# define	ZDECLARE2(f,t1,a1,t2,a2)		f(a1,a2) t1 a1; t2 a2;
# define	ZDECLARE3(f,t1,a1,t2,a2,t3,a3)	f(a1,a2,a3) t1 a1; t2 a2; t3 a3;
# define	ZDECLARE4(f,t1,a1,t2,a2,t3,a3,t4,a4) \
	f(a1, a2, a3, a4) t1 a1; t2 a2; t3 a3; t4 a4;
# define	ZDECLARE5(f,t1,a1,t2,a2,t3,a3,t4,a4,t5,a5)\
	f(a1, a2, a3, a4, a5) t1 a1; t2 a2; t3 a3; t4 a4; t5 a5;
# define	ZDECLARE6(f,t1,a1,t2,a2,t3,a3,t4,a4,t5,a5,t6,a6)\
	f(a1, a2, a3, a4, a5, a6) t1 a1; t2 a2; t3 a3; t4 a4; t5 a5; t6 a6;
# if Evarargs
# define	ZDECLARE1V(f,t1,a1) \
	f(a1, va_alist) t1 a1; va_dcl
# define	ZDECLARE2V(f,t1,a1,t2,a2) \
	f(a1, a2, va_alist) t1 a1; t2 a2; va_dcl
# define	ZDECLARE3V(f,t1,a1,t2,a2,t3,a3) \
	f(a1, a2, a3, va_alist) t1 a1; t2 a2; t3 a3; va_dcl
# else
 "I don't know how to handle this case: !USE_PROTOTYPES and !USE_VARARGS?"
# endif /*!Evarargs*/
#endif /*!Eansi*/
