;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/runtime0.0/Llib/float.scm ...                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 13 18:21:07 1993                          */
;*    Last change :  Mon Dec 13 18:50:58 1993 (serrano)                */
;*    -------------------------------------------------------------    */
;*    L'infernal trippotage des floats                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __caml_bfloat
   (foreign (obj c-format_float (obj obj) "format_float"))
   (export  (inline c-int_of_float x)
	    (inline c-float_of_int x)
	    (inline c-~float x)
	    (inline c-+float x y)
	    (inline c--float x y)
	    (inline c-*float x y)
	    (inline c-/ x y)
	    (inline c-=float x y)
	    (inline c-<>float x y)
	    (inline c-<float x y)
	    (inline c->float x y)
	    (inline c-<=float x y)
	    (inline c->=float x y)
	    (inline c-exp_float x)
	    (inline c-log_float x)
	    (inline c-sqrt_float x)
	    (inline c-power_float x y)
	    (inline c-sin_float x)
	    (inline c-cos_float x)
	    (inline c-tan_float x)
	    (inline c-asin_float x)
	    (inline c-acos_float x)
	    (inline c-atan_float x)
	    (inline c-atan2_float x y)
	    (inline c-float_of_string x)))

;*---------------------------------------------------------------------*/
;*    int_of_float ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (c-int_of_float x)
   (flonum->fixnum x))

;*---------------------------------------------------------------------*/
;*    c-float_of_int ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (c-float_of_int x)
   (fixnum->flonum x))

;*---------------------------------------------------------------------*/
;*    c-~float ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (c-~float x)
   (negfl x))

;*---------------------------------------------------------------------*/
;*    c-+float ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (c-+float x y)
   (+fl x y))

;*---------------------------------------------------------------------*/
;*    c--float ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (c--float x y)
   (-fl x y))

;*---------------------------------------------------------------------*/
;*    c-*float ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (c-*float x y)
   (*fl x y))

;*---------------------------------------------------------------------*/
;*    c-/ ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (c-/ x y)
   (/fl x y))

;*---------------------------------------------------------------------*/
;*    c-=float ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (c-=float x y)
   (=fl x y))

;*---------------------------------------------------------------------*/
;*    c-<>float ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (c-<>float x y)
   (not (=fl x y)))

;*---------------------------------------------------------------------*/
;*    c-=<float ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (c-<float x y)
   (<fl x y))

;*---------------------------------------------------------------------*/
;*    c->float ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (c->float x y)
   (>fl x y))

;*---------------------------------------------------------------------*/
;*    c-<=float ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (c-<=float x y)
   (<=fl x y))

;*---------------------------------------------------------------------*/
;*    c->=float ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (c->=float x y)
   (>=fl x y))

;*---------------------------------------------------------------------*/
;*    c-exp_float ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (c-exp_float x)
   (expfl x))

;*---------------------------------------------------------------------*/
;*    c-log_float ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (c-log_float x)
   (logfl x))

;*---------------------------------------------------------------------*/
;*    c-sqrt_float ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (c-sqrt_float x)
   (sqrtfl x))

;*---------------------------------------------------------------------*/
;*    c-power_float ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (c-power_float x y)
   (exptfl x y))

;*---------------------------------------------------------------------*/
;*    c-sin_float ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (c-sin_float x)
   (sinfl x))

;*---------------------------------------------------------------------*/
;*    c-cos_float ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (c-cos_float x)
   (cosfl x))

;*---------------------------------------------------------------------*/
;*    c-tan_float ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (c-tan_float x)
   (tanfl x))

;*---------------------------------------------------------------------*/
;*    c-asin_float ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (c-asin_float x)
   (asinfl x))

;*---------------------------------------------------------------------*/
;*    c-acos_float ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (c-acos_float x)
   (acosfl x))

;*---------------------------------------------------------------------*/
;*    c-atan_float ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (c-atan_float x)
   (atanfl x))

;*---------------------------------------------------------------------*/
;*    c-atan_float ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (c-atan2_float x y)
   (atanfl x y))

;*---------------------------------------------------------------------*/
;*    c-float_of_string ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (c-float_of_string x)
   (string->real x))



   

