;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/comptime0.0/Camloo/lprim.scm ...               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec  1 10:55:09 1993                          */
;*    Last change :  Fri Feb 11 15:00:24 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La compilation des formes Lprim                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module Lprim
   (include "Camloo/var.sch")
   (import  llambda
	    var
	    lconst
	    ldefine
	    module
	    generate)
   (export  (Lprim exp tl? cp)))

;*---------------------------------------------------------------------*/
;*    is-function? ...                                                 */
;*---------------------------------------------------------------------*/
(define (is-function? exp)
   (match-case exp
      ((lshared ?exp ?-)
       (is-function? exp))
      ((lfunction . ?-)
       #t)
      ((Lletrec ?- ?body)
       (is-function? body))
      ((Llet ?- ?body)
       (is-function? body))
      (else
       #f)))
       
;*---------------------------------------------------------------------*/
;*    Lprim ...                                                        */
;*---------------------------------------------------------------------*/
(define (Lprim exp tl? cp)
   (match-case (cdr exp)
      ((Pidentity (?rest))
       (llambda rest tl? cp))
      (((Pset_global (qualifiedident ?module ?name)) (?value))
       (Pset_global exp tl? cp))
      (((Pget_global (qualifiedident ?module ?name)) ())
       (remember-module! module)
       (get-global name module))
      (((Pdummy ?int) ())
       `(caml-allocate-regular-constr ,int))
      ((Pupdate (?exp1 ?exp2))
       (if (is-function? exp2)
	   ;; cas bizzare qui semble etre genere pour les streams
	   `(set! ,(llambda exp1 #f cp) ,(llambda exp2 #f cp))
	   `(caml-constr-update! ,(llambda exp1 #f cp) ,(llambda exp2 #f cp))))
      (((Ptest ?test) (?e1 ?e2))
       `(,(Ptest test) ,(llambda e1 #f cp) ,(llambda e2 #f cp)))
      (((Pmakeblock ?constr) ?values)
       (Pmakeblock constr values cp))
      ((Ptag-of (?e))
       `(tag-of ,(llambda e #f cp)))
      (((Pfield ?int) (?e))
       (Pfield int e cp))
      (((Psetfield ?int) (?exp ?value))
       (Psetfield int exp value cp))
      (((pccall ?call ?n) ?args)
       `(,(symbol-append 'c- call) ,@(map (lambda (v) (llambda v #f cp))
					  args)))
      ((Praise (?value))
       `(raise ,(llambda value #f cp)))
      ((Pnot (?e))
       `(not ,(llambda e #f cp)))
      ((Pnegint (?e))
       `(negfx ,(llambda e #f cp)))
      ((Psuccint (?e))
       `(+fx ,(llambda e #f cp) 1))
      ((Ppredint (?e))
       `(-fx ,(llambda e #f cp) 1))
      ((Paddint (?e1 ?e2))
       `(+fx ,(llambda e1 #f cp) ,(llambda e2 #f cp)))
      ((Psubint (?e1 ?e2))
       `(-fx ,(llambda e1 #f cp) ,(llambda e2 #f cp)))
      ((Pmulint (?e1 ?e2))
       `(*fx ,(llambda e1 #f cp) ,(llambda e2 #f cp)))
      ((Pdivint (?e1 ?e2))
       `(/fx ,(llambda e1 #f cp) ,(llambda e2 #f cp)))
      ((Pmodint (?e1 ?e2))
       `(modulo ,(llambda e1 #f cp) ,(llambda e2 #f cp)))
      ((Pandint (?e1 ?e2))
       `(bit-and ,(llambda e1 #f cp) ,(llambda e2 #f cp)))
      ((Porint (?e1 ?e2))
       `(bit-or ,(llambda e1 #f cp) ,(llambda e2 #f cp)))
      ((Pxorint (?e1 ?e2))
       `(bit-xor ,(llambda e1 #f cp) ,(llambda e2 #f cp)))
      ((Pshiftleftint (?e1 ?e2))
       `(bit-lsh ,(llambda e1 #f cp) ,(llambda e2 #f cp)))
      ((Pshiftrightintsigned (?e1 ?e2))
       `(bit-rsh ,(llambda e1 #f cp) ,(llambda e2 #f cp)))
      ((Pshiftrightintunsigned (?e1 ?e2))
       `(bit-ursh ,(llambda e1 #f cp) ,(llambda e2 #f cp)))
      ((Pincr (?e))
       `(let ((e ,(llambda e #f cp))) 
	   (caml-constr-set-field!
	    e 0 (+fx (caml-constr-get-field e 0) 1))))
      ((Pdecr (?e))
       `(let ((e ,(llambda e #f cp)))
	   (caml-constr-set-field!
	    e 0 (-fx (caml-constr-get-field e 0) 1))))
      ((Pintoffloat (?e))
       `(flonum->fixnum ,(llambda e #f cp)))
      (((Pfloatprim ?f) ?e)
       `(,(Pfloatprim f) ,@(map (lambda (v) (llambda v #f cp)) e)))
      ((Pstringlength (?e))
       `(string-length ,(llambda e #f cp)))
      ((Pgetstringchar (?e1 ?e2))
       `(string-ref ,(llambda e1 #f cp) ,(llambda e2 #f cp)))
      ((Psetstringchar (?e1 ?e2 ?e3))
       `(string-set! ,(llambda e1 #f cp)
		     ,(llambda e2 #f cp)
		     ,(llambda e3 #f cp)))
      ((Pmakevector (?e1 ?e2))
       `(make-vector ,(llambda e1 #f cp) ,(llambda e2 #f cp)))
      ((Pvectlength (?e))
       (let ((v (gensym)))
	  `(let ((,v ,(llambda e #f cp)))
	      (if ,v
		  (vector-length ,v)
		  0))))
      ((Pgetvectitem (?e1 ?e2))
       `(vector-ref ,(llambda e1 #f cp) ,(llambda e2 #f cp)))
      ((Psetvectitem (?e1 ?e2 ?e3))
       `(vector-set! ,(llambda e1 #f cp)
		     ,(llambda e2 #f cp)
		     ,(llambda e3 #f cp)))
      (else
       (error "lprim" "Unknow primitives" exp))))

;*---------------------------------------------------------------------*/
;*    Pmakeblock ...                                                   */
;*    -------------------------------------------------------------    */
;*    Il faut faire attention au cas particulier des `cons'. Ce        */
;*    n'est pas tres joli mais on recupere ce cas a la vollee.         */
;*---------------------------------------------------------------------*/
(define (Pmakeblock constr values cp)
   (match-case constr
      ((ConstrRegular (qualifiedident ?module ?name) ?- ?-)
       (if (and (string=? module "builtin")
		(string=? name "::"))
	   `(cons ,@(map (lambda (v) (llambda v #f cp)) values))
	   `(,(if (ConstrExtensible? constr)
		  'caml-make-extensible
		  'caml-make-regular)
	     ,(constr-tag constr)
	     ,(length values)
	     ,@(map (lambda (v) (llambda v #f cp))
		    values))))
      (else
       `(,(if (ConstrExtensible? constr)
	      'caml-make-extensible
	      'caml-make-regular)
	 ,(constr-tag constr)
	 ,(length values)
	 ,@(map (lambda (v) (llambda v #f cp))
		values)))))

;*---------------------------------------------------------------------*/
;*    Pfield ...                                                       */
;*    -------------------------------------------------------------    */
;*    Il existe plusieurs facons de faire un `Pfield'. Le chois        */
;*    de la methode depend des proprietes eventuelles de               */
;*    l'expression qu'on dereference.                                  */
;*    -------------------------------------------------------------    */
;*    Jusqu'a present il y a trois cas:                                */
;*       - les variables servant d'indice aux boucles `for'            */
;*       - les constructeurs constants qui ont ete alloues dans des    */
;*         `cons'                                                      */
;*       - tous les autres                                             */
;*---------------------------------------------------------------------*/
(define (Pfield int e cp)
   (let* ((be   (llambda e #f cp))
	  (prop (get-constr-prop be cp)))
      (case prop
	 ((for-indice)
	  be)
	 ((::)
	  (if (=fx int 0)
	      `(car ,be)
	      `(cdr ,be)))
	 (else
	  `(caml-constr-get-field ,be ,int)))))

;*---------------------------------------------------------------------*/
;*    Psetfield ...                                                    */
;*    -------------------------------------------------------------    */
;*    Meme remarque que pour la precedente fonction.                   */
;*---------------------------------------------------------------------*/
(define (Psetfield int exp value cp)
   (let* ((be   (llambda exp #f cp))
	  (prop (get-constr-prop be cp))
	  (ve   (llambda value #f cp)))
      (case prop
	 ((for-indice)
	  `(set! ,be ,ve))
	 ((::)
	  `(,(if (=fx int 0) 'set-car! 'set-cdr!) ,be ,ve))
	 (else
	  `(caml-constr-set-field! ,be ,int ,ve)))))

;*---------------------------------------------------------------------*/
;*    Ptest ...                                                        */
;*---------------------------------------------------------------------*/
(define (Ptest test)
   (match-case test
      (Peq
       'eq?)
      (Pnoteq_test
       '(lambda (x y) (not (eq? x y))))
      ((Pint_test ?op)
       (Pint_test op))
      ((Pfloat_test ?op)
       (Pfloat_test op))
      ((Pstring_test ?op)
       (Pstring_test op))
      (else
       `(todo-Ptest ,test))))

;*---------------------------------------------------------------------*/
;*    Pint_test ...                                                    */
;*---------------------------------------------------------------------*/
(define (Pint_test op)
   (case op
      ((PTeq)               '=fx)
      ((PTnoteq PTnoteqimm) '(lambda (x y) (not (eq? x y))))
      ((PTlt)               '<fx)
      ((PTle)               '<=fx)
      ((PTgt)               '>fx)
      ((PTge)               '>=fx)))

;*---------------------------------------------------------------------*/
;*    Pfloat_test ...                                                  */
;*---------------------------------------------------------------------*/
(define (Pfloat_test op)
   (case op
      ((PTeq)               '=fl)
      ((PTnoteq PTnoteqimm) '(lambda (x y) (not (eq? x y))))
      ((PTlt)               '<fl)
      ((PTle)               '<=fl)
      ((PTgt)               '>fl)
      ((PTge)               '>=fl)))

;*---------------------------------------------------------------------*/
;*    Pstring_test ...                                                 */
;*---------------------------------------------------------------------*/
(define (Pstring_test op)
   (case op
      ((PTeq)               'string)
      ((PTnoteq PTnoteqimm) '(lambda (x y) (not (eq? x y))))
      ((PTlt)               'string)
      ((PTle)               'string)
      ((PTgt)               'string)
      ((PTge)               'string>=)))

;*---------------------------------------------------------------------*/
;*    Pfloatprim ...                                                   */
;*---------------------------------------------------------------------*/
(define (Pfloatprim f)
   (case f
      ((Pfloatofint)
       'fixnum->flonum)
      ((Pnegfloat)
       'negfl)
      ((Paddfloat)
       '+fl)
      ((Psubfloat)
       '-fl)
      ((Pmulfloat)
       '*fl)
      ((Pdivfloat)
       '/fl)))

      
   
