;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/comptime0.0/Camloo/generate.scm ...            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec  1 09:36:49 1993                          */
;*    Last change :  Thu Jan 27 15:07:46 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On genere le fichier resultat                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module generate
   (include "Camloo/var.sch")
   (import  init
	    misc
	    var
	    module)
   (export  (remember-exp!             exp)
	    (remember-unspecified-var! var)
	    (generate-module!)))

;*---------------------------------------------------------------------*/
;*    Quelques variables globales                                      */
;*---------------------------------------------------------------------*/
(define *all-exp*             '())
(define *all-unspecified-var* '())

;*---------------------------------------------------------------------*/
;*    remember-unspecified-var! ...                                    */
;*---------------------------------------------------------------------*/
(define (remember-unspecified-var! var)
   (set! *all-unspecified-var* (cons var *all-unspecified-var*)))

;*---------------------------------------------------------------------*/
;*    remember-exp! ...                                                */
;*---------------------------------------------------------------------*/
(define (remember-exp! exp)
   (set! *all-exp* (cons exp *all-exp*)))

;*---------------------------------------------------------------------*/
;*    generate-module! ...                                             */
;*---------------------------------------------------------------------*/
(define (generate-module!)
   ;; la declaration de module
   (fprint *pout*
	   ";; Le module " #\Newline
	   (generate-module-declaration)
	   #\Newline #\Newline)
   ;; L'initialisation du module
   (fprint *pout* ";; L'initialisation du module" #\Newline)
   (fprint *pout* "(init_camloo!)" #\Newline)
   ;; les definitions des variables globales rajoutees
   (fprint *pout* ";; Les variables globales " #\Newline)
   (for-each (lambda (var)
		(write `(define ,(shape var) (unspecified)))
		(newline *pout*))
	     *all-unspecified-var*)
   (newline *pout*)
   ;; Les expressions
   (fprint *pout* ";; Les expressions globales " #\Newline)
   (for-each (lambda (exp)
		(my-write (shape exp) *pout*)
		(newline *pout*))
	     (reverse! *all-exp*)))

;*---------------------------------------------------------------------*/
;*    generate-module-declaration ...                                  */
;*---------------------------------------------------------------------*/
(define (generate-module-declaration)
   (define (make-exported-prototypes l)
      (let loop ((l l)
		 (r '()))
	 (if (null? l)
	     r
	     (let ((p (car l)))
		(cond
		   ((not (global-exported? p))
		    (loop (cdr l) r))
		   ((not (eq? (global-module p) *module*))
		    (loop (cdr l) r))
		   ((not (global-function? p))
		    (loop (cdr l) (cons (shape p) r)))
		   (else
		    (loop (cdr l) (cons `(,(shape p)
					  ,@(map shape (global-arity p)))
					r))))))))
   (define (make-one-import module shape suffix)
      (let ((cell (assq (string->symbol (string-upcase shape))
			*module-alist*))
	    (file (getprop (string->symbol (string-upcase module))
			   'file-name)))
	 (cond
	    ((pair? cell)
	     (list shape))
	    ((string? file)
	     (let ((full-name (string-append file suffix)))
		(if (file-exists? full-name)
		    (list (list shape (string-append "\""  full-name "\"" )))
		    '())))
	    (else
	     (if (file-exists? (string-append module suffix))
		 (list (list shape (string-append "\"" module suffix "\"" )))
		 '())))))
   (define (make-imported-clauses m)
      (let* ((shape  (module-shape "__caml_" m))
	     (shapei (module-shape "__camli_" m))
	     (res    (append (make-one-import m shape ".scm")
			     (make-one-import m shapei ".sci"))))
	 (if (null? res)
	     (error "camloo" "Can't find module" m)
	     res)))
   (let ((modules  (get-imported-modules))
	 (exported (make-exported-prototypes (get-all-global))))
      `(module ,(module-shape "__caml_" *module-name*)
	  (foreign (include "\"caml-bigloo.h\""))
	  (import ,@(let loop ((modules modules)
			       (res     '()))
		       (if (null? modules)
			   res
			   (loop (cdr modules)
				 (append (make-imported-clauses (car modules))
					 res)))))
	  (export ,@exported))))

;*---------------------------------------------------------------------*/
;*    my-write ...                                                     */
;*---------------------------------------------------------------------*/
(define (my-write obj port)
   (cond
      ((vector? obj)
       (my-write-vector obj port))
      ((pair? obj)
       (my-write-pair obj port))
      ((string? obj)
       (display "#\"" port)
       (display obj)
       (write-char #\"))
      (else
       (write obj port))))

;*---------------------------------------------------------------------*/
;*    my-write-vector ...                                              */
;*---------------------------------------------------------------------*/
(define (my-write-vector obj port)
   (write-char #\# port)
   (write-char #\( port)
   (if (=fx 0 (vector-length obj))
       (write-char #\) port)
       (let ((len (-fx (vector-length obj) 1)))
	  (let loop ((i 0))
	     (if (=fx i len)
		 (begin
		    (my-write (vector-ref obj i) port)
		    (write-char #\) port))
		 (begin
		    (my-write (vector-ref obj i) port)
		    (write-char #\space port)
		    (loop (+fx 1 i))))))))
 
;*---------------------------------------------------------------------*/
;*    my-write-pair ...                                                */
;*---------------------------------------------------------------------*/
(define (my-write-pair obj port)
   (write-char #\( port)
   (let loop ((l obj))
      (cond
	 ((null? (cdr l))
	  (my-write (car l) port)
	  (write-char #\) port))
	 ((not (pair? (cdr l)))
	  (my-write (car l) port)
	  (write-char #\space port)
	  (write-char #\. port)
	  (write-char #\space port)
	  (my-write (cdr l) port)
	  (write-char #\) port))
	 (else
	  (my-write (car l) port)
	  (write-char #\space port)
	  (loop (cdr l))))))
